/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script.rhino;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.script.rhino.RhinoInterpreter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

class EventTargetWrapper
extends NativeJavaObject {
    private NativeJavaMethod methodadd;
    private NativeJavaMethod methodremove;
    private static final String ADD_NAME = "addEventListener";
    private static final String REMOVE_NAME = "removeEventListener";
    private static final Class[] ARGS_TYPE = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$w3c$dom$events$EventListener == null ? (class$org$w3c$dom$events$EventListener = EventTargetWrapper.class$("org.w3c.dom.events.EventListener")) : class$org$w3c$dom$events$EventListener, Boolean.TYPE};
    private static final String NAME = "name";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$w3c$dom$events$EventListener;

    EventTargetWrapper(Scriptable scriptable, EventTarget eventTarget) {
        super(scriptable, (Object)eventTarget, (Class)null);
        try {
            HashMap hashMap = new HashMap(2);
            this.methodadd = new RhinoNativeJavaAddMethod(eventTarget.getClass().getMethod(ADD_NAME, ARGS_TYPE), ADD_NAME, hashMap);
            this.methodremove = new RhinoNativeJavaRemoveMethod(eventTarget.getClass().getMethod(REMOVE_NAME, ARGS_TYPE), REMOVE_NAME, hashMap);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public Object get(String string, Scriptable scriptable) {
        if (string.equals(ADD_NAME)) {
            return this.methodadd;
        }
        if (string.equals(REMOVE_NAME)) {
            return this.methodremove;
        }
        return super.get(string, scriptable);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class RhinoNativeJavaRemoveMethod
    extends NativeJavaMethod {
        Map listenerMap;
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$org$mozilla$javascript$Function;
        static /* synthetic */ Class class$org$mozilla$javascript$Scriptable;

        RhinoNativeJavaRemoveMethod(Method method, String string, Map map) {
            super(method, string);
            this.listenerMap = map;
        }

        public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
            NativeJavaObject nativeJavaObject = (NativeJavaObject)scriptable2;
            if (objectArray[1] instanceof Function) {
                EventListener eventListener = (EventListener)this.listenerMap.remove(objectArray[1]);
                if (eventListener == null) {
                    return Undefined.instance;
                }
                Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = RhinoNativeJavaRemoveMethod.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Function == null ? (class$org$mozilla$javascript$Function = RhinoNativeJavaRemoveMethod.class$("org.mozilla.javascript.Function")) : class$org$mozilla$javascript$Function, Boolean.TYPE};
                int n = 0;
                while (n < objectArray.length) {
                    objectArray[n] = Context.toType((Object)objectArray[n], (Class)classArray[n]);
                    ++n;
                }
                ((EventTarget)nativeJavaObject.unwrap()).removeEventListener((String)objectArray[0], eventListener, (Boolean)objectArray[2]);
                return Undefined.instance;
            }
            if (objectArray[1] instanceof NativeObject) {
                EventListener eventListener = (EventListener)this.listenerMap.remove(objectArray[1]);
                if (eventListener == null) {
                    return Undefined.instance;
                }
                Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = RhinoNativeJavaRemoveMethod.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = RhinoNativeJavaRemoveMethod.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable, Boolean.TYPE};
                int n = 0;
                while (n < objectArray.length) {
                    objectArray[n] = Context.toType((Object)objectArray[n], (Class)classArray[n]);
                    ++n;
                }
                ((EventTarget)nativeJavaObject.unwrap()).removeEventListener((String)objectArray[0], eventListener, (Boolean)objectArray[2]);
                return Undefined.instance;
            }
            return super.call(context, scriptable, scriptable2, objectArray);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class RhinoNativeJavaAddMethod
    extends NativeJavaMethod {
        Map listenerMap;
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$org$mozilla$javascript$Function;
        static /* synthetic */ Class class$org$mozilla$javascript$Scriptable;

        RhinoNativeJavaAddMethod(Method method, String string, Map map) {
            super(method, string);
            this.listenerMap = map;
        }

        public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
            NativeJavaObject nativeJavaObject = (NativeJavaObject)scriptable2;
            if (objectArray[1] instanceof Function) {
                FunctionEventListener functionEventListener = new FunctionEventListener((Function)objectArray[1], ((RhinoInterpreter.ExtendedContext)context).getInterpreter());
                this.listenerMap.put(objectArray[1], functionEventListener);
                Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = RhinoNativeJavaAddMethod.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Function == null ? (class$org$mozilla$javascript$Function = RhinoNativeJavaAddMethod.class$("org.mozilla.javascript.Function")) : class$org$mozilla$javascript$Function, Boolean.TYPE};
                int n = 0;
                while (n < objectArray.length) {
                    objectArray[n] = Context.toType((Object)objectArray[n], (Class)classArray[n]);
                    ++n;
                }
                ((EventTarget)nativeJavaObject.unwrap()).addEventListener((String)objectArray[0], functionEventListener, (Boolean)objectArray[2]);
                return Undefined.instance;
            }
            if (objectArray[1] instanceof NativeObject) {
                HandleEventListener handleEventListener = new HandleEventListener((Scriptable)objectArray[1]);
                this.listenerMap.put(objectArray[1], handleEventListener);
                Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = RhinoNativeJavaAddMethod.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = RhinoNativeJavaAddMethod.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable, Boolean.TYPE};
                int n = 0;
                while (n < objectArray.length) {
                    objectArray[n] = Context.toType((Object)objectArray[n], (Class)classArray[n]);
                    ++n;
                }
                ((EventTarget)nativeJavaObject.unwrap()).addEventListener((String)objectArray[0], handleEventListener, (Boolean)objectArray[2]);
                return Undefined.instance;
            }
            return super.call(context, scriptable, scriptable2, objectArray);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class HandleEventListener
    implements EventListener {
        private static final String HANDLE_EVENT = "handleEvent";
        private Scriptable scriptable;
        private Object[] array = new Object[1];

        HandleEventListener(Scriptable scriptable) {
            this.scriptable = scriptable;
        }

        public void handleEvent(Event event) {
            try {
                this.array[0] = event;
                ScriptableObject.callMethod((Scriptable)this.scriptable, (String)HANDLE_EVENT, (Object[])this.array);
            }
            catch (JavaScriptException javaScriptException) {
                throw new WrappedException((Throwable)javaScriptException);
            }
        }
    }

    static class FunctionEventListener
    implements EventListener {
        private Function function;
        private RhinoInterpreter interpreter;

        FunctionEventListener(Function function, RhinoInterpreter rhinoInterpreter) {
            this.function = function;
            this.interpreter = rhinoInterpreter;
        }

        public void handleEvent(Event event) {
            try {
                this.interpreter.callHandler(this.function, event);
            }
            catch (JavaScriptException javaScriptException) {
                throw new WrappedException((Throwable)javaScriptException);
            }
        }
    }
}

