/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.list;

import com.jgoodies.binding.list.ObservableList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public final class LinkedListModel
extends LinkedList
implements ObservableList {
    private static final long serialVersionUID = 5753378113505707237L;
    protected EventListenerList listenerList;
    static /* synthetic */ Class class$javax$swing$event$ListDataListener;

    public LinkedListModel() {
    }

    public LinkedListModel(Collection c) {
        super(c);
    }

    public void add(int index, Object element) {
        super.add(index, element);
        this.fireIntervalAdded(index, index);
    }

    public boolean add(Object o) {
        int newIndex = this.size();
        super.add(o);
        this.fireIntervalAdded(newIndex, newIndex);
        return true;
    }

    public boolean addAll(int index, Collection c) {
        boolean changed = super.addAll(index, c);
        if (changed) {
            int lastIndex = index + c.size() - 1;
            this.fireIntervalAdded(index, lastIndex);
        }
        return changed;
    }

    public void addFirst(Object o) {
        super.addFirst(o);
        this.fireIntervalAdded(0, 0);
    }

    public void addLast(Object o) {
        int newIndex = this.size();
        super.addLast(o);
        this.fireIntervalAdded(newIndex, newIndex);
    }

    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        int oldLastIndex = this.size() - 1;
        super.clear();
        this.fireIntervalRemoved(0, oldLastIndex);
    }

    public Object remove(int index) {
        Object removedElement = super.remove(index);
        this.fireIntervalRemoved(index, index);
        return removedElement;
    }

    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public Object removeFirst() {
        Object first = super.removeFirst();
        this.fireIntervalRemoved(0, 0);
        return first;
    }

    public Object removeLast() {
        int lastIndex = this.size() - 1;
        Object last = super.removeLast();
        this.fireIntervalRemoved(lastIndex, lastIndex);
        return last;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        super.removeRange(fromIndex, toIndex);
        this.fireIntervalRemoved(fromIndex, toIndex - 1);
    }

    public Object set(int index, Object element) {
        Object previousElement = super.set(index, element);
        this.fireContentsChanged(index, index);
        return previousElement;
    }

    public ListIterator listIterator(int index) {
        return new ReportingListIterator(super.listIterator(index));
    }

    public void addListDataListener(ListDataListener l) {
        this.getEventListenerList().add(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = LinkedListModel.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener, l);
    }

    public void removeListDataListener(ListDataListener l) {
        this.getEventListenerList().remove(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = LinkedListModel.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener, l);
    }

    public Object getElementAt(int index) {
        return this.get(index);
    }

    public int getSize() {
        return this.size();
    }

    public void fireContentsChanged(int index) {
        this.fireContentsChanged(index, index);
    }

    public ListDataListener[] getListDataListeners() {
        return (ListDataListener[])this.listenerList.getListeners(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = LinkedListModel.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener);
    }

    private void fireContentsChanged(int index0, int index1) {
        Object[] listeners = this.getEventListenerList().getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ListDataListener == null ? LinkedListModel.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (e == null) {
                e = new ListDataEvent(this, 0, index0, index1);
            }
            ((ListDataListener)listeners[i + 1]).contentsChanged(e);
        }
    }

    private void fireIntervalAdded(int index0, int index1) {
        Object[] listeners = this.getEventListenerList().getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ListDataListener == null ? LinkedListModel.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (e == null) {
                e = new ListDataEvent(this, 1, index0, index1);
            }
            ((ListDataListener)listeners[i + 1]).intervalAdded(e);
        }
    }

    private void fireIntervalRemoved(int index0, int index1) {
        Object[] listeners = this.getEventListenerList().getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ListDataListener == null ? LinkedListModel.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (e == null) {
                e = new ListDataEvent(this, 2, index0, index1);
            }
            ((ListDataListener)listeners[i + 1]).intervalRemoved(e);
        }
    }

    private EventListenerList getEventListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        return this.listenerList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ReportingListIterator
    implements ListIterator {
        private final ListIterator delegate;
        private int lastReturnedIndex;

        ReportingListIterator(ListIterator delegate) {
            this.delegate = delegate;
            this.lastReturnedIndex = -1;
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public Object next() {
            this.lastReturnedIndex = this.nextIndex();
            return this.delegate.next();
        }

        public boolean hasPrevious() {
            return this.delegate.hasPrevious();
        }

        public Object previous() {
            this.lastReturnedIndex = this.previousIndex();
            return this.delegate.previous();
        }

        public int nextIndex() {
            return this.delegate.nextIndex();
        }

        public int previousIndex() {
            return this.delegate.previousIndex();
        }

        public void remove() {
            int oldSize = LinkedListModel.this.size();
            this.delegate.remove();
            int newSize = LinkedListModel.this.size();
            if (newSize < oldSize) {
                LinkedListModel.this.fireIntervalRemoved(this.lastReturnedIndex, this.lastReturnedIndex);
            }
        }

        public void set(Object o) {
            this.delegate.set(o);
        }

        public void add(Object o) {
            this.delegate.add(o);
            int newIndex = this.previousIndex();
            LinkedListModel.this.fireIntervalAdded(newIndex, newIndex);
            this.lastReturnedIndex = -1;
        }
    }
}

