/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ComboBoxAdapter
extends AbstractListModel
implements ComboBoxModel {
    protected final SelectionInList selectionInList;
    private ValueModel selectionHolder;
    private PropertyChangeListener selectionInListValueChangeHandler;
    private PropertyChangeListener selectionChangeHandler;

    public ComboBoxAdapter(List items, ValueModel selectionHolder) {
        this(new SelectionInList(items), selectionHolder, false);
    }

    public ComboBoxAdapter(ListModel listModel, ValueModel selectionHolder) {
        this(new SelectionInList(listModel), selectionHolder, false);
    }

    public ComboBoxAdapter(Object[] items, ValueModel selectionHolder) {
        this(new SelectionInList(items), selectionHolder, false);
    }

    public ComboBoxAdapter(ValueModel listHolder, ValueModel selectionHolder) {
        this(new SelectionInList(listHolder), selectionHolder, false);
    }

    public ComboBoxAdapter(SelectionInList selectionInList) {
        this(selectionInList, null, true);
    }

    protected ComboBoxAdapter(SelectionInList selectionInList, ValueModel selectionHolder, boolean inListOnly) {
        if (!inListOnly && selectionHolder == null) {
            throw new NullPointerException("The selectionHolder must not be null");
        }
        this.selectionInList = selectionInList;
        this.selectionHolder = selectionHolder;
        this.selectionChangeHandler = new SelectionHolderValueChangeHandler();
        if (selectionHolder != null) {
            selectionInList.setValue(selectionHolder.getValue());
            selectionHolder.addValueChangeListener(this.selectionChangeHandler);
        }
        this.selectionInListValueChangeHandler = new SelectionInListValueChangeHandler();
        selectionInList.addValueChangeListener(this.selectionInListValueChangeHandler);
        selectionInList.addListDataListener(new ListDataChangeHandler());
    }

    public Object getSelectedItem() {
        if (this.selectionHolder != null) {
            return this.selectionHolder.getValue();
        }
        return this.selectionInList.getValue();
    }

    public void setSelectedItem(Object object) {
        if (this.selectionHolder != null) {
            this.selectionHolder.setValue(object);
        } else {
            this.selectionInList.setValue(object);
        }
    }

    public int getSize() {
        return this.selectionInList.getSize();
    }

    public Object getElementAt(int index) {
        return this.selectionInList.getElementAt(index);
    }

    private void updateSelectionHolderSilently(Object newValue) {
        if (this.selectionHolder == null) {
            return;
        }
        this.selectionHolder.removeValueChangeListener(this.selectionChangeHandler);
        this.selectionHolder.setValue(newValue);
        this.selectionHolder.addValueChangeListener(this.selectionChangeHandler);
    }

    private void updateSelectionInListSilently(Object newValue) {
        this.selectionInList.removeValueChangeListener(this.selectionInListValueChangeHandler);
        this.selectionInList.setValue(newValue);
        this.selectionInList.addValueChangeListener(this.selectionInListValueChangeHandler);
    }

    private class ListDataChangeHandler
    implements ListDataListener {
        private ListDataChangeHandler() {
        }

        public void intervalAdded(ListDataEvent evt) {
            ComboBoxAdapter.this.fireIntervalAdded(ComboBoxAdapter.this, evt.getIndex0(), evt.getIndex1());
        }

        public void intervalRemoved(ListDataEvent evt) {
            ComboBoxAdapter.this.fireIntervalRemoved(ComboBoxAdapter.this, evt.getIndex0(), evt.getIndex1());
        }

        public void contentsChanged(ListDataEvent evt) {
            ComboBoxAdapter.this.fireContentsChanged(ComboBoxAdapter.this, evt.getIndex0(), evt.getIndex1());
        }
    }

    private class SelectionHolderValueChangeHandler
    implements PropertyChangeListener {
        private SelectionHolderValueChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ComboBoxAdapter.this.updateSelectionInListSilently(evt.getNewValue());
            ComboBoxAdapter.this.fireContentsChanged(ComboBoxAdapter.this, -1, -1);
        }
    }

    private class SelectionInListValueChangeHandler
    implements PropertyChangeListener {
        private SelectionInListValueChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ComboBoxAdapter.this.updateSelectionHolderSilently(evt.getNewValue());
            ComboBoxAdapter.this.fireContentsChanged(ComboBoxAdapter.this, -1, -1);
        }
    }
}

