/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.start;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.mortbay.start.Classpath;
import org.mortbay.start.Monitor;
import org.mortbay.start.Version;

public class Main {
    static boolean _debug = System.getProperty("DEBUG", null) != null;
    private String _classname = null;
    private Classpath _classpath = new Classpath();
    private String _config = System.getProperty("START", "org/mortbay/start/start.config");
    private ArrayList _xml = new ArrayList();
    private boolean _version = false;

    public static void main(String[] args) {
        try {
            if (args.length > 0 && args[0].equalsIgnoreCase("--help")) {
                System.err.println("Usage: java [-DDEBUG] [-DSTART=start.config] [-Dmain.class=org.MyMain] -jar start.jar [--help|--stop|--version] [config ...]");
                System.exit(1);
            } else if (args.length > 0 && args[0].equalsIgnoreCase("--stop")) {
                new Main().stop();
            } else if (args.length > 0 && args[0].equalsIgnoreCase("--version")) {
                String[] nargs = new String[args.length - 1];
                System.arraycopy(args, 1, nargs, 0, nargs.length);
                Main main = new Main();
                main._version = true;
                main.start(nargs);
            } else {
                new Main().start(args);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static File getDirectory(String name) {
        try {
            File dir;
            if (name != null && (dir = new File(name).getCanonicalFile()).isDirectory()) {
                return dir;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    boolean isAvailable(String classname) {
        try {
            Class.forName(classname);
            return true;
        }
        catch (NoClassDefFoundError e) {
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        ClassLoader loader = this._classpath.getClassLoader();
        try {
            loader.loadClass(classname);
            return true;
        }
        catch (NoClassDefFoundError e) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public void invokeMain(ClassLoader classloader, String classname, String[] args) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        Class<?> invoked_class = null;
        invoked_class = classloader.loadClass(classname);
        if (this._version) {
            System.err.println(invoked_class.getPackage().getImplementationTitle() + " " + invoked_class.getPackage().getImplementationVersion());
            System.exit(0);
        }
        Class[] method_param_types = new Class[]{args.getClass()};
        Method main = null;
        main = invoked_class.getDeclaredMethod("main", method_param_types);
        Object[] method_params = new Object[]{args};
        main.invoke(null, method_params);
    }

    String expand(String s) {
        int i1 = 0;
        int i2 = 0;
        while (s != null && (i1 = s.indexOf("$(", i2)) >= 0 && (i2 = s.indexOf(")", i1 + 2)) >= 0) {
            String property = System.getProperty(s.substring(i1 + 2, i2), "");
            s = s.substring(0, i1) + property + s.substring(i2 + 1);
        }
        return s;
    }

    void configure(InputStream config, int nargs) throws Exception {
        BufferedReader cfg = new BufferedReader(new InputStreamReader(config, "ISO-8859-1"));
        Version java_version = new Version(System.getProperty("java.version"));
        Version ver = new Version();
        Hashtable<String, String> done = new Hashtable<String, String>();
        String classpath = System.getProperty("CLASSPATH");
        if (classpath != null) {
            StringTokenizer tok = new StringTokenizer(classpath, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                this._classpath.addComponent(tok.nextToken());
            }
        }
        String line = null;
        while ((line = cfg.readLine()) != null) {
            if (line.length() == 0 || line.startsWith("#")) continue;
            try {
                File f;
                String d;
                File dir;
                StringTokenizer st = new StringTokenizer(line);
                String subject = st.nextToken();
                boolean expression = true;
                boolean not = false;
                String condition = null;
                while (st.hasMoreTokens()) {
                    String operator;
                    condition = st.nextToken();
                    if (condition.equalsIgnoreCase("!")) {
                        not = true;
                        continue;
                    }
                    if (condition.equalsIgnoreCase("OR")) {
                        if (expression) break;
                        expression = true;
                        continue;
                    }
                    if (condition.equalsIgnoreCase("AND")) {
                        if (expression) continue;
                        break;
                    }
                    boolean eval = true;
                    if (condition.equals("true") || condition.equals("always")) {
                        eval = true;
                    } else if (condition.equals("false") || condition.equals("never")) {
                        eval = false;
                    } else if (condition.equals("available")) {
                        String class_to_check = st.nextToken();
                        eval = this.isAvailable(class_to_check);
                    } else if (condition.equals("exists")) {
                        try {
                            eval = false;
                            File file = new File(this.expand(st.nextToken()));
                            eval = file.exists();
                        }
                        catch (Exception e) {
                            if (_debug) {
                                e.printStackTrace();
                            }
                        }
                    } else if (condition.equals("property")) {
                        String property = System.getProperty(st.nextToken());
                        eval = property != null && property.length() > 0;
                    } else if (condition.equals("java")) {
                        operator = st.nextToken();
                        String version = st.nextToken();
                        ver.parse(version);
                        eval = operator.equals("<") && java_version.compare(ver) < 0 || operator.equals(">") && java_version.compare(ver) > 0 || operator.equals("<=") && java_version.compare(ver) <= 0 || operator.equals("=<") && java_version.compare(ver) <= 0 || operator.equals("=>") && java_version.compare(ver) >= 0 || operator.equals(">=") && java_version.compare(ver) >= 0 || operator.equals("==") && java_version.compare(ver) == 0 || operator.equals("!=") && java_version.compare(ver) != 0;
                    } else if (condition.equals("nargs")) {
                        operator = st.nextToken();
                        int number = Integer.parseInt(st.nextToken());
                        eval = operator.equals("<") && nargs < number || operator.equals(">") && nargs > number || operator.equals("<=") && nargs <= number || operator.equals("=<") && nargs <= number || operator.equals("=>") && nargs >= number || operator.equals(">=") && nargs >= number || operator.equals("==") && nargs == number || operator.equals("!=") && nargs != number;
                    } else {
                        System.err.println("ERROR: Unknown condition: " + condition);
                        eval = false;
                    }
                    expression &= not ? !eval : eval;
                    not = false;
                }
                String file = this.expand(subject).replace('/', File.separatorChar);
                if (_debug) {
                    System.err.println((expression ? "T " : "F ") + line);
                }
                if (!expression) {
                    done.put(file, file);
                    continue;
                }
                if (subject.indexOf("=") > 0) {
                    int i = file.indexOf("=");
                    String property = file.substring(0, i);
                    String value = file.substring(i + 1);
                    if (_debug) {
                        System.err.println("  " + property + "=" + value);
                    }
                    System.setProperty(property, value);
                    continue;
                }
                if (subject.endsWith("/*")) {
                    dir = new File(file.substring(0, file.length() - 1));
                    this.addJars(dir, done, false);
                    continue;
                }
                if (subject.endsWith("/**")) {
                    dir = new File(file.substring(0, file.length() - 2));
                    this.addJars(dir, done, true);
                    continue;
                }
                if (subject.endsWith("/")) {
                    File cd = new File(file);
                    d = cd.getCanonicalPath();
                    if (done.containsKey(d)) continue;
                    done.put(d, d);
                    boolean added = this._classpath.addComponent(d);
                    if (!_debug) continue;
                    System.err.println((added ? "  CLASSPATH+=" : "  !") + d);
                    continue;
                }
                if (subject.toLowerCase().endsWith(".xml")) {
                    f = new File(file);
                    if (f.exists()) {
                        this._xml.add(f.getCanonicalPath());
                    }
                    if (!_debug) continue;
                    System.err.println("  ARGS+=" + f);
                    continue;
                }
                if (subject.toLowerCase().endsWith(".class")) {
                    String cn = this.expand(subject.substring(0, subject.length() - 6));
                    if (cn == null || cn.length() <= 0) continue;
                    if (_debug) {
                        System.err.println("  CLASS=" + cn);
                    }
                    this._classname = cn;
                    continue;
                }
                f = new File(file);
                d = f.getCanonicalPath();
                if (done.containsKey(d)) continue;
                done.put(d, d);
                boolean added = this._classpath.addComponent(d);
                if (!added) {
                    added = this._classpath.addClasspath(this.expand(subject));
                    if (!_debug) continue;
                    System.err.println((added ? "  CLASSPATH+=" : "  !") + d);
                    continue;
                }
                if (!_debug) continue;
                System.err.println((added ? "  CLASSPATH+=" : "  !") + d);
            }
            catch (Exception e) {
                System.err.println("on line: '" + line + "'");
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String[] args) {
        ArrayList<String> al = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            al.add(args[i]);
        }
        args = al.toArray(new String[al.size()]);
        InputStream cpcfg = null;
        try {
            Monitor.monitor();
            cpcfg = this.getClass().getClassLoader().getResourceAsStream(this._config);
            if (_debug) {
                System.err.println("config=" + this._config);
            }
            if (cpcfg == null) {
                cpcfg = new FileInputStream(this._config);
            }
            this.configure(cpcfg, args.length);
            File file = new File(System.getProperty("jetty.home"));
            String canonical = file.getCanonicalPath();
            System.setProperty("jetty.home", canonical);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        finally {
            try {
                cpcfg.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.setProperty("java.class.path", this._classpath.toString());
        ClassLoader cl = this._classpath.getClassLoader();
        if (_debug) {
            System.err.println("java.class.path=" + System.getProperty("java.class.path"));
            System.err.println("jetty.home=" + System.getProperty("jetty.home"));
            System.err.println("java.io.tmpdir=" + System.getProperty("java.io.tmpdir"));
            System.err.println("java.class.path=" + this._classpath);
            System.err.println("classloader=" + cl);
            System.err.println("classloader.parent=" + cl.getParent());
        }
        Thread.currentThread().setContextClassLoader(cl);
        try {
            Policy policy = Policy.getPolicy();
            if (policy != null) {
                policy.refresh();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                this._xml.add(args[i]);
            }
            args = this._xml.toArray(args);
            String mainClass = System.getProperty("jetty.server");
            if (mainClass != null) {
                this._classname = mainClass;
            }
            if ((mainClass = System.getProperty("main.class")) != null) {
                this._classname = mainClass;
            }
            if (_debug) {
                System.err.println("main.class=" + this._classname);
            }
            this.invokeMain(cl, this._classname, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        int _port = Integer.getInteger("STOP.PORT", 8079);
        String _key = System.getProperty("STOP.KEY", "mortbay");
        try {
            if (_port <= 0) {
                System.err.println("STOP.PORT system property must be specified");
            }
            if (_key == null) {
                _key = "";
                System.err.println("Using empty key");
            }
            Socket s = new Socket(InetAddress.getByName("127.0.0.1"), _port);
            OutputStream out = s.getOutputStream();
            out.write((_key + "\r\nstop\r\n").getBytes());
            out.flush();
            s.shutdownOutput();
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addJars(File dir, Hashtable table, boolean recurse) throws IOException {
        File[] entries = dir.listFiles();
        for (int i = 0; entries != null && i < entries.length; ++i) {
            String jar;
            File entry = entries[i];
            if (entry.isDirectory() && recurse) {
                this.addJars(entry, table, recurse);
                continue;
            }
            String name = entry.getName().toLowerCase();
            if (!name.endsWith(".jar") && !name.endsWith(".zip") || table.containsKey(jar = entry.getCanonicalPath())) continue;
            table.put(jar, jar);
            boolean added = this._classpath.addComponent(jar);
            if (!_debug) continue;
            System.err.println((added ? "  CLASSPATH+=" : "  !") + jar);
        }
    }
}

