/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jetty.plus.PlusWebAppContext;
import org.mortbay.jetty.plus.Service;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.util.LogSupport;
import org.mortbay.util.MultiException;
import org.mortbay.util.Resource;

public class Server
extends org.mortbay.jetty.Server {
    static Log log = LogFactory.getLog((Class)(class$org$mortbay$jetty$plus$Server == null ? (class$org$mortbay$jetty$plus$Server = Server.class$("org.mortbay.jetty.plus.Server")) : class$org$mortbay$jetty$plus$Server));
    private ArrayList _serviceList;
    static /* synthetic */ Class class$org$mortbay$jetty$plus$Server;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$java$lang$Runtime;

    public Server() {
    }

    public Server(String configuration) throws IOException {
        super(configuration);
    }

    public Server(Resource configuration) throws IOException {
        super(configuration);
    }

    public Server(URL configuration) throws IOException {
        super(configuration);
    }

    public void addService(Service service) {
        if (this._serviceList == null) {
            this._serviceList = new ArrayList(5);
        }
        this._serviceList.add(service);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Service List contains: " + this._serviceList.size() + " services"));
        }
    }

    public synchronized void start() throws MultiException {
        if (this._serviceList != null) {
            MultiException mex = new MultiException();
            Iterator itor = this._serviceList.iterator();
            while (itor.hasNext()) {
                try {
                    ((Service)itor.next()).start();
                }
                catch (Exception e) {
                    mex.add(e);
                }
            }
            mex.ifExceptionThrowMulti();
        }
        super.start();
    }

    public synchronized void stop(boolean graceful) throws InterruptedException {
        super.stop(graceful);
        if (this._serviceList != null && this._serviceList.size() > 0) {
            ListIterator listItor = this._serviceList.listIterator(this._serviceList.size());
            while (listItor.hasPrevious()) {
                Service s = (Service)listItor.previous();
                if (s == null) continue;
                s.stop();
            }
        }
    }

    public static void main(String[] arg) {
        Server[] servers;
        block10: {
            String[] dftConfig = new String[]{"etc/jetty.xml"};
            if (arg.length == 0) {
                log.info((Object)"Using default configuration: etc/jetty.xml");
                arg = dftConfig;
            }
            servers = new Server[arg.length];
            int i = 0;
            while (i < arg.length) {
                try {
                    servers[i] = new Server(arg[i]);
                    servers[i].start();
                }
                catch (Exception e) {
                    log.warn((Object)"EXCEPTION ", (Throwable)e);
                }
                ++i;
            }
            if (!Boolean.getBoolean("JETTY_NO_SHUTDOWN_HOOK")) {
                try {
                    Method shutdownHook = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = Server.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("addShutdownHook", class$java$lang$Thread == null ? (class$java$lang$Thread = Server.class$("java.lang.Thread")) : class$java$lang$Thread);
                    Thread hook = new Thread(){

                        public void run() {
                            this.setName("Shutdown");
                            log.info((Object)"Shutdown hook executing");
                            int i = 0;
                            while (i < servers.length) {
                                if (servers[i] != null) {
                                    try {
                                        servers[i].stop();
                                    }
                                    catch (Exception e) {
                                        log.warn((Object)"EXCEPTION ", (Throwable)e);
                                    }
                                }
                                ++i;
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (Exception e) {
                                log.warn((Object)"EXCEPTION ", (Throwable)e);
                            }
                        }
                    };
                    shutdownHook.invoke((Object)Runtime.getRuntime(), hook);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block10;
                    log.debug((Object)"No shutdown hook in JVM ", (Throwable)e);
                }
            }
        }
        int i = 0;
        while (i < arg.length) {
            try {
                servers[i].join();
            }
            catch (Exception e) {
                LogSupport.ignore((Log)log, (Throwable)e);
            }
            ++i;
        }
    }

    protected WebApplicationContext newWebApplicationContext(String webApp) {
        return new PlusWebAppContext(webApp);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

