/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus;

import java.io.IOException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.jetty.servlet.XMLConfiguration;
import org.mortbay.util.TypeUtil;
import org.mortbay.xml.XmlParser;

public class JotmWebAppContext
extends WebApplicationContext {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$jetty$plus$JotmWebAppContext == null ? (class$org$mortbay$jetty$plus$JotmWebAppContext = JotmWebAppContext.class$("org.mortbay.jetty.plus.JotmWebAppContext")) : class$org$mortbay$jetty$plus$JotmWebAppContext));
    Context _rootComp;
    Context _rootCompEnv;
    static /* synthetic */ Class class$org$mortbay$jetty$plus$JotmWebAppContext;

    public JotmWebAppContext() {
        this.setConfiguration((WebApplicationContext.Configuration)new Configuration(this));
    }

    public JotmWebAppContext(String webApp) {
        super(webApp);
        this.setConfiguration((WebApplicationContext.Configuration)new Configuration(this));
    }

    public void start() throws Exception {
        this.bindToGlobal("javax.transaction.UserTransaction", "java:comp/UserTransaction");
        super.start();
    }

    public void handle(HttpRequest request, HttpResponse response) throws HttpException, IOException {
        super.handle(request, response);
    }

    private void bind(String name, Object value) throws NamingException {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
        }
        catch (NamingException e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
            throw e;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("bind in " + ctx + " " + name + "=" + value));
        }
        ctx.rebind(name, value);
    }

    private void bindToGlobal(String strGlobalName, String name) throws NamingException {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
        }
        catch (NamingException e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
            throw e;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Searching for global entry in JNDI with name " + strGlobalName));
        }
        Object objValue = ctx.lookup(strGlobalName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("bind in " + ctx + " " + name + "=" + objValue));
        }
        ctx.rebind(name, objValue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Configuration
    extends XMLConfiguration {
        public Configuration(WebApplicationContext context) {
            super(context);
        }

        public JotmWebAppContext getJotmWebAppContext() {
            return (JotmWebAppContext)this.getWebApplicationContext();
        }

        protected void initWebXmlElement(String element, XmlParser.Node node) throws Exception {
            if ("env-entry".equals(element)) {
                String name = node.getString("env-entry-name", false, true);
                Object value = TypeUtil.valueOf((String)node.getString("env-entry-type", false, true), (String)node.getString("env-entry-value", false, true));
                this.getJotmWebAppContext().bind("java:comp/env/" + name, value);
            } else if ("resource-ref".equals(element)) {
                String name = node.getString("res-ref-name", false, true);
                this.getJotmWebAppContext().bindToGlobal(name, "java:comp/env/" + name);
            } else if ("resource-env-ref".equals(element)) {
                String name = node.getString("resource-env-ref-name", false, true);
                this.getJotmWebAppContext().bindToGlobal(name, "java:comp/env/" + name);
            } else if ("ejb-ref".equals(element) || "ejb-local-ref".equals(element) || "security-domain".equals(element)) {
                log.warn((Object)("Entry " + element + " => " + node + " is not supported yet"));
            } else {
                super.initWebXmlElement(element, node);
            }
        }
    }
}

