/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.enhydra.jdbc.pool.StandardXAPoolDataSource;
import org.enhydra.jdbc.standard.StandardXADataSource;
import org.mortbay.jetty.plus.TMService;
import org.mortbay.jndi.Util;
import org.objectweb.jotm.Jotm;

public class JotmService
extends TMService {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$jetty$plus$JotmService == null ? (class$org$mortbay$jetty$plus$JotmService = JotmService.class$("org.mortbay.jetty.plus.JotmService")) : class$org$mortbay$jetty$plus$JotmService));
    public static final String DEFAULT_SERVICE_NAME = "JotmService";
    protected org.objectweb.transaction.jta.TMService m_tm = null;
    protected Map m_mpDataSources = new HashMap();
    static /* synthetic */ Class class$org$mortbay$jetty$plus$JotmService;

    public JotmService() {
        this.setName(DEFAULT_SERVICE_NAME);
    }

    public TransactionManager getTransactionManager() {
        if (this.m_tm == null) {
            return null;
        }
        return this.m_tm.getTransactionManager();
    }

    public UserTransaction getUserTransaction() {
        if (this.m_tm == null) {
            return null;
        }
        return this.m_tm.getUserTransaction();
    }

    public void start() throws Exception {
        if (!this.isStarted()) {
            log.info((Object)"Starting JoTM transaction manager.");
            try {
                if (this.m_tm == null) {
                    this.m_tm = new Jotm(true, true);
                }
            }
            catch (Exception eExc) {
                log.warn((Object)"EXCEPTION ", (Throwable)eExc);
                throw new IOException("Failed to start JoTM: " + eExc);
            }
            InitialContext ictx = null;
            try {
                ictx = new InitialContext();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("InitialContext instanceof " + ictx.getClass().getName()));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("java.naming.factory.initial=" + System.getProperty("java.naming.factory.initial")));
                }
            }
            catch (NamingException e) {
                log.warn((Object)"EXCEPTION ", (Throwable)e);
                throw new IOException("No initial context: " + e);
            }
            try {
                Util.bind(ictx, this.getJNDI(), this.m_tm.getUserTransaction());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("UserTransaction object bound in JNDI with name " + this.getJNDI()));
                }
            }
            catch (NamingException e) {
                log.warn((Object)"EXCEPTION ", (Throwable)e);
                throw new IOException("UserTransaction rebind failed :" + e.getExplanation());
            }
            try {
                Util.bind(ictx, this.getTransactionManagerJNDI(), this.m_tm.getTransactionManager());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("TransactionManager object bound in JNDI with name " + this.getTransactionManagerJNDI()));
                }
            }
            catch (NamingException e) {
                log.warn((Object)"EXCEPTION ", (Throwable)e);
                throw new IOException("TransactionManager rebind failed :" + e.getExplanation());
            }
            Iterator itrDataSources = this.m_mpDataSources.entrySet().iterator();
            while (itrDataSources.hasNext()) {
                Object xadsDataSource;
                Map.Entry meDataSource = itrDataSources.next();
                String strDataSourceName = (String)meDataSource.getKey();
                Object o = meDataSource.getValue();
                if (o instanceof StandardXAPoolDataSource) {
                    StandardXAPoolDataSource xapdsPoolDataSource = (StandardXAPoolDataSource)meDataSource.getValue();
                    xadsDataSource = xapdsPoolDataSource.getDataSource();
                    if (this.m_tm != null) {
                        xapdsPoolDataSource.setTransactionManager((TransactionManager)this.m_tm.getTransactionManager());
                        xadsDataSource.setTransactionManager((TransactionManager)this.m_tm.getTransactionManager());
                    }
                    try {
                        Util.bind(ictx, "XA" + strDataSourceName, xadsDataSource);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("XA Data source bound in JNDI with name XA" + strDataSourceName));
                        }
                        Util.bind(ictx, strDataSourceName, xapdsPoolDataSource);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Data Source Pool bound in JNDI with name " + strDataSourceName));
                        continue;
                    }
                    catch (NamingException e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Data source rebind failed :" + e.getExplanation()));
                        }
                        log.warn((Object)"EXCEPTION ", (Throwable)e);
                        throw e;
                    }
                }
                if (o instanceof StandardXADataSource) {
                    xadsDataSource = (StandardXADataSource)o;
                    if (this.m_tm != null) {
                        xadsDataSource.setTransactionManager((TransactionManager)this.m_tm.getTransactionManager());
                    }
                    try {
                        Util.bind(ictx, strDataSourceName, xadsDataSource);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Data Source bound in JNDI with name " + strDataSourceName));
                        continue;
                    }
                    catch (NamingException e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Data source rebind failed : " + e.getExplanation()));
                        }
                        log.warn((Object)"EXCEPTION ", (Throwable)e);
                        throw e;
                    }
                }
                throw new IllegalStateException(o + " is not a StandardDataSource");
            }
            super.start();
            log.info((Object)"JoTM is running.");
        } else {
            log.info((Object)"JoTM is already running");
        }
    }

    public void stop() throws InterruptedException {
        if (!this.isStarted()) {
            log.info((Object)"Stopping JoTM...");
            this.m_tm.stop();
            super.stop();
            log.info((Object)"JoTM is stopped.");
        } else {
            log.warn((Object)"No JoTM to stop.");
        }
    }

    public void addDataSource(String dsJNDIName, StandardXADataSource xaDataSource, StandardXAPoolDataSource xaPool) throws SQLException, NamingException {
        xaPool.setUser(xaDataSource.getUser());
        xaPool.setPassword(xaDataSource.getPassword());
        xaPool.setDataSourceName("XA" + dsJNDIName);
        xaPool.setDataSource((XADataSource)xaDataSource);
        this.m_mpDataSources.put(dsJNDIName, xaPool);
        log.info((Object)("Pooled data source: " + dsJNDIName + " configured"));
    }

    public void addDataSource(String dsJNDIName, StandardXADataSource xaDataSource) {
        this.m_mpDataSources.put(dsJNDIName, xaDataSource);
        log.info((Object)("Data source: " + dsJNDIName + " configured"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

