/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jndi;

import java.util.Hashtable;
import java.util.WeakHashMap;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.spi.ObjectFactory;
import org.mortbay.jndi.NamingContext;
import org.mortbay.util.Code;

public class ContextFactory
implements ObjectFactory {
    private static WeakHashMap _contextMap = new WeakHashMap();
    private static NameParser _parser;

    public static void setNameParser(NameParser parser) {
        _parser = parser;
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Context ctx = (Context)_contextMap.get(loader);
        if (ctx == null && (ctx = this.getParentClassLoaderContext(loader)) == null) {
            ctx = new NamingContext(env, name.get(0), nameCtx, _parser);
            Code.debug((String)("No entry for classloader: " + loader));
            _contextMap.put(loader, ctx);
        }
        return ctx;
    }

    public Context getParentClassLoaderContext(ClassLoader loader) {
        Context ctx = null;
        ClassLoader cl = loader;
        for (cl = cl.getParent(); cl != null && ctx == null; cl = cl.getParent()) {
            ctx = (Context)_contextMap.get(cl);
        }
        return ctx;
    }
}

