/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jndi;

import java.util.Hashtable;
import java.util.Properties;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.mortbay.jndi.NamingContext;
import org.mortbay.util.Code;

public class InitialContextFactory
implements javax.naming.spi.InitialContextFactory {
    private static final Hashtable _roots = new Hashtable();

    public Context getInitialContext(Hashtable env) {
        Code.debug((String)"InitialContextFactory.getInitialContext()");
        Context ctx = (Context)_roots.get(env);
        Code.debug((String)("Returning context root: " + ctx));
        if (ctx == null) {
            ctx = new NamingContext(env);
            ((NamingContext)ctx).setNameParser(new DefaultParser());
            _roots.put(env, ctx);
            Code.debug((String)("Created new root context:" + ctx));
        }
        return ctx;
    }

    public static class DefaultParser
    implements NameParser {
        static Properties syntax = new Properties();

        public Name parse(String name) throws NamingException {
            return new CompoundName(name, syntax);
        }

        static {
            syntax.put("jndi.syntax.direction", "left_to_right");
            syntax.put("jndi.syntax.separator", "/");
            syntax.put("jndi.syntax.ignorecase", "false");
        }
    }
}

