/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.XADataSource;
import javax.transaction.UserTransaction;
import org.enhydra.jdbc.pool.StandardXAPoolDataSource;
import org.enhydra.jdbc.standard.StandardXADataSource;
import org.mortbay.jetty.plus.TMService;
import org.mortbay.jndi.Util;
import org.mortbay.util.Code;
import org.mortbay.util.Log;
import org.objectweb.jotm.Jotm;
import org.objectweb.transaction.jta.TransactionManager;

public class JotmService
extends TMService {
    public static final String DEFAULT_SERVICE_NAME = "JotmService";
    protected org.objectweb.transaction.jta.TMService m_tm = null;
    protected Map m_mpDataSources = new HashMap();

    public JotmService() {
        this.setName(DEFAULT_SERVICE_NAME);
    }

    public javax.transaction.TransactionManager getTransactionManager() {
        if (this.m_tm == null) {
            return null;
        }
        return this.m_tm.getTransactionManager();
    }

    public UserTransaction getUserTransaction() {
        if (this.m_tm == null) {
            return null;
        }
        return this.m_tm.getUserTransaction();
    }

    public void start() throws Exception {
        if (!this.isStarted()) {
            Log.event((Object)"Starting JoTM transaction manager.");
            try {
                if (this.m_tm == null) {
                    this.m_tm = new Jotm(true, true);
                }
            }
            catch (Exception eExc) {
                Code.warning((Throwable)eExc);
                throw new IOException("Failed to start JoTM: " + eExc);
            }
            InitialContext ictx = null;
            try {
                ictx = new InitialContext();
                Code.debug((String)("InitialContext instanceof " + ictx.getClass().getName()));
                Code.debug((String)("java.naming.factory.initial=" + System.getProperty("java.naming.factory.initial")));
            }
            catch (NamingException e) {
                Code.warning((Throwable)e);
                throw new IOException("No initial context: " + e);
            }
            try {
                Util.bind(ictx, this.getJNDI(), this.m_tm.getUserTransaction());
                Code.debug((String)("UserTransaction object bound in JNDI with name " + this.getJNDI()));
            }
            catch (NamingException e) {
                Code.warning((Throwable)e);
                throw new IOException("UserTransaction rebind failed :" + e.getExplanation());
            }
            try {
                Util.bind(ictx, this.getTransactionManagerJNDI(), this.m_tm.getTransactionManager());
                Code.debug((String)("TransactionManager object bound in JNDI with name " + this.getTransactionManagerJNDI()));
            }
            catch (NamingException e) {
                Code.warning((Throwable)e);
                throw new IOException("TransactionManager rebind failed :" + e.getExplanation());
            }
            TransactionManager tmManager = this.m_tm.getTransactionManager();
            Iterator itrDataSources = this.m_mpDataSources.entrySet().iterator();
            while (itrDataSources.hasNext()) {
                Object xadsDataSource;
                Map.Entry meDataSource = itrDataSources.next();
                String strDataSourceName = (String)meDataSource.getKey();
                Object o = meDataSource.getValue();
                if (o instanceof StandardXAPoolDataSource) {
                    StandardXAPoolDataSource xapdsPoolDataSource = (StandardXAPoolDataSource)meDataSource.getValue();
                    xadsDataSource = xapdsPoolDataSource.getDataSource();
                    if (this.m_tm != null) {
                        xapdsPoolDataSource.setTransactionManager((javax.transaction.TransactionManager)this.m_tm.getTransactionManager());
                        xadsDataSource.setTransactionManager((javax.transaction.TransactionManager)this.m_tm.getTransactionManager());
                    }
                    try {
                        Util.bind(ictx, "XA" + strDataSourceName, xadsDataSource);
                        Code.debug((String)("XA Data source bound in JNDI with name XA" + strDataSourceName));
                        Util.bind(ictx, strDataSourceName, xapdsPoolDataSource);
                        Code.debug((String)("Data Source Pool bound in JNDI with name " + strDataSourceName));
                        continue;
                    }
                    catch (NamingException e) {
                        Code.debug((String)("Data source rebind failed :" + e.getExplanation()));
                        Code.warning((Throwable)e);
                        throw e;
                    }
                }
                if (o instanceof StandardXADataSource) {
                    xadsDataSource = (StandardXADataSource)o;
                    if (this.m_tm != null) {
                        xadsDataSource.setTransactionManager((javax.transaction.TransactionManager)this.m_tm.getTransactionManager());
                    }
                    try {
                        Util.bind(ictx, strDataSourceName, xadsDataSource);
                        Code.debug((String)("Data Source bound in JNDI with name " + strDataSourceName));
                        continue;
                    }
                    catch (NamingException e) {
                        Code.debug((String)("Data source rebind failed : " + e.getExplanation()));
                        Code.warning((Throwable)e);
                        throw e;
                    }
                }
                throw new IllegalStateException(o + " is not a StandardDataSource");
            }
            super.start();
            Log.event((Object)"JoTM is running.");
        } else {
            Log.event((Object)"JoTM is already running");
        }
    }

    public void stop() throws InterruptedException {
        if (!this.isStarted()) {
            Log.event((Object)"Stopping JoTM...");
            this.m_tm.stop();
            super.stop();
            Log.event((Object)"JoTM is stopped.");
        } else {
            Code.warning((String)"No JoTM to stop.");
        }
    }

    public void addDataSource(String dsJNDIName, StandardXADataSource xaDataSource, StandardXAPoolDataSource xaPool) throws SQLException, NamingException {
        xaPool.setUser(xaDataSource.getUser());
        xaPool.setPassword(xaDataSource.getPassword());
        xaPool.setDataSourceName("XA" + dsJNDIName);
        xaPool.setDataSource((XADataSource)xaDataSource);
        this.m_mpDataSources.put(dsJNDIName, xaPool);
        Log.event((Object)("Pooled data source: " + dsJNDIName + " configured"));
    }

    public void addDataSource(String dsJNDIName, StandardXADataSource xaDataSource) {
        this.m_mpDataSources.put(dsJNDIName, xaDataSource);
        Log.event((Object)("Data source: " + dsJNDIName + " configured"));
    }
}

