/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.xbean;

import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.log.Log;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class JettyFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    private Server server;
    private Handler[] handlers = new Handler[0];
    private Connector[] connectors = new Connector[0];
    private UserRealm[] userRealms = new UserRealm[0];

    public Object getObject() throws Exception {
        return this.getServer();
    }

    public Class getObjectType() {
        return Server.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        int i;
        Server server = this.getServer();
        Log.info((String)"Starting Jetty Web Server");
        for (i = 0; i < this.connectors.length; ++i) {
            Connector connector = this.connectors[i];
            connector.setServer(server);
            Log.info((String)("Using Jetty Connector: " + connector));
        }
        server.setConnectors(this.connectors);
        for (i = 0; i < this.handlers.length; ++i) {
            Handler handler = this.handlers[i];
            Log.info((String)("Using Jetty Handler: " + handler));
        }
        HandlerCollection contexts = (HandlerCollection)server.getChildHandlerByClass(ContextHandlerCollection.class);
        if (contexts == null) {
            contexts = (HandlerCollection)server.getChildHandlerByClass(HandlerCollection.class);
        }
        if (contexts == null) {
            contexts = new ContextHandlerCollection();
            server.setHandler((Handler)contexts);
        }
        contexts.setHandlers(this.handlers);
        for (int i2 = 0; i2 < this.userRealms.length; ++i2) {
            Log.info((String)("Using UserRealm: " + this.userRealms[i2]));
        }
        server.setUserRealms(this.userRealms);
        server.start();
    }

    public void destroy() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public Server getServer() throws Exception {
        if (this.server == null) {
            this.server = this.createServer();
        }
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public Connector[] getConnectors() {
        return this.connectors;
    }

    public void setConnectors(Connector[] connectors) {
        this.connectors = connectors;
    }

    public Handler[] getHandlers() {
        return this.handlers;
    }

    public void setHandlers(Handler[] handlers) {
        this.handlers = handlers;
    }

    public void setUserRealms(UserRealm[] userRealms) {
        this.userRealms = userRealms;
    }

    public UserRealm[] getUserRealms() {
        return this.userRealms;
    }

    protected Server createServer() throws Exception {
        Server server = new Server();
        return server;
    }
}

