/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.UnsupportedEncodingException;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;

public class URIUtil
implements Cloneable {
    public static final String HTTP = "http";
    public static final String HTTP_COLON = "http:";
    public static final String HTTPS = "https";
    public static final String HTTPS_COLON = "https:";
    public static final String __CHARSET = System.getProperty("org.mortbay.util.URI.charset", StringUtil.__ISO_8859_1);

    private URIUtil() {
    }

    public static String encodePath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        StringBuffer buf = URIUtil.encodePath(null, path);
        return buf == null ? path : buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer encodePath(StringBuffer buf, String path) {
        if (buf == null) {
            block13: for (int i = 0; i < path.length(); ++i) {
                char c = path.charAt(i);
                switch (c) {
                    case ' ': 
                    case '#': 
                    case '%': 
                    case ';': 
                    case '?': {
                        buf = new StringBuffer(path.length() << 1);
                        break block13;
                    }
                    default: {
                        continue block13;
                    }
                }
            }
            if (buf == null) {
                return null;
            }
        }
        StringBuffer stringBuffer = buf;
        synchronized (stringBuffer) {
            block14: for (int i = 0; i < path.length(); ++i) {
                char c = path.charAt(i);
                switch (c) {
                    case '%': {
                        buf.append("%25");
                        continue block14;
                    }
                    case '?': {
                        buf.append("%3F");
                        continue block14;
                    }
                    case ';': {
                        buf.append("%3B");
                        continue block14;
                    }
                    case '#': {
                        buf.append("%23");
                        continue block14;
                    }
                    case ' ': {
                        buf.append("%20");
                        continue block14;
                    }
                    default: {
                        buf.append(c);
                        continue block14;
                    }
                }
            }
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer encodeString(StringBuffer buf, String path, String encode) {
        if (buf == null) {
            for (int i = 0; i < path.length(); ++i) {
                char c = path.charAt(i);
                if (c != '%' && encode.indexOf(c) < 0) continue;
                buf = new StringBuffer(path.length() << 1);
                break;
            }
            if (buf == null) {
                return null;
            }
        }
        StringBuffer stringBuffer = buf;
        synchronized (stringBuffer) {
            for (int i = 0; i < path.length(); ++i) {
                char c = path.charAt(i);
                if (c == '%' || encode.indexOf(c) >= 0) {
                    buf.append('%');
                    StringUtil.append(buf, (byte)(0xFF & c), 16);
                    continue;
                }
                buf.append(c);
            }
        }
        return buf;
    }

    public static String decodePath(String path) {
        int len = path.length();
        byte[] bytes = null;
        int n = 0;
        boolean noDecode = true;
        for (int i = 0; i < len; ++i) {
            char c = path.charAt(i);
            if (c < '\u0000' || c > '\u00ff') {
                throw new IllegalArgumentException("Not decoded");
            }
            byte b = (byte)(0xFF & c);
            if (c == '%' && i + 2 < len) {
                noDecode = false;
                b = (byte)(0xFF & TypeUtil.parseInt(path, i + 1, 2, 16));
                i += 2;
            } else if (bytes == null) {
                ++n;
                continue;
            }
            if (bytes == null) {
                noDecode = false;
                bytes = new byte[len];
                for (int j = 0; j < n; ++j) {
                    bytes[j] = (byte)(0xFF & path.charAt(j));
                }
            }
            bytes[n++] = b;
        }
        if (noDecode) {
            return path;
        }
        try {
            return new String(bytes, 0, n, __CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes, 0, n);
        }
    }

    public static String addPaths(String p1, String p2) {
        if (p1 == null || p1.length() == 0) {
            if (p2 == null || p2.length() == 0) {
                return p1;
            }
            return p2;
        }
        if (p2 == null || p2.length() == 0) {
            return p1;
        }
        int split = p1.indexOf(59);
        if (split < 0) {
            split = p1.indexOf(63);
        }
        if (split == 0) {
            return p2 + p1;
        }
        if (split < 0) {
            split = p1.length();
        }
        StringBuffer buf = new StringBuffer(p1.length() + p2.length() + 2);
        buf.append(p1);
        if (buf.charAt(split - 1) == '/') {
            if (p2.startsWith("/")) {
                buf.deleteCharAt(split - 1);
                buf.insert(split - 1, p2);
            } else {
                buf.insert(split, p2);
            }
        } else if (p2.startsWith("/")) {
            buf.insert(split, p2);
        } else {
            buf.insert(split, '/');
            buf.insert(split + 1, p2);
        }
        return buf.toString();
    }

    public static String parentPath(String p) {
        if (p == null || "/".equals(p)) {
            return null;
        }
        int slash = p.lastIndexOf(47, p.length() - 2);
        if (slash >= 0) {
            return p.substring(0, slash + 1);
        }
        return null;
    }

    public static String stripPath(String path) {
        if (path == null) {
            return null;
        }
        int semi = path.indexOf(59);
        if (semi < 0) {
            return path;
        }
        return path.substring(0, semi);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String canonicalPath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        int end = path.length();
        int queryIdx = path.indexOf(63);
        int start = path.lastIndexOf(47, queryIdx > 0 ? queryIdx : end);
        block10: while (end >= 0) {
            switch (end - start) {
                case 1: {
                    if (start >= 0 && end != path.length()) break block10;
                    break;
                }
                case 2: {
                    if (path.charAt(start + 1) == '.') break block10;
                    break;
                }
                case 3: {
                    if (path.charAt(start + 1) == '.' && path.charAt(start + 2) == '.') break block10;
                }
            }
            end = start;
            start = path.lastIndexOf(47, end - 1);
        }
        if (start >= end) {
            return path;
        }
        StringBuffer buf = new StringBuffer(path);
        int delStart = -1;
        int delEnd = -1;
        int skip = 0;
        block11: while (end >= 0) {
            switch (end - start) {
                case 1: {
                    if (start < 0 || end == path.length()) break;
                    delStart = start;
                    if (delEnd < 0) {
                        delEnd = end;
                    }
                    if (delStart == 0 && delEnd == buf.length()) {
                        ++delStart;
                        break;
                    }
                    --start;
                    while (start >= 0 && buf.charAt(start) != '/') {
                        --start;
                    }
                    continue block11;
                }
                case 2: {
                    if (buf.charAt(start + 1) != '.') {
                        if (skip <= 0 || --skip != 0) break;
                        delStart = start >= 0 ? start : 0;
                        break;
                    }
                    if (delEnd < 0) {
                        delEnd = end;
                    }
                    if ((delStart = start) < 0 || delStart == 0 && buf.charAt(delStart) == '/') {
                        ++delStart;
                        if (delEnd >= buf.length() || buf.charAt(delEnd) != '/') break;
                        ++delEnd;
                        break;
                    }
                    --start;
                    while (start >= 0 && buf.charAt(start) != '/') {
                        --start;
                    }
                    continue block11;
                }
                case 3: {
                    if (buf.charAt(start + 1) != '.' || buf.charAt(start + 2) != '.') {
                        if (skip <= 0 || --skip != 0) break;
                        delStart = start >= 0 ? start : 0;
                        break;
                    }
                    delStart = start;
                    if (delEnd < 0) {
                        delEnd = end;
                    }
                    ++skip;
                    --start;
                    while (start >= 0 && buf.charAt(start) != '/') {
                        --start;
                    }
                    continue block11;
                }
                default: {
                    if (skip <= 0 || --skip != 0) break;
                    int n = delStart = start >= 0 ? start : 0;
                }
            }
            if (skip <= 0 && delStart >= 0 && delStart >= 0) {
                buf.delete(delStart, delEnd);
                delEnd = -1;
                delStart = -1;
                if (skip > 0) {
                    delEnd = end;
                }
            }
            --start;
            while (start >= 0 && buf.charAt(start) != '/') {
                --start;
            }
        }
        if (skip > 0) {
            return null;
        }
        if (delEnd >= 0) {
            buf.delete(delStart, delEnd);
        }
        if (path.endsWith(".") && buf.length() > 0 && buf.charAt(buf.length() - 1) != '/') {
            buf.append('/');
        }
        return buf.toString();
    }

    public static boolean hasScheme(String uri) {
        for (int i = 0; i < uri.length(); ++i) {
            char c = uri.charAt(i);
            if (c == ':') {
                return true;
            }
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || i > 0 && (c >= '0' && c <= '9' || c == '.' || c == '+' || c == '-'))) break;
        }
        return false;
    }
}

