/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.mortbay.util.MultiMap;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;

public class MultiPartRequest {
    HttpServletRequest _request;
    BufferedInputStream _in;
    String _boundary;
    byte[] _byteBoundary;
    MultiMap _partMap = new MultiMap(10);
    int _char = -2;
    boolean _lastPart = false;

    public MultiPartRequest(HttpServletRequest request) throws IOException {
        this._request = request;
        String content_type = request.getHeader("Content-Type");
        if (!content_type.startsWith("multipart/form-data")) {
            throw new IOException("Not multipart/form-data request");
        }
        this._in = new BufferedInputStream((InputStream)request.getInputStream());
        this._boundary = "--" + this.value(content_type.substring(content_type.indexOf("boundary=")));
        this._byteBoundary = (this._boundary + "--").getBytes(StringUtil.__ISO_8859_1);
        this.loadAllParts();
    }

    public String[] getPartNames() {
        Set s = this._partMap.keySet();
        return s.toArray(new String[s.size()]);
    }

    public boolean contains(String name) {
        Part part = (Part)this._partMap.get(name);
        return part != null;
    }

    public String getString(String name) {
        List part = this._partMap.getValues(name);
        if (part == null) {
            return null;
        }
        return new String(((Part)part.get((int)0))._data);
    }

    public String[] getStrings(String name) {
        List parts = this._partMap.getValues(name);
        if (parts == null) {
            return null;
        }
        String[] strings = new String[parts.size()];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = new String(((Part)parts.get((int)i))._data);
        }
        return strings;
    }

    public InputStream getInputStream(String name) {
        List part = this._partMap.getValues(name);
        if (part == null) {
            return null;
        }
        return new ByteArrayInputStream(((Part)part.get((int)0))._data);
    }

    public InputStream[] getInputStreams(String name) {
        List parts = this._partMap.getValues(name);
        if (parts == null) {
            return null;
        }
        InputStream[] streams = new InputStream[parts.size()];
        for (int i = 0; i < streams.length; ++i) {
            streams[i] = new ByteArrayInputStream(((Part)parts.get((int)i))._data);
        }
        return streams;
    }

    public Hashtable getParams(String name) {
        List part = this._partMap.getValues(name);
        if (part == null) {
            return null;
        }
        return ((Part)part.get((int)0))._headers;
    }

    public Hashtable[] getMultipleParams(String name) {
        List parts = this._partMap.getValues(name);
        if (parts == null) {
            return null;
        }
        Hashtable[] params = new Hashtable[parts.size()];
        for (int i = 0; i < params.length; ++i) {
            params[i] = ((Part)parts.get((int)i))._headers;
        }
        return params;
    }

    public String getFilename(String name) {
        List part = this._partMap.getValues(name);
        if (part == null) {
            return null;
        }
        return ((Part)part.get((int)0))._filename;
    }

    public String[] getFilenames(String name) {
        List parts = this._partMap.getValues(name);
        if (parts == null) {
            return null;
        }
        String[] filenames = new String[parts.size()];
        for (int i = 0; i < filenames.length; ++i) {
            filenames[i] = ((Part)parts.get((int)i))._filename;
        }
        return filenames;
    }

    private void loadAllParts() throws IOException {
        String line;
        byte[] bytes = TypeUtil.readLine(this._in);
        String string = line = bytes != null ? new String(bytes, "UTF-8") : null;
        if (line == null || !line.equals(this._boundary)) {
            throw new IOException("Missing initial multi part boundary");
        }
        while (!this._lastPart) {
            Part part = new Part();
            String content_disposition = null;
            while ((bytes = TypeUtil.readLine(this._in)) != null && bytes.length != 0) {
                int c = line.indexOf(58, 0);
                if (c <= 0) continue;
                String key = line.substring(0, c).trim().toLowerCase();
                String value = line.substring(c + 1, line.length()).trim();
                String ev = (String)part._headers.get(key);
                part._headers.put(key, ev != null ? ev + ';' + value : value);
                if (!key.equals("content-disposition")) continue;
                content_disposition = value;
            }
            boolean form_data = false;
            if (content_disposition == null) {
                throw new IOException("Missing content-disposition");
            }
            StringTokenizer tok = new StringTokenizer(content_disposition, ";");
            while (tok.hasMoreTokens()) {
                String t = tok.nextToken().trim();
                String tl = t.toLowerCase();
                if (t.startsWith("form-data")) {
                    form_data = true;
                    continue;
                }
                if (tl.startsWith("name=")) {
                    part._name = this.value(t);
                    continue;
                }
                if (!tl.startsWith("filename=")) continue;
                part._filename = this.value(t);
            }
            if (!form_data || part._name == null || part._name.length() == 0) continue;
            this._partMap.add(part._name, part);
            part._data = this.readBytes();
        }
    }

    private byte[] readBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean cr = false;
        boolean lf = false;
        while (true) {
            int c;
            int b = 0;
            while ((c = this._char != -2 ? this._char : this._in.read()) != -1) {
                this._char = -2;
                if (c == 13 || c == 10) {
                    if (c != 13) break;
                    this._char = this._in.read();
                    break;
                }
                if (b >= 0 && b < this._byteBoundary.length && c == this._byteBoundary[b]) {
                    ++b;
                    continue;
                }
                if (cr) {
                    baos.write(13);
                }
                if (lf) {
                    baos.write(10);
                }
                lf = false;
                cr = false;
                if (b > 0) {
                    baos.write(this._byteBoundary, 0, b);
                }
                b = -1;
                baos.write(c);
            }
            if (b > 0 && b < this._byteBoundary.length - 2 || b == this._byteBoundary.length - 1) {
                if (cr) {
                    baos.write(13);
                }
                if (lf) {
                    baos.write(10);
                }
                lf = false;
                cr = false;
                baos.write(this._byteBoundary, 0, b);
                b = -1;
            }
            if (b > 0 || c == -1) {
                if (b == this._byteBoundary.length) {
                    this._lastPart = true;
                }
                if (this._char != 10) break;
                this._char = -2;
                break;
            }
            if (cr) {
                baos.write(13);
            }
            if (lf) {
                baos.write(10);
            }
            cr = c == 13;
            boolean bl = lf = c == 10 || this._char == 10;
            if (this._char != 10) continue;
            this._char = -2;
        }
        return baos.toByteArray();
    }

    private String value(String nameEqualsValue) {
        String value = nameEqualsValue.substring(nameEqualsValue.indexOf(61) + 1).trim();
        int i = value.indexOf(59);
        if (i > 0) {
            value = value.substring(0, i);
        }
        if (value.startsWith("\"")) {
            value = value.substring(1, value.indexOf(34, 1));
        } else {
            i = value.indexOf(32);
            if (i > 0) {
                value = value.substring(0, i);
            }
        }
        return value;
    }

    private class Part {
        String _name = null;
        String _filename = null;
        Hashtable _headers = new Hashtable(10);
        byte[] _data = null;

        private Part() {
        }
    }
}

