/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.naming;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.mortbay.jetty.plus.naming.NamingEntry;

public class EnvEntry
extends NamingEntry {
    private boolean overrideWebXml;

    public static EnvEntry getEnvEntry(String jndiName) throws NamingException {
        return (EnvEntry)EnvEntry.lookupNamingEntry(EnvEntry.class, jndiName);
    }

    public EnvEntry(String jndiName, Object objToBind) throws NamingException {
        this(jndiName, objToBind, false);
    }

    public EnvEntry(String jndiName, Object objToBind, boolean overrideWebXml) throws NamingException {
        super(jndiName, objToBind);
        this.overrideWebXml = overrideWebXml;
    }

    public boolean isOverrideWebXml() {
        return this.overrideWebXml;
    }

    public void bindToEnv() throws NamingException {
        InitialContext iContext = new InitialContext();
        Context env = (Context)iContext.lookup("java:comp/env");
        boolean doBind = false;
        try {
            env.lookup(this.getJndiName());
            if (this.isOverrideWebXml()) {
                doBind = true;
            }
        }
        catch (NameNotFoundException e) {
            doBind = true;
        }
        if (doBind) {
            super.bindToEnv();
        }
    }
}

