/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.webapp;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.mortbay.jetty.plus.naming.EnvEntry;
import org.mortbay.jetty.plus.naming.NamingEntry;
import org.mortbay.jetty.plus.naming.Resource;
import org.mortbay.jetty.plus.naming.Transaction;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;
import org.mortbay.xml.XmlConfiguration;

public class EnvConfiguration
implements Configuration {
    private WebAppContext webAppContext;
    private Context compCtx;
    private Context envCtx;
    private Context localContext;
    private String localContextName;
    private URL jettyEnvXmlUrl;

    protected void createEnvContext() throws NamingException {
        InitialContext context = new InitialContext();
        this.compCtx = (Context)context.lookup("java:comp");
        this.envCtx = this.compCtx.createSubcontext("env");
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Created java:comp/env for webapp " + this.getWebAppContext().getContextPath()));
        }
    }

    public void setWebAppContext(WebAppContext context) {
        this.webAppContext = context;
    }

    public void setJettyEnvXml(URL url) {
        this.jettyEnvXmlUrl = url;
    }

    public WebAppContext getWebAppContext() {
        return this.webAppContext;
    }

    public void configureClassLoader() throws Exception {
    }

    public void configureDefaults() throws Exception {
    }

    public void configureWebApp() throws Exception {
        org.mortbay.resource.Resource jettyEnv;
        org.mortbay.resource.Resource webInf;
        this.createEnvContext();
        this.bindGlobalEnvEntries();
        this.localContextName = Long.toString(this.getWebAppContext().hashCode(), 36) + this.getWebAppContext().getContextPath().replace('/', '_');
        this.localContext = NamingEntry.createContext(this.localContextName);
        NamingEntry.setThreadLocalContext(this.localContext);
        if (this.jettyEnvXmlUrl == null && (webInf = this.getWebAppContext().getWebInf()) != null && webInf.isDirectory() && (jettyEnv = webInf.addPath("jetty-env.xml")).exists()) {
            this.jettyEnvXmlUrl = jettyEnv.getURL();
        }
        if (this.jettyEnvXmlUrl != null) {
            XmlConfiguration configuration = new XmlConfiguration(this.jettyEnvXmlUrl);
            configuration.configure((Object)this.getWebAppContext());
        }
        this.bindLocalEnvEntries();
    }

    public void deconfigureWebApp() throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.webAppContext.getClassLoader());
        this.unbindLocalNamingEntries();
        this.compCtx.destroySubcontext("env");
        NamingEntry.destroyContext(this.localContextName);
        NamingEntry.setThreadLocalContext(null);
        Thread.currentThread().setContextClassLoader(oldLoader);
    }

    public void bindGlobalEnvEntries() throws NamingException {
        Log.debug((String)"Finding global env entries");
        this.bindAllEnvEntries(new InitialContext());
    }

    public void bindLocalEnvEntries() throws NamingException {
        Log.debug((String)"Finding webapp specific env entries");
        this.bindAllEnvEntries(this.localContext);
    }

    public void bindAllEnvEntries(Context context) throws NamingException {
        List list = NamingEntry.lookupNamingEntries(context, EnvEntry.class);
        Iterator itor = list.iterator();
        Log.debug((String)("Finding env entries: size=" + list.size()));
        while (itor.hasNext()) {
            EnvEntry ee = (EnvEntry)itor.next();
            Log.debug((String)("configuring env entry " + ee.getJndiName()));
            ee.bindToEnv();
        }
    }

    public void unbindLocalNamingEntries() throws NamingException {
        List list = NamingEntry.lookupNamingEntries(this.localContext, EnvEntry.class);
        list.addAll(NamingEntry.lookupNamingEntries(this.localContext, Resource.class));
        list.addAll(NamingEntry.lookupNamingEntries(this.localContext, Transaction.class));
        Iterator itor = list.iterator();
        Log.debug((String)("Finding all naming entries for webapp local naming context: size=" + list.size()));
        while (itor.hasNext()) {
            NamingEntry ne = (NamingEntry)itor.next();
            Log.debug((String)("Unbinding naming entry " + ne.getJndiName()));
            ne.unbindEnv();
            ne.unbind();
        }
    }
}

