/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.webapp;

import javax.naming.Context;
import javax.naming.InitialContext;
import org.mortbay.jetty.plus.naming.EnvEntry;
import org.mortbay.jetty.plus.naming.Resource;
import org.mortbay.jetty.plus.naming.Transaction;
import org.mortbay.jetty.plus.webapp.AbstractConfiguration;
import org.mortbay.log.Log;
import org.mortbay.naming.NamingUtil;

public class Configuration
extends AbstractConfiguration {
    public void bindEnvEntry(String name, Object value) throws Exception {
        InitialContext ic = new InitialContext();
        Context envCtx = (Context)ic.lookup("java:comp/env");
        EnvEntry envEntry = EnvEntry.getEnvEntry(name);
        if (envEntry == null || envEntry != null && !envEntry.isOverrideWebXml()) {
            NamingUtil.bind((Context)envCtx, (String)name, (Object)value);
            Log.info((String)("Bound java:comp/env/" + name + "=" + value));
        }
    }

    public void bindResourceRef(String name) throws Exception {
        Resource resource = Resource.getResource(name);
        if (resource != null) {
            resource.bindToEnv();
            Log.info((String)("Bound resourceref java:comp/env/" + name));
        }
    }

    public void bindResourceEnvRef(String name) throws Exception {
        Resource resource = Resource.getResource(name);
        if (resource != null) {
            resource.bindToEnv();
            Log.info((String)("Bound resource-env-ref java:comp/env/" + name));
        }
    }

    public void bindUserTransaction() throws Exception {
        Transaction transaction = Transaction.getTransaction();
        if (transaction != null) {
            transaction.bindToEnv();
            Log.info((String)("Bound UserTransaction to java:comp/" + transaction.getJndiName()));
        }
    }

    public void configureClassLoader() throws Exception {
        super.configureClassLoader();
    }

    public void configureDefaults() throws Exception {
        super.configureDefaults();
    }

    public void configureWebApp() throws Exception {
        super.configureWebApp();
        InitialContext context = new InitialContext();
        Context compCtx = (Context)context.lookup("java:comp");
        compCtx.addToEnvironment("org.mortbay.jndi.immutable", "TRUE");
    }

    public void deconfigureWebApp() throws Exception {
        InitialContext icontext = new InitialContext();
        Context compCtx = (Context)icontext.lookup("java:comp");
        compCtx.removeFromEnvironment("org.mortbay.jndi.immutable");
        super.deconfigureWebApp();
    }
}

