/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.naming;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.mortbay.jetty.plus.naming.NamingEntry;
import org.mortbay.log.Log;

public class Resource
extends NamingEntry {
    public static Resource getResource(String jndiName) throws NamingException {
        try {
            Context context = Resource.getThreadLocalContext();
            Object o = null;
            if (context != null) {
                try {
                    o = Resource.lookupNamingEntry(context, Resource.class, jndiName);
                }
                catch (NameNotFoundException e) {
                    Log.ignore((Throwable)e);
                    Log.debug((String)("Didn't find Resource " + jndiName + " in thread local context " + context));
                }
            }
            if (o == null) {
                o = Resource.lookupNamingEntry(new InitialContext(), Resource.class, jndiName);
                Log.debug((String)("Found Resource in global context for " + jndiName));
            }
            return (Resource)o;
        }
        catch (NameNotFoundException e) {
            Log.debug((String)("Returning NULL as Resource not found for " + jndiName));
            return null;
        }
    }

    public Resource(String jndiName, Object objToBind) throws NamingException {
        super(jndiName, objToBind);
    }
}

