/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xml.binding;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.util.Classes;
import org.jboss.xml.binding.ContentNavigator;
import org.jboss.xml.binding.GenericObjectModelFactory;
import org.jboss.xml.binding.TypeConverter;
import org.xml.sax.Attributes;

public class MappingObjectModelFactory
implements GenericObjectModelFactory {
    private static final Logger log = Logger.getLogger(class$org$jboss$xml$binding$MappingObjectModelFactory == null ? (class$org$jboss$xml$binding$MappingObjectModelFactory = MappingObjectModelFactory.class$("org.jboss.xml.binding.MappingObjectModelFactory")) : class$org$jboss$xml$binding$MappingObjectModelFactory);
    private final Map elementToClassMapping = new HashMap();
    private final Map elementToFieldMapping = new HashMap();
    static /* synthetic */ Class class$org$jboss$xml$binding$MappingObjectModelFactory;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$util$Date;

    public void mapElementToClass(String element, Class cls) {
        ElementToClassMapping mapping = new ElementToClassMapping(element, cls);
        this.addElementToClassMapping(mapping);
    }

    public void mapElementToField(String element, Class cls, String field, TypeConverter converter) {
        ElementToFieldMapping mapping = new ElementToFieldMapping(element, cls, field, converter);
        this.addElementToFieldMapping(mapping);
    }

    public Object newRoot(Object root, ContentNavigator navigator, String namespaceURI, String localName, Attributes attrs) {
        if (root == null) {
            ElementToClassMapping mapping = (ElementToClassMapping)this.elementToClassMapping.get(localName);
            try {
                root = mapping.cls.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to instantiate root element: " + e.getMessage());
            }
        }
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                try {
                    this.setAttribute(root, attrs.getLocalName(i), attrs.getValue(i));
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to set attributes: " + e.getMessage());
                }
            }
        }
        return root;
    }

    public Object newChild(Object o, ContentNavigator navigator, String namespaceURI, String localName, Attributes attrs) {
        Object child = null;
        ElementToClassMapping mapping = (ElementToClassMapping)this.elementToClassMapping.get(localName);
        if (mapping != null) {
            try {
                if (!(o instanceof Collection)) {
                    ElementToFieldMapping fieldMapping = (ElementToFieldMapping)this.elementToFieldMapping.get(localName);
                    Method getter = fieldMapping != null ? fieldMapping.getter : Classes.getAttributeGetter(o.getClass(), localName);
                    child = getter.invoke(o, null);
                }
                if (child == null) {
                    child = mapping.cls.newInstance();
                }
                if (attrs != null) {
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        this.setAttribute(child, attrs.getLocalName(i), attrs.getValue(i));
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("newChild failed for o=" + o + ", uri=" + namespaceURI + ", local=" + localName + ", attrs=" + attrs);
            }
        }
        return child;
    }

    public void addChild(Object parent, Object child, ContentNavigator navigator, String namespaceURI, String localName) {
        Object value = child;
        if (parent instanceof Collection) {
            ((Collection)parent).add(value);
        } else {
            Method setter = null;
            ElementToFieldMapping fieldMapping = (ElementToFieldMapping)this.elementToFieldMapping.get(localName);
            if (fieldMapping != null) {
                setter = fieldMapping.setter;
            } else {
                try {
                    Method getter = Classes.getAttributeGetter(parent.getClass(), localName);
                    Class<?> type = getter.getReturnType();
                    setter = Classes.getAttributeSetter(parent.getClass(), localName, type);
                }
                catch (NoSuchMethodException e) {
                    log.warn("no setter found for " + localName);
                }
            }
            if (setter != null) {
                try {
                    setter.invoke(parent, value);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to addChild for o=" + parent + ", local=" + localName + ", value=" + value + ": " + e.getMessage());
                }
            }
        }
    }

    public void setValue(Object o, ContentNavigator navigator, String namespaceURI, String localName, String value) {
        this.setAttribute(o, localName, value);
    }

    private void addElementToClassMapping(ElementToClassMapping mapping) {
        this.elementToClassMapping.put(mapping.element, mapping);
    }

    private void addElementToFieldMapping(ElementToFieldMapping mapping) {
        this.elementToFieldMapping.put(mapping.element, mapping);
    }

    private final void setAttribute(Object o, String localName, String value) {
        if (o instanceof Collection) {
            ((Collection)o).add(value);
        } else {
            Method setter = null;
            Object fieldValue = null;
            ElementToFieldMapping fieldMapping = (ElementToFieldMapping)this.elementToFieldMapping.get(localName);
            if (fieldMapping != null) {
                fieldValue = fieldMapping.converter.unmarshal(value);
                setter = fieldMapping.setter;
            } else {
                try {
                    Method getter = Classes.getAttributeGetter(o.getClass(), localName);
                    Class<?> type = getter.getReturnType();
                    setter = Classes.getAttributeSetter(o.getClass(), localName, type);
                    fieldValue = MappingObjectModelFactory.getTypeConverter(type).unmarshal(value);
                }
                catch (NoSuchMethodException e) {
                    log.warn("no setter found for " + localName);
                }
            }
            if (setter != null) {
                try {
                    setter.invoke(o, fieldValue);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to set attribute for o=" + o + ", local=" + localName + ", value=" + value + ": " + e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final TypeConverter getTypeConverter(Class type) {
        void var1_1;
        TypeConverter result;
        if ((class$java$lang$String == null ? (class$java$lang$String = MappingObjectModelFactory.class$("java.lang.String")) : class$java$lang$String) == type) {
            result = TypeConverter.STRING;
        } else if (Integer.TYPE == type || (class$java$lang$Integer == null ? (class$java$lang$Integer = MappingObjectModelFactory.class$("java.lang.Integer")) : class$java$lang$Integer) == type) {
            result = TypeConverter.INT;
        } else if (Long.TYPE == type || (class$java$lang$Long == null ? (class$java$lang$Long = MappingObjectModelFactory.class$("java.lang.Long")) : class$java$lang$Long) == type) {
            result = TypeConverter.LONG;
        } else if (Double.TYPE == type || (class$java$lang$Double == null ? (class$java$lang$Double = MappingObjectModelFactory.class$("java.lang.Double")) : class$java$lang$Double) == type) {
            result = TypeConverter.DOUBLE;
        } else if (Float.TYPE == type || (class$java$lang$Float == null ? (class$java$lang$Float = MappingObjectModelFactory.class$("java.lang.Float")) : class$java$lang$Float) == type) {
            result = TypeConverter.FLOAT;
        } else if (Short.TYPE == type || (class$java$lang$Short == null ? (class$java$lang$Short = MappingObjectModelFactory.class$("java.lang.Short")) : class$java$lang$Short) == type) {
            result = TypeConverter.SHORT;
        } else if (Byte.TYPE == type || (class$java$lang$Byte == null ? (class$java$lang$Byte = MappingObjectModelFactory.class$("java.lang.Byte")) : class$java$lang$Byte) == type) {
            result = TypeConverter.BYTE;
        } else if (Character.TYPE == type || (class$java$lang$Character == null ? (class$java$lang$Character = MappingObjectModelFactory.class$("java.lang.Character")) : class$java$lang$Character) == type) {
            result = TypeConverter.CHAR;
        } else if ((class$java$util$Date == null ? (class$java$util$Date = MappingObjectModelFactory.class$("java.util.Date")) : class$java$util$Date) == type) {
            result = TypeConverter.JAVA_UTIL_DATE;
        } else {
            throw new IllegalStateException("Unexpected field type " + type);
        }
        return var1_1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ElementToFieldMapping {
        public final String element;
        public final Class cls;
        public final String field;
        public final TypeConverter converter;
        public final Method getter;
        public final Method setter;

        public ElementToFieldMapping(String element, Class cls, String field, TypeConverter converter) {
            this.element = element;
            this.cls = cls;
            this.field = field;
            this.converter = converter;
            try {
                this.getter = Classes.getAttributeGetter(cls, field);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Getter not found for " + field + " in class " + cls.getName());
            }
            try {
                this.setter = Classes.getAttributeSetter(cls, field, this.getter.getReturnType());
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Setter not found for " + field + " in class " + cls.getName());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ElementToFieldMapping)) {
                return false;
            }
            ElementToFieldMapping elementToFieldMapping = (ElementToFieldMapping)o;
            if (this.cls != null ? !this.cls.equals(elementToFieldMapping.cls) : elementToFieldMapping.cls != null) {
                return false;
            }
            if (this.element != null ? !this.element.equals(elementToFieldMapping.element) : elementToFieldMapping.element != null) {
                return false;
            }
            return !(this.field != null ? !this.field.equals(elementToFieldMapping.field) : elementToFieldMapping.field != null);
        }

        public int hashCode() {
            int result = this.element != null ? this.element.hashCode() : 0;
            result = 29 * result + (this.cls != null ? this.cls.hashCode() : 0);
            result = 29 * result + (this.field != null ? this.field.hashCode() : 0);
            return result;
        }
    }

    private class ElementToClassMapping {
        public final String element;
        public final Class cls;

        public ElementToClassMapping(String element, Class cls) {
            this.element = element;
            this.cls = cls;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ElementToClassMapping)) {
                return false;
            }
            ElementToClassMapping classMapping = (ElementToClassMapping)o;
            return !(this.cls != null ? !this.cls.equals(classMapping.cls) : classMapping.cls != null);
        }

        public int hashCode() {
            return this.cls != null ? this.cls.hashCode() : 0;
        }
    }
}

