/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.timeout;

import org.jboss.util.ThrowableHandler;
import org.jboss.util.threadpool.BasicThreadPool;
import org.jboss.util.threadpool.BlockingMode;
import org.jboss.util.threadpool.ThreadPool;
import org.jboss.util.timeout.Timeout;
import org.jboss.util.timeout.TimeoutTarget;

public class TimeoutFactory {
    private static TimeoutFactory singleton;
    private static int timeoutFactoriesCount;
    private static BasicThreadPool DEFAULT_TP;
    private boolean cancelled;
    private Thread workerThread;
    private ThreadPool threadPool;
    private TimeoutImpl freeList;
    private int size;
    private TimeoutImpl[] q;

    private static synchronized TimeoutFactory getSingleton() {
        if (singleton == null) {
            singleton = new TimeoutFactory(DEFAULT_TP);
        }
        return singleton;
    }

    public static Timeout createTimeout(long time, TimeoutTarget target) {
        return TimeoutFactory.getSingleton().schedule(time, target);
    }

    public TimeoutFactory(ThreadPool threadPool) {
        this.threadPool = threadPool;
        this.q = new TimeoutImpl[16];
        this.freeList = null;
        this.size = 0;
        this.workerThread = new Thread("TimeoutFactory-" + timeoutFactoriesCount++){

            public void run() {
                TimeoutFactory.this.doWork();
            }
        };
        this.workerThread.setDaemon(true);
        this.workerThread.start();
    }

    public TimeoutFactory() {
        this(DEFAULT_TP);
    }

    public Timeout schedule(long time, TimeoutTarget target) {
        if (this.cancelled) {
            throw new IllegalStateException("TimeoutFactory has been cancelled");
        }
        if (time < 0L) {
            throw new IllegalArgumentException("Negative time");
        }
        if (target == null) {
            throw new IllegalArgumentException("Null timeout target");
        }
        return this.newTimeout(time, target);
    }

    public Timeout schedule(long time, Runnable run) {
        return this.schedule(time, new TimeoutTargetImpl(run));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.cancelled = true;
        TimeoutFactory timeoutFactory = this;
        synchronized (timeoutFactory) {
            this.notify();
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    private void assertExpr(boolean expr) {
        if (!expr) {
            RuntimeException ex = new RuntimeException("***** assert failed *****");
            try {
                Thread.sleep(30000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void checkTree() {
        this.assertExpr(this.size >= 0);
        this.assertExpr(this.size < this.q.length);
        this.assertExpr(this.q[0] == null);
        if (this.size > 0) {
            int i;
            this.assertExpr(this.q[1] != null);
            this.assertExpr(this.q[1].index == 1);
            for (i = 2; i <= this.size; ++i) {
                this.assertExpr(this.q[i] != null);
                this.assertExpr(this.q[i].index == i);
                this.assertExpr(this.q[i >> 1].time <= this.q[i].time);
            }
            for (i = this.size + 1; i < this.q.length; ++i) {
                this.assertExpr(this.q[i] == null);
            }
        }
    }

    private void checkFreeList() {
        TimeoutImpl to = this.freeList;
        while (to != null) {
            this.assertExpr(to.index == -1);
            to = to.nextFree;
        }
    }

    private void swap(int a, int b) {
        TimeoutImpl temp = this.q[a];
        this.q[a] = this.q[b];
        this.q[a].index = a;
        this.q[b] = temp;
        this.q[b].index = b;
    }

    private boolean normalizeUp(int index) {
        if (index == 1) {
            return false;
        }
        boolean ret = false;
        long t = this.q[index].time;
        int p = index >> 1;
        while (this.q[p].time > t) {
            this.swap(p, index);
            ret = true;
            if (p == 1) break;
            index = p;
            p >>= 1;
        }
        return ret;
    }

    private TimeoutImpl removeNode(int index) {
        TimeoutImpl res = this.q[index];
        if (index == this.size) {
            --this.size;
            this.q[index] = null;
            return res;
        }
        this.swap(index, this.size);
        --this.size;
        this.q[res.index] = null;
        if (this.normalizeUp(index)) {
            return res;
        }
        long t = this.q[index].time;
        int c = index << 1;
        while (c <= this.size) {
            TimeoutImpl l = this.q[c];
            if (c + 1 <= this.size) {
                TimeoutImpl r = this.q[c + 1];
                if (l.time <= r.time) {
                    if (t <= l.time) break;
                    this.swap(index, c);
                    index = c;
                } else {
                    if (t <= r.time) break;
                    this.swap(index, c + 1);
                    index = c + 1;
                }
            } else {
                if (t <= l.time) break;
                this.swap(index, c);
                index = c;
            }
            c = index << 1;
        }
        return res;
    }

    private synchronized Timeout newTimeout(long time, TimeoutTarget target) {
        TimeoutImpl timeout;
        if (++this.size == this.q.length) {
            TimeoutImpl[] newQ = new TimeoutImpl[2 * this.q.length];
            System.arraycopy(this.q, 0, newQ, 0, this.q.length);
            this.q = newQ;
        }
        if (this.freeList != null) {
            timeout = this.q[this.size] = this.freeList;
            this.freeList = timeout.nextFree;
            timeout.nextFree = null;
        } else {
            timeout = this.q[this.size] = new TimeoutImpl();
        }
        timeout.index = this.size;
        timeout.time = time;
        timeout.target = target;
        this.normalizeUp(this.size);
        if (timeout.index == 1) {
            this.notify();
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dropTimeout(TimeoutImpl timeout) {
        TimeoutFactory timeoutFactory = this;
        synchronized (timeoutFactory) {
            if (timeout.index > 0) {
                this.removeNode(timeout.index);
                timeout.index = -1;
                timeout.nextFree = this.freeList;
                this.freeList = timeout;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork() {
        while (!this.cancelled) {
            TimeoutImpl work = null;
            TimeoutFactory timeoutFactory = this;
            synchronized (timeoutFactory) {
                if (this.size == 0 && !this.cancelled) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {}
                } else {
                    long now = System.currentTimeMillis();
                    if (this.q[1].time > now && !this.cancelled) {
                        try {
                            this.wait(this.q[1].time - now);
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                    }
                    if (this.size > 0 && this.q[1].time <= System.currentTimeMillis() && !this.cancelled) {
                        work = this.removeNode(1);
                        work.index = -2;
                    }
                }
            }
            if (work == null) continue;
            TimeoutWorker worker = new TimeoutWorker(work);
            try {
                this.threadPool.run(worker);
            }
            catch (Throwable t) {
                ThrowableHandler.add(1, t);
            }
            TimeoutImpl timeoutImpl = work;
            synchronized (timeoutImpl) {
                work.index = -1;
            }
        }
        this.cleanup();
    }

    private void cleanup() {
        this.freeList = this.cleanupTimeoutImpl(this.freeList);
        for (int i = 1; i <= this.size; ++i) {
            this.q[i] = this.cleanupTimeoutImpl(this.q[i]);
        }
        this.q = null;
        this.threadPool = null;
        this.workerThread = null;
    }

    private TimeoutImpl cleanupTimeoutImpl(TimeoutImpl timeout) {
        if (timeout != null) {
            timeout.target = null;
            timeout.nextFree = this.cleanupTimeoutImpl(timeout.nextFree);
        }
        return null;
    }

    static {
        timeoutFactoriesCount = 0;
        DEFAULT_TP = new BasicThreadPool("Timeouts");
        DEFAULT_TP.setBlockingMode(BlockingMode.RUN);
    }

    private static class TimeoutTargetImpl
    implements TimeoutTarget {
        Runnable runnable;

        TimeoutTargetImpl(Runnable runnable) {
            this.runnable = runnable;
        }

        public void timedOut(Timeout ignored) {
            this.runnable.run();
        }
    }

    private static class TimeoutWorker
    implements Runnable {
        private TimeoutImpl work;

        TimeoutWorker(TimeoutImpl work) {
            this.work = work;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.work.target.timedOut(this.work);
            }
            catch (Throwable t) {
                ThrowableHandler.add(1, t);
            }
            TimeoutImpl timeoutImpl = this.work;
            synchronized (timeoutImpl) {
                this.work.index = -1;
            }
        }
    }

    private class TimeoutImpl
    implements Timeout {
        static final int DONE = -1;
        static final int TIMEOUT = -2;
        int index;
        long time;
        TimeoutTarget target;
        TimeoutImpl nextFree;

        private TimeoutImpl() {
        }

        public boolean cancel() {
            return TimeoutFactory.this.dropTimeout(this);
        }
    }
}

