/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import org.jboss.util.Executable;
import org.jboss.util.ThrowableHandler;

public class WorkerQueue {
    protected Thread m_queueThread;
    private JobItem m_currentJob;

    public WorkerQueue() {
        this("Worker Thread");
    }

    public WorkerQueue(String threadName) {
        this.m_queueThread = new Thread(this.createQueueLoop(), threadName);
    }

    public WorkerQueue(String threadName, boolean isDaemon) {
        this.m_queueThread = new Thread(this.createQueueLoop(), threadName);
        this.m_queueThread.setDaemon(isDaemon);
    }

    public void start() {
        if (this.m_queueThread != null) {
            this.m_queueThread.start();
        }
    }

    public synchronized void stop() {
        if (this.m_queueThread != null) {
            this.m_queueThread.interrupt();
        }
    }

    public synchronized void putJob(Executable job) {
        if (this.m_queueThread == null || !this.m_queueThread.isAlive()) {
            throw new IllegalStateException("Can't put job, thread is not alive or not present");
        }
        if (this.isInterrupted()) {
            throw new IllegalStateException("Can't put job, thread was interrupted");
        }
        this.putJobImpl(job);
    }

    protected boolean isInterrupted() {
        return this.m_queueThread.isInterrupted();
    }

    protected synchronized Executable getJob() throws InterruptedException {
        if (this.m_queueThread == null || !this.m_queueThread.isAlive()) {
            throw new IllegalStateException();
        }
        return this.getJobImpl();
    }

    protected Executable getJobImpl() throws InterruptedException {
        while (this.m_currentJob == null) {
            this.wait();
        }
        JobItem item = this.m_currentJob;
        this.m_currentJob = this.m_currentJob.m_next;
        return item.m_job;
    }

    protected void putJobImpl(Executable job) {
        JobItem posted = new JobItem(job);
        if (this.m_currentJob == null) {
            this.m_currentJob = posted;
            this.notifyAll();
        } else {
            JobItem item = this.m_currentJob;
            while (item.m_next != null) {
                item = item.m_next;
            }
            item.m_next = posted;
        }
    }

    protected void clear() {
        this.m_queueThread = null;
        this.m_currentJob = null;
    }

    protected Runnable createQueueLoop() {
        return new QueueLoop();
    }

    private static class JobItem {
        private Executable m_job;
        private JobItem m_next;

        private JobItem(Executable job) {
            this.m_job = job;
        }
    }

    protected class QueueLoop
    implements Runnable {
        protected QueueLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block11: {
                try {
                    while (true) {
                        try {
                            while (true) {
                                if (WorkerQueue.this.isInterrupted()) {
                                    this.flush();
                                    break block11;
                                }
                                WorkerQueue.this.getJob().execute();
                            }
                        }
                        catch (InterruptedException e) {
                            try {
                                this.flush();
                            }
                            catch (Exception exception) {}
                        }
                        catch (Exception e) {
                            ThrowableHandler.add(1, e);
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    WorkerQueue.this.clear();
                }
            }
        }

        protected void flush() throws Exception {
            while (WorkerQueue.this.m_currentJob != null) {
                WorkerQueue.this.m_currentJob.m_job.execute();
                WorkerQueue.this.m_currentJob = WorkerQueue.this.m_currentJob.m_next;
            }
        }
    }
}

