/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.util.ArrayList;

public class ProfilerPoint {
    public final String point;
    public final long time = System.currentTimeMillis();
    private static final ThreadLocal profilePoints = new ThreadLocal();
    private static final ThreadLocal startTime = new ThreadLocal();
    private static final String NOW = "NOW ";

    public ProfilerPoint(String p) {
        this.point = p;
    }

    public static void start() {
        startTime.set(new Long(System.currentTimeMillis()));
    }

    public static long getStartTime() {
        Long l = (Long)startTime.get();
        if (l == null) {
            return -1L;
        }
        return l;
    }

    public static void push(String point) {
        ArrayList<ProfilerPoint> points = (ArrayList<ProfilerPoint>)profilePoints.get();
        if (points == null) {
            points = new ArrayList<ProfilerPoint>(20);
            profilePoints.set(points);
        }
        points.add(new ProfilerPoint(point));
    }

    public static void pop() {
        ArrayList points = (ArrayList)profilePoints.get();
        if (points == null) {
            return;
        }
        if (points.size() == 0) {
            return;
        }
        points.remove(points.size() - 1);
    }

    public static ArrayList points() {
        return (ArrayList)profilePoints.get();
    }

    public static void clear() {
        profilePoints.set(null);
    }

    public static String stack() {
        ArrayList points = (ArrayList)profilePoints.get();
        if (points == null) {
            return NOW;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < points.size(); ++i) {
            ProfilerPoint point = (ProfilerPoint)points.get(i);
            buf.append(point.point + " " + point.time);
            buf.append(":");
        }
        buf.append(NOW + System.currentTimeMillis());
        return buf.toString();
    }
}

