/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import org.jboss.util.HashCode;
import org.jboss.util.MuNumber;
import org.jboss.util.NotCoercibleException;
import org.jboss.util.Primitives;

public class MuDouble
extends MuNumber {
    private double value = 0.0;

    public MuDouble() {
    }

    public MuDouble(double d) {
        this.value = d;
    }

    public MuDouble(Object obj) {
        this.setValue(obj);
    }

    public double set(double f) {
        double old = this.value;
        this.value = f;
        return old;
    }

    public double get() {
        return this.value;
    }

    public boolean commit(double assumed, double b) {
        boolean success = Primitives.equals(assumed, this.value);
        if (success) {
            this.value = b;
        }
        return success;
    }

    public double swap(MuDouble b) {
        if (b == this) {
            return this.value;
        }
        double temp = this.value;
        this.value = b.value;
        b.value = temp;
        return this.value;
    }

    public double add(double amount) {
        return this.value += amount;
    }

    public double subtract(double amount) {
        return this.value -= amount;
    }

    public double multiply(double factor) {
        return this.value *= factor;
    }

    public double divide(double factor) {
        return this.value /= factor;
    }

    public double negate() {
        this.value = -this.value;
        return this.value;
    }

    public int compareTo(double other) {
        return this.value < other ? -1 : (Primitives.equals(this.value, other) ? 0 : 1);
    }

    public int compareTo(Object obj) {
        return this.compareTo(((MuDouble)obj).value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return HashCode.generate(this.value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            return Primitives.equals(this.value, ((MuDouble)obj).doubleValue());
        }
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public void setValue(Object obj) {
        if (!(obj instanceof Number)) {
            throw new NotCoercibleException("can not convert to 'double': " + obj);
        }
        this.value = ((Number)obj).doubleValue();
    }

    public Object getValue() {
        return new Double(this.value);
    }
}

