/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.tm.GlobalId;
import org.jboss.tm.TransactionImpl;
import org.jboss.tm.TransactionLocal;
import org.jboss.tm.TransactionLocalDelegate;
import org.jboss.tm.TransactionPropagationContextFactory;
import org.jboss.tm.TransactionPropagationContextImporter;
import org.jboss.tm.TransactionTimeoutConfiguration;

public class TxManager
implements TransactionManager,
TransactionPropagationContextImporter,
TransactionPropagationContextFactory,
TransactionLocalDelegate,
TransactionTimeoutConfiguration {
    private Logger log = Logger.getLogger(this.getClass());
    private boolean trace = this.log.isTraceEnabled();
    private long timeOut = 300000L;
    private volatile int commitCount;
    private volatile int rollbackCount;
    private static TxManager singleton = new TxManager();
    private ThreadLocal threadTx = new ThreadLocal();
    private Map globalIdTx = Collections.synchronizedMap(new HashMap());

    public static TxManager getInstance() {
        return singleton;
    }

    private TxManager() {
        TransactionImpl.defaultXidFactory();
    }

    public void begin() throws NotSupportedException, SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            if (current.isDone()) {
                this.disassociateThread(ti);
            } else {
                throw new NotSupportedException("Transaction already active, cannot nest transactions.");
            }
        }
        long timeout = ti.timeout == 0L ? this.timeOut : ti.timeout;
        TransactionImpl tx = new TransactionImpl(timeout);
        this.associateThread(ti, tx);
        this.globalIdTx.put(tx.getGlobalId(), tx);
        if (this.trace) {
            this.log.trace("began tx: " + tx);
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            current.commit();
            this.disassociateThread(ti);
            if (this.trace) {
                this.log.trace("commited tx: " + current);
            }
        } else {
            throw new IllegalStateException("No transaction.");
        }
    }

    public int getStatus() throws SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            if (current.isDone()) {
                this.disassociateThread(ti);
            } else {
                return current.getStatus();
            }
        }
        return 6;
    }

    public Transaction getTransaction() throws SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null && current.isDone()) {
            current = null;
            this.disassociateThread(ti);
        }
        return current;
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (transaction != null && !(transaction instanceof TransactionImpl)) {
            throw new RuntimeException("Not a TransactionImpl, but a " + transaction.getClass().getName());
        }
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            if (current.isDone()) {
                ti.tx = null;
                current = null;
            } else {
                throw new IllegalStateException("Already associated with a tx");
            }
        }
        if (current != transaction) {
            this.associateThread(ti, (TransactionImpl)transaction);
        }
        if (this.trace) {
            this.log.trace("resumed tx: " + ti.tx);
        }
    }

    public Transaction suspend() throws SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            ti.tx = null;
            if (this.trace) {
                this.log.trace("suspended tx: " + current);
            }
            if (current.isDone()) {
                current = null;
            }
        }
        return current;
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            if (!current.isDone()) {
                current.rollback();
                if (this.trace) {
                    this.log.trace("rolled back tx: " + current);
                }
                return;
            }
            this.disassociateThread(ti);
        }
        throw new IllegalStateException("No transaction.");
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            if (!current.isDone()) {
                current.setRollbackOnly();
                if (this.trace) {
                    this.log.trace("tx marked for rollback only: " + current);
                }
                return;
            }
            ti.tx = null;
        }
        throw new IllegalStateException("No transaction.");
    }

    public int getTransactionTimeout() throws SystemException {
        return (int)(this.getThreadInfo().timeout / 1000L);
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.getThreadInfo().timeout = 1000 * seconds;
        if (this.trace) {
            this.log.trace("tx timeout is now: " + seconds + "s");
        }
    }

    public void setDefaultTransactionTimeout(int seconds) {
        this.timeOut = 1000L * (long)seconds;
        if (this.trace) {
            this.log.trace("default tx timeout is now: " + seconds + "s");
        }
    }

    public int getDefaultTransactionTimeout() {
        return (int)(this.timeOut / 1000L);
    }

    public long getTimeLeftBeforeTransactionTimeout(boolean errorRollback) throws RollbackException {
        try {
            ThreadInfo ti = this.getThreadInfo();
            TransactionImpl current = ti.tx;
            if (current != null && current.isDone()) {
                this.disassociateThread(ti);
                return -1L;
            }
            return current.getTimeLeftBeforeTimeout(errorRollback);
        }
        catch (RollbackException e) {
            throw e;
        }
        catch (Exception ignored) {
            return -1L;
        }
    }

    public Transaction disassociateThread() {
        return this.disassociateThread(this.getThreadInfo());
    }

    private Transaction disassociateThread(ThreadInfo ti) {
        TransactionImpl current = ti.tx;
        ti.tx = null;
        current.disassociateCurrentThread();
        return current;
    }

    public void associateThread(Transaction transaction) {
        if (transaction != null && !(transaction instanceof TransactionImpl)) {
            throw new RuntimeException("Not a TransactionImpl, but a " + transaction.getClass().getName());
        }
        TransactionImpl transactionImpl = (TransactionImpl)transaction;
        ThreadInfo ti = this.getThreadInfo();
        ti.tx = transactionImpl;
        transactionImpl.associateCurrentThread();
    }

    private void associateThread(ThreadInfo ti, TransactionImpl transaction) {
        ti.tx = transaction;
        transaction.associateCurrentThread();
    }

    public int getTransactionCount() {
        return this.globalIdTx.size();
    }

    public long getCommitCount() {
        return this.commitCount;
    }

    public long getRollbackCount() {
        return this.rollbackCount;
    }

    public Transaction importTransactionPropagationContext(Object tpc) {
        if (tpc instanceof GlobalId) {
            GlobalId id = (GlobalId)tpc;
            return (Transaction)this.globalIdTx.get(id);
        }
        this.log.warn("Cannot import transaction propagation context: " + tpc);
        return null;
    }

    public Object getTransactionPropagationContext() {
        return this.getTransactionPropagationContext(this.getThreadInfo().tx);
    }

    public Object getTransactionPropagationContext(Transaction tx) {
        if (tx == null) {
            return null;
        }
        if (!(tx instanceof TransactionImpl)) {
            this.log.warn("Cannot export transaction propagation context: " + tx);
            return null;
        }
        return ((TransactionImpl)tx).getGlobalId();
    }

    public Object getValue(TransactionLocal local, Transaction tx) {
        TransactionImpl tximpl = (TransactionImpl)tx;
        return tximpl.getTransactionLocalValue(local);
    }

    public void storeValue(TransactionLocal local, Transaction tx, Object value) {
        TransactionImpl tximpl = (TransactionImpl)tx;
        tximpl.putTransactionLocalValue(local, value);
    }

    public boolean containsValue(TransactionLocal local, Transaction tx) {
        TransactionImpl tximpl = (TransactionImpl)tx;
        return tximpl.containsTransactionLocal(local);
    }

    void releaseTransactionImpl(TransactionImpl tx) {
        this.globalIdTx.remove(tx.getGlobalId());
    }

    void incCommitCount() {
        ++this.commitCount;
    }

    void incRollbackCount() {
        ++this.rollbackCount;
    }

    private ThreadInfo getThreadInfo() {
        ThreadInfo ret = (ThreadInfo)this.threadTx.get();
        if (ret == null) {
            ret = new ThreadInfo();
            ret.timeout = this.timeOut;
            this.threadTx.set(ret);
        }
        return ret;
    }

    static class ThreadInfo {
        long timeout;
        TransactionImpl tx;

        ThreadInfo() {
        }
    }
}

