/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.login;

import java.net.URL;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentException;
import org.jboss.security.auth.login.DynamicLoginConfigMBean;
import org.jboss.system.ServiceMBeanSupport;

public class DynamicLoginConfig
extends ServiceMBeanSupport
implements DynamicLoginConfigMBean {
    private String authConf = "login-config.xml";
    private ObjectName loginConfigService;
    private ObjectName securityMgrService;
    private String[] configNames;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$net$URL;

    public String getName() {
        return "Dynamic JAAS Login Config";
    }

    public ObjectName getLoginConfigService() {
        return this.loginConfigService;
    }

    public void setLoginConfigService(ObjectName serviceName) {
        this.loginConfigService = serviceName;
    }

    public ObjectName getSecurityManagerService() {
        return this.securityMgrService;
    }

    public void setSecurityManagerService(ObjectName serviceName) {
        this.securityMgrService = serviceName;
    }

    public String getAuthConfig() {
        return this.authConf;
    }

    public void setAuthConfig(String authConf) {
        this.authConf = authConf;
    }

    public void flushAuthenticationCaches() throws Exception {
        if (this.securityMgrService != null && this.server.isRegistered(this.securityMgrService)) {
            int count = this.configNames == null ? 0 : this.configNames.length;
            String[] sig = new String[]{(class$java$lang$String == null ? (class$java$lang$String = DynamicLoginConfig.class$("java.lang.String")) : class$java$lang$String).getName()};
            for (int n = 0; n < count; ++n) {
                Object[] args = new Object[]{this.configNames[n]};
                this.server.invoke(this.securityMgrService, "flushAuthenticationCache", args, sig);
                this.log.debug("Flushed domain: " + this.configNames[n]);
            }
        }
    }

    protected void startService() throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL loginConfig = loader.getResource(this.authConf);
        if (loginConfig != null) {
            this.log.debug("Using JAAS AuthConfig: " + loginConfig.toExternalForm());
            MBeanServer server = super.getServer();
            Object[] args = new Object[]{loginConfig};
            String[] sig = new String[]{(class$java$net$URL == null ? (class$java$net$URL = DynamicLoginConfig.class$("java.net.URL")) : class$java$net$URL).getName()};
            this.configNames = (String[])server.invoke(this.loginConfigService, "loadConfig", args, sig);
            int count = this.configNames == null ? 0 : this.configNames.length;
            for (int n = 0; n < count; ++n) {
                this.log.debug("Loaded config: " + this.configNames[n]);
            }
        } else {
            throw new DeploymentException("Failed to find authConf as resource: " + this.authConf);
        }
    }

    protected void stopService() throws Exception {
        MBeanServer server = super.getServer();
        this.flushAuthenticationCaches();
        if (this.configNames != null && this.configNames.length > 0) {
            Object[] args = new Object[]{this.configNames};
            String[] sig = new String[]{this.configNames.getClass().getName()};
            server.invoke(this.loginConfigService, "removeConfigs", args, sig);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

