/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.axis.server;

import java.security.Principal;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import org.jboss.axis.AxisFault;
import org.jboss.axis.MessageContext;
import org.jboss.axis.handlers.BasicHandler;
import org.jboss.axis.utils.Messages;
import org.jboss.security.NobodyPrincipal;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.SubjectSecurityManager;

public class JBossAuthenticationHandler
extends BasicHandler {
    protected boolean isInitialised;
    protected boolean shouldValidateUnauthenticatedCalls;
    protected SubjectSecurityManager authMgr;

    protected void initialise() throws AxisFault {
        String unauthenticatedCalls;
        this.isInitialised = true;
        this.authMgr = null;
        this.shouldValidateUnauthenticatedCalls = false;
        String securityDomain = (String)this.getOption("securityDomain");
        if (securityDomain != null) {
            try {
                this.authMgr = (SubjectSecurityManager)new InitialContext().lookup(securityDomain);
            }
            catch (NamingException e) {
                throw new AxisFault("Could not lookup associated security domain " + securityDomain, (Throwable)e);
            }
        }
        if ((unauthenticatedCalls = (String)this.getOption("validateUnauthenticatedCalls")) != null) {
            try {
                this.shouldValidateUnauthenticatedCalls = new Boolean(unauthenticatedCalls);
            }
            catch (Exception e) {
                throw new AxisFault("Could not set validateUnauthenticatedCalls option.", (Throwable)e);
            }
        }
    }

    protected Principal getPrincipal(String userName) {
        if (userName == null) {
            return NobodyPrincipal.NOBODY_PRINCIPAL;
        }
        return new SimplePrincipal(userName);
    }

    protected Subject validate(Principal userPrincipal, String passwd) throws AxisFault {
        char[] passChars = passwd != null ? passwd.toCharArray() : null;
        Subject subject = null;
        if ((this.shouldValidateUnauthenticatedCalls || userPrincipal != NobodyPrincipal.NOBODY_PRINCIPAL) && !this.authMgr.isValid(userPrincipal, passChars, subject = new Subject())) {
            throw new AxisFault("Server.Unauthenticated", Messages.getMessage((String)"cantAuth01", (String)userPrincipal.getName()), null, null);
        }
        return subject;
    }

    protected void associate(Principal userPrincipal, String passwd, Subject subject) {
        if (this.shouldValidateUnauthenticatedCalls || userPrincipal != NobodyPrincipal.NOBODY_PRINCIPAL) {
            SecurityAssociation.pushSubjectContext(subject, userPrincipal, passwd != null ? passwd.toCharArray() : null);
        } else {
            SecurityAssociation.pushSubjectContext(null, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContext msgContext) throws AxisFault {
        if (!this.isInitialised) {
            JBossAuthenticationHandler jBossAuthenticationHandler = this;
            synchronized (jBossAuthenticationHandler) {
                if (!this.isInitialised) {
                    this.initialise();
                }
            }
        }
        if (this.authMgr == null) {
            throw new AxisFault("No security domain associated.");
        }
        String userID = msgContext.getUsername();
        Principal userPrincipal = this.getPrincipal(userID);
        String passwd = msgContext.getPassword();
        Subject subject = this.validate(userPrincipal, passwd);
        this.associate(userPrincipal, passwd, subject);
        msgContext.setProperty("authenticatedUser", (Object)subject);
    }
}

