/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.metadata;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcaster;
import org.jboss.mx.metadata.AbstractBuilder;

public class StandardMetaData
extends AbstractBuilder {
    private Object mbeanInstance = null;
    private Class mbeanClass = null;
    private Class mbeanInterface = null;

    public static Class findStandardInterface(Class mbeanClass) {
        Class stdInterface = null;
        for (Class concrete = mbeanClass; null != concrete; concrete = concrete.getSuperclass()) {
            stdInterface = StandardMetaData.findStandardInterface(concrete, concrete.getInterfaces());
            if (null == stdInterface) continue;
            return stdInterface;
        }
        return null;
    }

    public static Class findStandardInterface(Class concrete, Class[] interfaces) {
        String stdName = concrete.getName() + "MBean";
        Class retval = null;
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].getName().equals(stdName)) continue;
            retval = interfaces[i];
            break;
        }
        return retval;
    }

    public StandardMetaData(Object mbeanInstance) {
        this(mbeanInstance.getClass());
        this.mbeanInstance = mbeanInstance;
    }

    public StandardMetaData(Class mbeanClass) {
        this.mbeanClass = mbeanClass;
        this.mbeanInterface = StandardMetaData.findStandardInterface(mbeanClass);
    }

    public StandardMetaData(Object mbeanInstance, Class mbeanInterface) {
        this.mbeanInstance = mbeanInstance;
        this.mbeanClass = mbeanInstance.getClass();
        this.mbeanInterface = mbeanInterface;
        if (this.mbeanInterface == null) {
            this.mbeanInterface = StandardMetaData.findStandardInterface(this.mbeanClass);
        }
    }

    public Class getMBeanInterface() {
        return this.mbeanInterface;
    }

    public MBeanInfo build() throws NotCompliantMBeanException {
        try {
            String attrName;
            MBeanFeatureInfo info;
            if (this.mbeanInterface == null) {
                throw new NotCompliantMBeanException("The mbean does not implement a management interface");
            }
            if (this.mbeanInstance != null && !this.mbeanInterface.isInstance(this.mbeanInstance)) {
                throw new NotCompliantMBeanException("The mbean does not implement its management interface " + this.mbeanInterface.getName());
            }
            Constructor<?>[] constructors = this.mbeanClass.getConstructors();
            MBeanConstructorInfo[] constructorInfo = new MBeanConstructorInfo[constructors.length];
            for (int i = 0; i < constructors.length; ++i) {
                constructorInfo[i] = new MBeanConstructorInfo("MBean Constructor.", constructors[i]);
            }
            Method[] methods = this.mbeanInterface.getMethods();
            HashMap<String, Method> getters = new HashMap<String, Method>();
            HashMap<String, Method> setters = new HashMap<String, Method>();
            HashMap<String, MBeanAttributeInfo> operInfo = new HashMap<String, MBeanAttributeInfo>();
            ArrayList<MBeanAttributeInfo> attrInfo = new ArrayList<MBeanAttributeInfo>();
            for (int i = 0; i < methods.length; ++i) {
                Method getter;
                String key;
                String methodName = methods[i].getName();
                Class<?>[] signature = methods[i].getParameterTypes();
                Class<?> returnType = methods[i].getReturnType();
                if (methodName.startsWith("set") && methodName.length() > 3 && signature.length == 1 && returnType == Void.TYPE) {
                    key = methodName.substring(3, methodName.length());
                    Method setter = (Method)setters.get(key);
                    if (setter != null && !setter.getParameterTypes()[0].equals(signature[0])) {
                        throw new IntrospectionException("overloaded type for attribute set: " + key);
                    }
                    setters.put(key, methods[i]);
                    continue;
                }
                if (methodName.startsWith("get") && methodName.length() > 3 && signature.length == 0 && returnType != Void.TYPE) {
                    key = methodName.substring(3, methodName.length());
                    getter = (Method)getters.get(key);
                    if (getter != null && getter.getName().startsWith("is")) {
                        throw new IntrospectionException("mixed use of get/is for attribute " + key);
                    }
                    getters.put(key, methods[i]);
                    continue;
                }
                if (methodName.startsWith("is") && methodName.length() > 2 && signature.length == 0 && this.isBooleanReturn(returnType)) {
                    key = methodName.substring(2, methodName.length());
                    getter = (Method)getters.get(key);
                    if (getter != null && getter.getName().startsWith("get")) {
                        throw new IntrospectionException("mixed use of get/is for attribute " + key);
                    }
                    getters.put(key, methods[i]);
                    continue;
                }
                info = new MBeanOperationInfo("MBean Operation.", methods[i]);
                operInfo.put(this.getSignatureString(methods[i]), (MBeanAttributeInfo)info);
            }
            Object[] keys = getters.keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                attrName = (String)keys[i];
                Method getter = (Method)getters.remove(attrName);
                Method setter = (Method)setters.remove(attrName);
                MBeanAttributeInfo info2 = new MBeanAttributeInfo(attrName, "MBean Attribute.", getter, setter);
                attrInfo.add(info2);
            }
            Iterator it = setters.keySet().iterator();
            while (it.hasNext()) {
                attrName = (String)it.next();
                Method setter = (Method)setters.get(attrName);
                info = new MBeanAttributeInfo(attrName, "MBean Attribute.", null, setter);
                attrInfo.add((MBeanAttributeInfo)info);
            }
            MBeanAttributeInfo[] attributeInfo = attrInfo.toArray(new MBeanAttributeInfo[0]);
            MBeanOperationInfo[] operationInfo = operInfo.values().toArray(new MBeanOperationInfo[0]);
            MBeanNotificationInfo[] notifications = null;
            notifications = this.mbeanInstance instanceof NotificationBroadcaster ? ((NotificationBroadcaster)this.mbeanInstance).getNotificationInfo() : new MBeanNotificationInfo[]{};
            return new MBeanInfo(this.mbeanClass.getName(), "Management Bean.", attributeInfo, constructorInfo, operationInfo, notifications);
        }
        catch (IntrospectionException e) {
            throw new NotCompliantMBeanException(e.getMessage());
        }
    }

    private boolean isBooleanReturn(Class returnType) {
        return returnType == Boolean.TYPE;
    }

    protected String getSignatureString(Method method) {
        String name = method.getName();
        Class<?>[] signature = method.getParameterTypes();
        StringBuffer buffer = new StringBuffer(512);
        buffer.append(name);
        buffer.append("(");
        if (signature != null) {
            for (int i = 0; i < signature.length; ++i) {
                buffer.append(signature[i].getName());
                if (i >= signature.length - 1) continue;
                buffer.append(",");
            }
        }
        buffer.append(")");
        return buffer.toString();
    }
}

