/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
import java.net.URL;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.ClassLoadingTask;
import org.jboss.mx.loading.ClassToStringAction;
import org.jboss.mx.loading.LoadMgr3;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.UnifiedClassLoader;
import org.jboss.mx.loading.UnifiedClassLoader3MBean;
import org.jboss.mx.loading.UnifiedLoaderRepository3;

public class UnifiedClassLoader3
extends UnifiedClassLoader
implements UnifiedClassLoader3MBean {
    private static final Logger log = Logger.getLogger(class$org$jboss$mx$loading$UnifiedClassLoader3 == null ? (class$org$jboss$mx$loading$UnifiedClassLoader3 = UnifiedClassLoader3.class$("org.jboss.mx.loading.UnifiedClassLoader3")) : class$org$jboss$mx$loading$UnifiedClassLoader3);
    protected ReentrantLock loadLock = new ReentrantLock();
    private int loadClassDepth;
    static /* synthetic */ Class class$org$jboss$mx$loading$UnifiedClassLoader3;

    public UnifiedClassLoader3(URL url) {
        this(url, (URL)null);
    }

    public UnifiedClassLoader3(URL url, URL origURL) {
        super(url, origURL);
    }

    public UnifiedClassLoader3(URL url, URL origURL, LoaderRepository repository) {
        this(url, origURL);
        this.setRepository(repository);
    }

    public UnifiedClassLoader3(URL url, URL origURL, ClassLoader parent, LoaderRepository repository) {
        super(url, origURL, parent);
        this.setRepository(repository);
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer(super.toString());
        tmp.setCharAt(tmp.length() - 1, ',');
        tmp.append("addedOrder=");
        tmp.append(this.getAddedOrder());
        tmp.append('}');
        return tmp.toString();
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("loadClass, name=" + name + ", resolve=" + resolve + ", loadClassDepth=" + this.loadClassDepth);
        }
        Class clazz = null;
        if (this.repository != null && (clazz = this.repository.getCachedClass(name)) != null && trace) {
            StringBuffer buffer = new StringBuffer("Loaded class from cache, ");
            ClassToStringAction.toString(clazz, buffer);
            log.trace(buffer.toString());
        }
        if (clazz == null) {
            clazz = this.loadClassImpl(name, resolve);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Class loadClassImpl(String name, boolean resolve) throws ClassNotFoundException {
        ClassLoadingTask task;
        block18: {
            ++this.loadClassDepth;
            boolean trace = log.isTraceEnabled();
            if (trace) {
                log.trace("loadClassImpl, name=" + name + ", resolve=" + resolve);
            }
            if (this.repository == null) {
                String msg = "Invalid use of destroyed classloader, UCL destroyed at:";
                throw new ClassNotFoundException(msg, this.unregisterTrace);
            }
            boolean acquired = this.attempt(1L);
            while (!acquired) {
                try {
                    if (trace) {
                        log.trace("Waiting for loadClass lock");
                    }
                    this.wait();
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                acquired = this.attempt(1L);
            }
            task = null;
            try {
                UnifiedLoaderRepository3 ulr3;
                Thread t = Thread.currentThread();
                if (this.loadLock.holds() == 1L) {
                    LoadMgr3.registerLoaderThread(this, t);
                }
                if (!LoadMgr3.beginLoadTask(task = new ClassLoadingTask(name, this, t), ulr3 = (UnifiedLoaderRepository3)this.repository)) {
                    while (task.threadTaskCount != 0) {
                        try {
                            LoadMgr3.nextTask(t, task, ulr3);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                }
                Object var10_11 = null;
                if (this.loadLock.holds() != 1L) break block18;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (this.loadLock.holds() == 1L) {
                    LoadMgr3.endLoadTask(task);
                }
                this.release();
                this.notifyAll();
                --this.loadClassDepth;
                throw throwable;
            }
            LoadMgr3.endLoadTask(task);
        }
        this.release();
        this.notifyAll();
        --this.loadClassDepth;
        {
        }
        if (task.loadedClass == null) {
            if (task.loadException instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)task.loadException;
            }
            if (task.loadException != null) {
                if (log.isTraceEnabled()) {
                    log.trace("Unexpected error during load of:" + name, task.loadException);
                }
                String msg = "Unexpected error during load of: " + name + ", msg=" + task.loadException.getMessage();
                throw new ClassNotFoundException(msg);
            }
            throw new IllegalStateException("ClassLoadingTask.loadedTask is null, name: " + name);
        }
        return task.loadedClass;
    }

    public URL getResource(String name) {
        URL u = null;
        if (this.repository != null) {
            u = this.repository.getResource(name, this);
        }
        return u;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean attempt(long waitMS) {
        boolean acquired = false;
        boolean trace = log.isTraceEnabled();
        boolean threadWasInterrupted = Thread.interrupted();
        try {
            acquired = this.loadLock.attempt(waitMS);
        }
        catch (InterruptedException e) {
        }
        finally {
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
        if (trace) {
            log.trace("attempt(" + this.loadLock.holds() + ") was: " + acquired + " for :" + this);
        }
        return acquired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acquire() {
        boolean threadWasInterrupted = Thread.interrupted();
        try {
            this.loadLock.acquire();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("acquired(" + this.loadLock.holds() + ") for :" + this);
        }
    }

    protected void release() {
        if (log.isTraceEnabled()) {
            log.trace("release(" + this.loadLock.holds() + ") for :" + this);
        }
        this.loadLock.release();
        if (log.isTraceEnabled()) {
            log.trace("released, holds: " + this.loadLock.holds());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

