/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.UnifiedClassLoaderMBean;
import org.jboss.util.loading.Translatable;
import org.jboss.util.loading.Translator;

public class UnifiedClassLoader
extends URLClassLoader
implements UnifiedClassLoaderMBean,
Translatable {
    private static final Logger log = Logger.getLogger(class$org$jboss$mx$loading$UnifiedClassLoader == null ? (class$org$jboss$mx$loading$UnifiedClassLoader = UnifiedClassLoader.class$("org.jboss.mx.loading.UnifiedClassLoader")) : class$org$jboss$mx$loading$UnifiedClassLoader);
    private static final URL[] EMPTY_URL_ARRAY = new URL[0];
    protected LoaderRepository repository;
    protected Exception unregisterTrace;
    protected URL url;
    protected URL origURL;
    private int addedOrder;
    private Set classBlacklist;
    private Set resourceBlackList;
    private ConcurrentReaderHashMap resourceCache;
    static /* synthetic */ Class class$org$jboss$mx$loading$UnifiedClassLoader;

    public UnifiedClassLoader(URL url) {
        this(url, (URL)null);
    }

    public UnifiedClassLoader(URL url, URL origURL) {
        this(url, origURL, (class$org$jboss$mx$loading$UnifiedClassLoader == null ? (class$org$jboss$mx$loading$UnifiedClassLoader = UnifiedClassLoader.class$("org.jboss.mx.loading.UnifiedClassLoader")) : class$org$jboss$mx$loading$UnifiedClassLoader).getClassLoader());
    }

    public UnifiedClassLoader(URL url, URL origURL, ClassLoader parent) {
        URL[] uRLArray;
        if (url == null) {
            uRLArray = new URL[]{};
        } else {
            URL[] uRLArray2 = new URL[1];
            uRLArray = uRLArray2;
            uRLArray2[0] = url;
        }
        super(uRLArray, parent);
        this.repository = null;
        this.url = null;
        this.origURL = null;
        this.classBlacklist = Collections.synchronizedSet(new HashSet());
        this.resourceBlackList = Collections.synchronizedSet(new HashSet());
        this.resourceCache = new ConcurrentReaderHashMap();
        log.debug("New jmx UCL with url " + url);
        this.url = url;
        this.origURL = origURL;
    }

    public UnifiedClassLoader(URL url, LoaderRepository repository) {
        this(url, null, repository);
    }

    public UnifiedClassLoader(URL url, URL origURL, LoaderRepository repository) {
        this(url, origURL);
        this.setRepository(repository);
        repository.addClassLoader(this);
    }

    public UnifiedClassLoader(URL url, MBeanServer server, ObjectName repositoryName) throws Exception {
        this(url, null, server, repositoryName);
    }

    public UnifiedClassLoader(URL url, URL origURL, MBeanServer server, ObjectName repositoryName) throws Exception {
        this(url, origURL);
        LoaderRepository rep = (LoaderRepository)server.invoke(repositoryName, "registerClassLoader", new Object[]{this}, new String[]{this.getClass().getName()});
        this.setRepository(rep);
    }

    public int getAddedOrder() {
        return this.addedOrder;
    }

    public void setAddedOrder(int addedOrder) {
        this.addedOrder = addedOrder;
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        String name = "jmx.loading:UCL=" + Integer.toHexString(super.hashCode());
        return new ObjectName(name);
    }

    public void unregister() {
        log.debug("Unregistering ucl=" + this);
        if (this.repository != null) {
            this.repository.removeClassLoader(this);
        }
        this.resourceBlackList.clear();
        this.classBlacklist.clear();
        this.resourceCache.clear();
        this.origURL = null;
        this.url = null;
        this.repository = null;
        this.unregisterTrace = new Exception();
    }

    public void addURL(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (this.repository.addClassLoaderURL(this, url)) {
            log.debug("Added url: " + url + ", to ucl: " + this);
            String query = url.getQuery();
            if (query != null) {
                String ext = url.toExternalForm();
                String ext2 = ext.substring(0, ext.length() - query.length() - 1);
                try {
                    url = new URL(ext2);
                }
                catch (MalformedURLException e) {
                    log.warn("Failed to strip query from: " + url, e);
                }
            }
            super.addURL(url);
            this.clearBlacklists();
        } else if (log.isTraceEnabled()) {
            log.trace("Ignoring duplicate url: " + url + ", for ucl: " + this);
        }
    }

    public void clearBlacklists() {
        this.resourceBlackList.clear();
        this.classBlacklist.clear();
    }

    public LoaderRepository getLoaderRepository() {
        return this.repository;
    }

    public void setRepository(LoaderRepository repository) {
        log.debug("setRepository, r=" + repository + ", ucl=" + this);
        this.repository = repository;
    }

    public Class loadClassLocally(String name, boolean resolve) throws ClassNotFoundException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("loadClassLocally, name=" + name);
        }
        if (this.classBlacklist.contains(name)) {
            if (trace) {
                log.trace("Class in blacklist, name=" + name);
            }
            throw new ClassNotFoundException("Class Not Found(blacklist): " + name);
        }
        Class<?> clazz = null;
        try {
            clazz = super.loadClass(name, resolve);
            return clazz;
        }
        catch (ClassNotFoundException cnfe) {
            this.classBlacklist.add(name);
            if (name.charAt(0) == '[') {
                clazz = Class.forName(name, true, this);
                this.classBlacklist.remove(name);
                return clazz;
            }
            if (trace) {
                log.trace("CFNE: Adding to blacklist: " + name);
            }
            throw cnfe;
        }
    }

    public URL getResourceLocally(String name) {
        URL resURL = (URL)this.resourceCache.get(name);
        if (resURL != null) {
            return resURL;
        }
        if (this.resourceBlackList.contains(name)) {
            return null;
        }
        resURL = super.getResource(name);
        if (log.isTraceEnabled()) {
            log.trace("getResourceLocally(" + this + "), name=" + name + ", resURL:" + resURL);
        }
        if (resURL == null) {
            this.resourceBlackList.add(name);
        } else {
            this.resourceCache.put(name, resURL);
        }
        return resURL;
    }

    public URL getURL() {
        return this.url;
    }

    public URL getOrigURL() {
        return this.origURL;
    }

    public URL[] getClasspath() {
        return super.getURLs();
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c = this.repository.loadClass(name, resolve, this);
        return c;
    }

    public URL getResource(String name) {
        URL res = this.repository.getResource(name, this);
        return res;
    }

    public Enumeration findResources(String name) throws IOException {
        Vector resURLs = new Vector();
        this.repository.getResources(name, this, resURLs);
        return resURLs.elements();
    }

    public Enumeration findResourcesLocally(String name) throws IOException {
        Enumeration<URL> resURLs = super.findResources(name);
        return resURLs;
    }

    public final int hashCode() {
        int hash = super.hashCode();
        return hash;
    }

    public final boolean equals(Object other) {
        boolean equals = super.equals(other);
        return equals;
    }

    public URL[] getAllURLs() {
        return this.repository.getURLs();
    }

    public URL[] getURLs() {
        return EMPTY_URL_ARRAY;
    }

    public Package getPackage(String name) {
        return super.getPackage(name);
    }

    public Package[] getPackages() {
        return super.getPackages();
    }

    public String toString() {
        return super.toString() + "{ url=" + this.getURL() + " }";
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("findClass, name=" + name);
        }
        if (this.classBlacklist.contains(name)) {
            if (trace) {
                log.trace("Class in blacklist, name=" + name);
            }
            throw new ClassNotFoundException("Class Not Found(blacklist): " + name);
        }
        Translator translator = this.repository.getTranslator();
        if (translator != null) {
            try {
                byte[] rawcode = this.loadByteCode(name);
                ProtectionDomain pd = this.getProtectionDomain();
                byte[] bytecode = translator.transform(this, name, null, pd, rawcode);
                if (bytecode == null) {
                    bytecode = rawcode;
                }
                this.definePackage(name);
                return this.defineClass(name, bytecode, 0, bytecode.length, pd);
            }
            catch (ClassNotFoundException e) {
                throw e;
            }
            catch (Throwable ex) {
                throw new ClassNotFoundException(name, ex);
            }
        }
        Class<?> clazz = null;
        try {
            clazz = super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            if (trace) {
                log.trace("CFNE: Adding to blacklist: " + name);
            }
            this.classBlacklist.add(name);
            throw e;
        }
        return clazz;
    }

    protected void definePackage(String className) {
        int i = className.lastIndexOf(46);
        if (i == -1) {
            return;
        }
        try {
            this.definePackage(className.substring(0, i), null, null, null, null, null, null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected PermissionCollection getPermissions(CodeSource cs) {
        CodeSource permCS = cs;
        if (this.origURL != null) {
            permCS = new CodeSource(this.origURL, cs.getCertificates());
        }
        Policy policy = Policy.getPolicy();
        PermissionCollection perms = super.getPermissions(permCS);
        PermissionCollection perms2 = super.getPermissions(cs);
        PermissionCollection perms3 = policy.getPermissions(permCS);
        Enumeration<Permission> iter = perms2.elements();
        while (iter.hasMoreElements()) {
            perms.add(iter.nextElement());
        }
        iter = perms3.elements();
        while (iter.hasMoreElements()) {
            perms.add(iter.nextElement());
        }
        if (log.isTraceEnabled()) {
            log.trace("getPermissions, url=" + this.url + ", origURL=" + this.origURL + " -> " + perms);
        }
        return perms;
    }

    protected ProtectionDomain getProtectionDomain() {
        CodeSource cs = new CodeSource(this.origURL != null ? this.origURL : this.url, (Certificate[])null);
        PermissionCollection permissions = Policy.getPolicy().getPermissions(cs);
        if (log.isTraceEnabled()) {
            log.trace("getProtectionDomain, url=" + this.url + ", origURL=" + this.origURL + " codeSource=" + cs + " permissions=" + permissions);
        }
        return new ProtectionDomain(cs, permissions);
    }

    protected ProtectionDomain getProtectionDomain(URL codesourceUrl) {
        CodeSource cs = new CodeSource(codesourceUrl, (Certificate[])null);
        PermissionCollection permissions = Policy.getPolicy().getPermissions(cs);
        if (log.isTraceEnabled()) {
            log.trace("getProtectionDomain, url=" + this.url + ", origURL=" + this.origURL + " codeSource=" + cs + " permissions=" + permissions);
        }
        return new ProtectionDomain(cs, permissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] loadByteCode(String classname) throws ClassNotFoundException, IOException {
        byte[] bytecode = null;
        String classRsrcName = classname.replace('.', '/') + ".class";
        URL classURL = this.getResourceLocally(classRsrcName);
        if (classURL == null) {
            String msg = "Failed to find: " + classname + " as resource: " + classRsrcName;
            throw new ClassNotFoundException(msg);
        }
        InputStream is = null;
        try {
            is = classURL.openStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] tmp = new byte[1024];
            int read = 0;
            while ((read = is.read(tmp)) > 0) {
                baos.write(tmp, 0, read);
            }
            bytecode = baos.toByteArray();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return bytecode;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

