/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class MBeanElement {
    public static final String MLET_DELEGATE_TO_CLR = "delegateToCLR";
    private Map properties = new HashMap(2);
    private String code = null;
    private String object = null;
    private String name = null;
    private String codebase = null;
    private ArrayList archives = new ArrayList();
    private ArrayList versions = new ArrayList();
    private ArrayList argTypes = new ArrayList();
    private ArrayList argValues = new ArrayList();

    public String getCode() {
        return this.code;
    }

    public String getObject() {
        return this.object;
    }

    public String getName() {
        return this.name;
    }

    public List getArchives() {
        return this.archives;
    }

    public List getVersions() {
        return this.versions;
    }

    public String getCodebase() {
        return this.codebase;
    }

    public void setCode(String code) {
        this.code = this.trim(code);
    }

    public void setObject(String object) {
        this.object = this.trim(object);
    }

    public void setName(String name) {
        this.name = this.trim(name);
    }

    public void setCodebase(String url) {
        this.codebase = this.trim(url);
    }

    public void setArchive(String archive) {
        archive = this.trim(archive);
        StringTokenizer tokenizer = new StringTokenizer(archive, " ,");
        while (tokenizer.hasMoreTokens()) {
            this.archives.add(tokenizer.nextToken());
        }
    }

    public void setVersion(String version) {
        version = this.trim(version);
        StringTokenizer tokenizer = new StringTokenizer(version, " ,");
        while (tokenizer.hasMoreTokens()) {
            this.versions.add(tokenizer.nextToken());
        }
    }

    public void addArg(String type, String value) {
        this.argTypes.add(this.trim(type));
        this.argValues.add(this.trim(value));
    }

    public String[] getConstructorTypes() {
        return this.argTypes.toArray(new String[0]);
    }

    public String[] getConstructorValues() {
        return this.argValues.toArray(new String[0]);
    }

    private String trim(String str) {
        if (str == null) {
            return str;
        }
        if (str.startsWith("=")) {
            str = str.substring(1, str.length());
        }
        if (str.startsWith("\"") && str.endsWith("\"")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public void setProperty(String key, Object value) {
        if (key == null || key.equals("")) {
            throw new IllegalArgumentException("null or empty string keys not allowed");
        }
        if (value == null) {
            throw new IllegalArgumentException("null values not allowed");
        }
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }
}

