/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSubscriber;
import javax.jms.TransactionInProgressException;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.Connection;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.MessagePool;
import org.jboss.mq.SpyBytesMessage;
import org.jboss.mq.SpyConnection;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMapMessage;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyMessageConsumer;
import org.jboss.mq.SpyMessageProducer;
import org.jboss.mq.SpyObjectMessage;
import org.jboss.mq.SpyQueueBrowser;
import org.jboss.mq.SpyQueueReceiver;
import org.jboss.mq.SpyQueueSender;
import org.jboss.mq.SpyQueueSession;
import org.jboss.mq.SpyStreamMessage;
import org.jboss.mq.SpyTextMessage;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.SpyTopicPublisher;
import org.jboss.mq.SpyTopicSession;
import org.jboss.mq.SpyTopicSubscriber;
import org.jboss.mq.SpyXAResource;
import org.jboss.mq.SpyXAResourceManager;
import org.jboss.util.NullArgumentException;

public class SpySession
implements Session,
XASession {
    static Logger log = Logger.getLogger(class$org$jboss$mq$SpySession == null ? (class$org$jboss$mq$SpySession = SpySession.class$("org.jboss.mq.SpySession")) : class$org$jboss$mq$SpySession);
    static boolean trace = log.isTraceEnabled();
    public Connection connection;
    public boolean running;
    protected boolean transacted;
    protected int acknowledgeMode;
    protected HashSet consumers;
    protected HashSet producers;
    protected Object deliveryLock = new Object();
    protected boolean inDelivery = false;
    SpyMessageConsumer sessionConsumer;
    SynchronizedBoolean closed = new SynchronizedBoolean(false);
    Object runLock = new Object();
    private Object currentTransactionId;
    SpyXAResource spyXAResource;
    LinkedList messages = new LinkedList();
    ArrayList unacknowledgedMessages = new ArrayList();
    static /* synthetic */ Class class$org$jboss$mq$SpySession;

    SpySession(Connection conn, boolean trans, int acknowledge, boolean xaSession) {
        trace = log.isTraceEnabled();
        this.connection = conn;
        this.transacted = trans;
        this.acknowledgeMode = acknowledge;
        if (xaSession) {
            this.spyXAResource = new SpyXAResource(this);
        }
        this.running = true;
        this.consumers = new HashSet();
        this.producers = new HashSet();
        if (this.spyXAResource == null && this.transacted) {
            this.currentTransactionId = this.connection.spyXAResourceManager.startTx();
        }
        if (trace) {
            log.trace("New session " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAcknowledge(Message message, AcknowledgementRequest ack) throws JMSException {
        this.checkClosed();
        if (ack.isAck()) {
            ArrayList arrayList = this.unacknowledgedMessages;
            synchronized (arrayList) {
                if (trace) {
                    log.trace("Acknowledging message " + ack);
                }
                this.connection.send(((SpyMessage)message).getAcknowledgementRequest(true));
                this.unacknowledgedMessages.remove(message);
                Iterator i = this.unacknowledgedMessages.iterator();
                while (i.hasNext()) {
                    Message mess = (Message)i.next();
                    i.remove();
                    this.connection.send(((SpyMessage)mess).getAcknowledgementRequest(true));
                }
            }
        } else {
            if (trace) {
                log.trace("Nacking message " + message.getJMSMessageID());
            }
            this.unacknowledgedMessages.remove(message);
            this.connection.send(ack);
        }
    }

    public SpyXAResourceManager getXAResourceManager() {
        return this.connection.spyXAResourceManager;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.checkClosed();
        if (trace) {
            log.trace("Set message listener " + listener + " " + this);
        }
        this.sessionConsumer = new SpyMessageConsumer(this, true);
        this.sessionConsumer.setMessageListener(listener);
    }

    public boolean getTransacted() throws JMSException {
        this.checkClosed();
        return this.transacted;
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        if (this.sessionConsumer == null) {
            return null;
        }
        return this.sessionConsumer.getMessageListener();
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.checkClosed();
        SpyBytesMessage message = MessagePool.getBytesMessage();
        message.header.producerClientId = this.connection.getClientID();
        return message;
    }

    public MapMessage createMapMessage() throws JMSException {
        this.checkClosed();
        SpyMapMessage message = MessagePool.getMapMessage();
        message.header.producerClientId = this.connection.getClientID();
        return message;
    }

    public Message createMessage() throws JMSException {
        this.checkClosed();
        SpyMessage message = MessagePool.getMessage();
        message.header.producerClientId = this.connection.getClientID();
        return message;
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkClosed();
        SpyObjectMessage message = MessagePool.getObjectMessage();
        message.header.producerClientId = this.connection.getClientID();
        return message;
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        this.checkClosed();
        SpyObjectMessage message = MessagePool.getObjectMessage();
        message.setObject(object);
        message.header.producerClientId = this.connection.getClientID();
        return message;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.checkClosed();
        SpyStreamMessage message = MessagePool.getStreamMessage();
        message.header.producerClientId = this.connection.getClientID();
        return message;
    }

    public TextMessage createTextMessage() throws JMSException {
        this.checkClosed();
        SpyTextMessage message = MessagePool.getTextMessage();
        message.header.producerClientId = this.connection.getClientID();
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            if (trace) {
                log.trace("Run messages=" + this.messages.size() + " " + this);
            }
            while (this.messages.size() > 0) {
                SpyMessage message = (SpyMessage)this.messages.removeFirst();
                try {
                    if (this.sessionConsumer == null) {
                        log.warn("Session has no message listener set, cannot process message. " + this);
                        this.connection.send(message.getAcknowledgementRequest(false));
                        continue;
                    }
                    this.sessionConsumer.addMessage(message);
                }
                catch (Throwable ignore) {
                    if (!trace) continue;
                    log.trace("Ignored error from session consumer", ignore);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        JMSException exception;
        block30: {
            Object messageConsumer;
            Iterator i;
            if (this.closed.set(true)) {
                return;
            }
            if (trace) {
                log.trace("Session closing " + this);
            }
            exception = null;
            if (trace) {
                log.trace("Closing consumers " + this);
            }
            HashSet hashSet = this.consumers;
            synchronized (hashSet) {
                if (this.sessionConsumer != null) {
                    try {
                        this.sessionConsumer.close();
                    }
                    catch (InvalidDestinationException ignored) {
                        log.warn(ignored.getMessage(), ignored);
                    }
                    catch (Throwable t) {
                        exception = SpyJMSException.getAsJMSException("Error closing session consumer", t);
                    }
                }
                i = new ArrayList(this.consumers).iterator();
            }
            while (i.hasNext()) {
                messageConsumer = (SpyMessageConsumer)i.next();
                try {
                    ((SpyMessageConsumer)messageConsumer).close();
                }
                catch (InvalidDestinationException ignored) {
                    log.warn(ignored.getMessage(), ignored);
                }
                catch (Throwable t) {
                    if (exception != null) continue;
                    exception = SpyJMSException.getAsJMSException("Error closing message consumer", t);
                }
            }
            messageConsumer = this.producers;
            synchronized (messageConsumer) {
                i = new ArrayList(this.producers).iterator();
            }
            while (i.hasNext()) {
                SpyMessageProducer messageProducer = (SpyMessageProducer)i.next();
                try {
                    messageProducer.close();
                }
                catch (InvalidDestinationException ignored) {
                    log.warn(ignored.getMessage(), ignored);
                }
                catch (Throwable t) {
                    if (exception != null) continue;
                    exception = SpyJMSException.getAsJMSException("Error closing message producer", t);
                }
            }
            if (trace) {
                log.trace("Close handling unacknowledged messages " + this);
            }
            try {
                if (this.spyXAResource == null) {
                    if (this.transacted) {
                        this.internalRollback();
                    } else {
                        i = this.unacknowledgedMessages.iterator();
                        while (i.hasNext()) {
                            SpyMessage message = (SpyMessage)i.next();
                            this.connection.send(message.getAcknowledgementRequest(false));
                            i.remove();
                        }
                    }
                }
            }
            catch (Throwable t) {
                if (exception != null) break block30;
                exception = SpyJMSException.getAsJMSException("Error nacking message", t);
            }
        }
        if (trace) {
            log.trace("Informing connection of close " + this);
        }
        this.connection.sessionClosing(this);
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void commit() throws JMSException {
        this.checkClosed();
        trace = log.isTraceEnabled();
        Object object = this.runLock;
        synchronized (object) {
            block19: {
                if (this.spyXAResource != null) {
                    throw new TransactionInProgressException("Should not be call from a XASession");
                }
                if (!this.transacted) {
                    throw new IllegalStateException("The session is not transacted");
                }
                if (trace) {
                    log.trace("Committing transaction " + this);
                }
                this.connection.spyXAResourceManager.endTx(this.currentTransactionId, true);
                this.connection.spyXAResourceManager.commit(this.currentTransactionId, true);
                Object var4_2 = null;
                this.unacknowledgedMessages.clear();
                try {
                    this.currentTransactionId = this.connection.spyXAResourceManager.startTx();
                    if (trace) {
                        log.trace("Current transaction id: " + this.currentTransactionId + " " + this);
                    }
                    break block19;
                }
                catch (Throwable ignore) {
                    if (trace) {
                        log.trace("Failed to start tx " + this, ignore);
                    }
                    break block19;
                }
                {
                    catch (Throwable t) {
                        SpyJMSException.rethrowAsJMSException("Could not commit", t);
                        Object var4_3 = null;
                        this.unacknowledgedMessages.clear();
                        try {
                            this.currentTransactionId = this.connection.spyXAResourceManager.startTx();
                            if (trace) {
                                log.trace("Current transaction id: " + this.currentTransactionId + " " + this);
                            }
                            break block19;
                        }
                        catch (Throwable ignore) {
                            if (trace) {
                                log.trace("Failed to start tx " + this, ignore);
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    block20: {
                        Object var4_4 = null;
                        this.unacknowledgedMessages.clear();
                        try {
                            this.currentTransactionId = this.connection.spyXAResourceManager.startTx();
                            if (trace) {
                                log.trace("Current transaction id: " + this.currentTransactionId + " " + this);
                            }
                        }
                        catch (Throwable ignore) {
                            if (!trace) break block20;
                            log.trace("Failed to start tx " + this, ignore);
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws JMSException {
        this.checkClosed();
        trace = log.isTraceEnabled();
        Object object = this.runLock;
        synchronized (object) {
            this.internalRollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() throws JMSException {
        this.checkClosed();
        boolean stopped = this.connection.modeStop;
        Object object = this.runLock;
        synchronized (object) {
            if (this.currentTransactionId != null) {
                throw new IllegalStateException("The session is transacted");
            }
            if (trace) {
                log.trace("Session recovery stopping delivery " + this);
            }
            try {
                this.connection.stop();
                this.running = false;
            }
            catch (Throwable t) {
                SpyJMSException.rethrowAsJMSException("Could not stop message delivery", t);
            }
            try {
                LinkedList t = this.messages;
                synchronized (t) {
                    Iterator i;
                    if (!stopped) {
                        if (trace) {
                            log.trace("Recovering: unacknowledged messages=" + this.unacknowledgedMessages + " " + this);
                        }
                        i = this.consumers.iterator();
                        while (i.hasNext()) {
                            SpyMessageConsumer consumer = (SpyMessageConsumer)i.next();
                            Iterator ii = this.unacknowledgedMessages.iterator();
                            while (ii.hasNext()) {
                                SpyMessage message = (SpyMessage)ii.next();
                                if (!consumer.getSubscription().accepts(message.header)) continue;
                                message.setJMSRedelivered(true);
                                consumer.messages.addLast(message);
                                ii.remove();
                                if (!trace) continue;
                                log.trace("Recovered: message=" + message + " consumer=" + consumer);
                            }
                        }
                    }
                    i = this.unacknowledgedMessages.iterator();
                    while (i.hasNext()) {
                        SpyMessage message = (SpyMessage)i.next();
                        this.connection.send(message.getAcknowledgementRequest(false));
                        i.remove();
                        if (!trace) continue;
                        log.trace("Recovered: nacked with no consumer message=" + message + " " + this);
                    }
                }
            }
            catch (Throwable t) {
                SpyJMSException.rethrowAsJMSException("Unable to recover session ", t);
            }
            if (!stopped) {
                if (trace) {
                    log.trace("Recovery restarting message delivery " + this);
                }
                try {
                    this.running = true;
                    this.connection.start();
                    Iterator i = this.consumers.iterator();
                    while (i.hasNext()) {
                        ((SpyMessageConsumer)i.next()).restartProcessing();
                    }
                }
                catch (Throwable t) {
                    SpyJMSException.rethrowAsJMSException("Could not resume message delivery", t);
                }
            }
        }
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        this.checkClosed();
        SpyTextMessage message = new SpyTextMessage();
        message.setText(string);
        message.header.producerClientId = this.connection.getClientID();
        return message;
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.acknowledgeMode;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, null, false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.createConsumer(destination, messageSelector, false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        if (destination instanceof Topic) {
            return this.createSubscriber((Topic)destination, messageSelector, noLocal);
        }
        return this.createReceiver((Queue)destination, messageSelector);
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (destination instanceof Topic) {
            return this.createPublisher((Topic)destination);
        }
        return this.createSender((Queue)destination);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, null);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        this.checkClosed();
        if (this instanceof SpyTopicSession) {
            throw new IllegalStateException("Not allowed for a TopicSession");
        }
        if (queue == null) {
            throw new InvalidDestinationException("Cannot browse a null queue.");
        }
        return new SpyQueueBrowser(this, queue, messageSelector);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return this.createReceiver(queue, null);
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        this.checkClosed();
        if (queue == null) {
            throw new InvalidDestinationException("Queue cannot be null.");
        }
        this.connection.checkTemporary(queue);
        SpyQueueReceiver receiver = new SpyQueueReceiver(this, queue, messageSelector);
        this.addConsumer(receiver);
        return receiver;
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        this.checkClosed();
        SpyQueueSender producer = new SpyQueueSender(this, queue);
        this.addProducer(producer);
        return producer;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name, null, false);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        this.checkClosed();
        if (this instanceof SpyQueueSession) {
            throw new IllegalStateException("Not allowed for a QueueSession");
        }
        if (topic == null) {
            throw new InvalidDestinationException("Topic cannot be null");
        }
        if (topic instanceof TemporaryTopic) {
            throw new InvalidDestinationException("Attempt to create a durable subscription for a temporary topic");
        }
        if (name == null || name.trim().length() == 0) {
            throw new JMSException("Null or empty subscription");
        }
        SpyTopic t = new SpyTopic((SpyTopic)topic, this.connection.getClientID(), name, messageSelector);
        SpyTopicSubscriber sub = new SpyTopicSubscriber(this, t, noLocal, messageSelector);
        this.addConsumer(sub);
        return sub;
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return this.createSubscriber(topic, null, false);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        this.checkClosed();
        if (topic == null) {
            throw new InvalidDestinationException("Topic cannot be null");
        }
        this.connection.checkTemporary(topic);
        SpyTopicSubscriber sub = new SpyTopicSubscriber(this, (SpyTopic)topic, noLocal, messageSelector);
        this.addConsumer(sub);
        return sub;
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        this.checkClosed();
        SpyTopicPublisher producer = new SpyTopicPublisher(this, topic);
        this.addProducer(producer);
        return producer;
    }

    public Queue createQueue(String queueName) throws JMSException {
        this.checkClosed();
        if (this instanceof SpyTopicSession) {
            throw new IllegalStateException("Not allowed for a TopicSession");
        }
        if (queueName == null) {
            throw new InvalidDestinationException("Queue name cannot be null.");
        }
        return ((SpyConnection)this.connection).createQueue(queueName);
    }

    public Topic createTopic(String topicName) throws JMSException {
        this.checkClosed();
        if (this instanceof SpyQueueSession) {
            throw new IllegalStateException("Not allowed for a QueueSession");
        }
        if (topicName == null) {
            throw new InvalidDestinationException("The topic name cannot be null");
        }
        return ((SpyConnection)this.connection).createTopic(topicName);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkClosed();
        if (this instanceof SpyTopicSession) {
            throw new IllegalStateException("Not allowed for a TopicSession");
        }
        return ((SpyConnection)this.connection).getTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkClosed();
        if (this instanceof SpyQueueSession) {
            throw new IllegalStateException("Not allowed for a QueueSession");
        }
        return ((SpyConnection)this.connection).getTemporaryTopic();
    }

    public void unsubscribe(String name) throws JMSException {
        this.checkClosed();
        if (this instanceof SpyQueueSession) {
            throw new IllegalStateException("Not allowed for a QueueSession");
        }
        DurableSubscriptionID id = new DurableSubscriptionID(this.connection.getClientID(), name, null);
        this.connection.unsubscribe(id);
    }

    public XAResource getXAResource() {
        return this.spyXAResource;
    }

    public Session getSession() throws JMSException {
        this.checkClosed();
        return this;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("SpySession@").append(System.identityHashCode(this));
        buffer.append('[');
        buffer.append("tx=").append(this.transacted);
        if (!this.transacted) {
            if (this.acknowledgeMode == 1) {
                buffer.append(" ack=").append("AUTO");
            } else if (this.acknowledgeMode == 2) {
                buffer.append(" ack=").append("CLIENT");
            } else if (this.acknowledgeMode == 3) {
                buffer.append(" ack=").append("DUPSOK");
            }
        }
        buffer.append(" txid=" + this.currentTransactionId);
        if (this.spyXAResource != null) {
            buffer.append(" XA");
        }
        if (this.running) {
            buffer.append(" RUNNING");
        }
        if (this.closed.get()) {
            buffer.append(" CLOSED");
        }
        buffer.append(" connection=").append(this.connection);
        buffer.append(']');
        return buffer.toString();
    }

    void setCurrentTransactionId(Object xid) {
        if (xid == null) {
            throw new NullArgumentException("xid");
        }
        if (trace) {
            log.trace("Setting current tx xid=" + xid + " previous: " + this.currentTransactionId + " " + this);
        }
        this.currentTransactionId = xid;
    }

    void unsetCurrentTransactionId(Object xid) {
        if (xid == null) {
            throw new NullArgumentException("xid");
        }
        if (trace) {
            log.trace("Unsetting current tx  xid=" + xid + " previous: " + this.currentTransactionId + " " + this);
        }
        if (xid.equals(this.currentTransactionId)) {
            this.currentTransactionId = null;
        }
    }

    Object getCurrentTransactionId() {
        return this.currentTransactionId;
    }

    String getNewMessageID() throws JMSException {
        this.checkClosed();
        return this.connection.getNewMessageID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMessage(SpyMessage message) {
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            if (trace) {
                log.trace("Add message msgid=" + message.header.jmsMessageID + " " + this);
            }
            this.messages.addLast(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUnacknowlegedMessage(SpyMessage message) {
        if (!this.transacted) {
            ArrayList arrayList = this.unacknowledgedMessages;
            synchronized (arrayList) {
                if (trace) {
                    log.trace("Add unacked message msgid=" + message.header.jmsMessageID + " " + this);
                }
                this.unacknowledgedMessages.add(message);
            }
        }
    }

    void sendMessage(SpyMessage m) throws JMSException {
        this.checkClosed();
        m.header.producerClientId = this.connection.getClientID();
        if (this.transacted) {
            if (trace) {
                log.trace("Adding message to transaction " + m.header.jmsMessageID + " " + this);
            }
            this.connection.spyXAResourceManager.addMessage(this.currentTransactionId, m.myClone());
        } else {
            if (trace) {
                log.trace("Sending message to server " + m.header.jmsMessageID + " " + this);
            }
            this.connection.sendToServer(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConsumer(SpyMessageConsumer who) throws JMSException {
        this.checkClosed();
        HashSet hashSet = this.consumers;
        synchronized (hashSet) {
            if (trace) {
                log.trace("Adding consumer " + who);
            }
            this.consumers.add(who);
        }
        try {
            this.connection.addConsumer(who);
        }
        catch (JMSSecurityException ex) {
            this.removeConsumerInternal(who);
            throw ex;
        }
        catch (Throwable t) {
            SpyJMSException.rethrowAsJMSException("Error adding consumer", t);
        }
    }

    void removeConsumer(SpyMessageConsumer who) throws JMSException {
        this.connection.removeConsumer(who);
        this.removeConsumerInternal(who);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addProducer(SpyMessageProducer who) throws JMSException {
        this.checkClosed();
        HashSet hashSet = this.producers;
        synchronized (hashSet) {
            if (trace) {
                log.trace("Adding producer " + who);
            }
            this.producers.add(who);
        }
    }

    void removeProducer(SpyMessageProducer who) throws JMSException {
        this.removeProducerInternal(who);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tryDeliveryLock() {
        Object object = this.deliveryLock;
        synchronized (object) {
            if (this.inDelivery) {
                try {
                    this.deliveryLock.wait();
                }
                catch (InterruptedException e) {
                    log.trace("Ignored interruption waiting for delivery lock");
                }
            }
            if (!this.inDelivery) {
                this.inDelivery = true;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseDeliveryLock() {
        Object object = this.deliveryLock;
        synchronized (object) {
            this.inDelivery = false;
            this.deliveryLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interruptDeliveryLockWaiters() {
        Object object = this.deliveryLock;
        synchronized (object) {
            this.deliveryLock.notifyAll();
        }
    }

    void asynchFailure(String message, Throwable t) {
        this.connection.asynchFailure(message, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void internalRollback() throws JMSException {
        Object object = this.runLock;
        synchronized (object) {
            block19: {
                if (this.spyXAResource != null) {
                    throw new TransactionInProgressException("Should not be call from a XASession");
                }
                if (!this.transacted) {
                    throw new IllegalStateException("The session is not transacted");
                }
                if (trace) {
                    log.trace("Rollback transaction " + this);
                }
                this.connection.spyXAResourceManager.endTx(this.currentTransactionId, true);
                this.connection.spyXAResourceManager.rollback(this.currentTransactionId);
                Object var4_2 = null;
                this.unacknowledgedMessages.clear();
                try {
                    this.currentTransactionId = this.connection.spyXAResourceManager.startTx();
                    if (trace) {
                        log.trace("Current transaction id: " + this.currentTransactionId + " " + this);
                    }
                    break block19;
                }
                catch (Throwable ignore) {
                    if (trace) {
                        log.trace("Failed to start tx " + this, ignore);
                    }
                    break block19;
                }
                {
                    catch (Throwable t) {
                        SpyJMSException.rethrowAsJMSException("Could not rollback", t);
                        Object var4_3 = null;
                        this.unacknowledgedMessages.clear();
                        try {
                            this.currentTransactionId = this.connection.spyXAResourceManager.startTx();
                            if (trace) {
                                log.trace("Current transaction id: " + this.currentTransactionId + " " + this);
                            }
                            break block19;
                        }
                        catch (Throwable ignore) {
                            if (trace) {
                                log.trace("Failed to start tx " + this, ignore);
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    block20: {
                        Object var4_4 = null;
                        this.unacknowledgedMessages.clear();
                        try {
                            this.currentTransactionId = this.connection.spyXAResourceManager.startTx();
                            if (trace) {
                                log.trace("Current transaction id: " + this.currentTransactionId + " " + this);
                            }
                        }
                        catch (Throwable ignore) {
                            if (!trace) break block20;
                            log.trace("Failed to start tx " + this, ignore);
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConsumerInternal(SpyMessageConsumer who) {
        HashSet hashSet = this.consumers;
        synchronized (hashSet) {
            if (trace) {
                log.trace("Remove consumer " + who);
            }
            this.consumers.remove(who);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProducerInternal(SpyMessageProducer who) {
        HashSet hashSet = this.producers;
        synchronized (hashSet) {
            if (trace) {
                log.trace("Remove producer " + who);
            }
            this.producers.remove(who);
        }
    }

    private void checkClosed() throws IllegalStateException {
        if (this.closed.get()) {
            throw new IllegalStateException("The session is closed");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

