/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.connector.rmi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.loading.ClassLoaderRepository;
import javax.naming.InitialContext;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
import org.jboss.jmx.connector.notification.ClientNotificationListener;
import org.jboss.jmx.connector.notification.JMSClientNotificationListener;
import org.jboss.jmx.connector.notification.PollingClientNotificationListener;
import org.jboss.jmx.connector.notification.RMIClientNotificationListener;
import org.jboss.jmx.connector.notification.SearchClientNotificationListener;
import org.jboss.jmx.connector.rmi.RMIConnectorImplMBean;
import org.jboss.logging.Logger;
import org.jboss.util.NestedRuntimeException;

public class RMIConnectorImpl
implements RMIConnectorImplMBean {
    protected Logger log = Logger.getLogger(this.getClass());
    protected RMIAdaptor mRemoteAdaptor;
    protected Object mServer = "";
    protected Vector mListeners = new Vector();
    protected int mEventType = 1;
    protected String[] mOptions = new String[0];
    protected Random mRandom = new Random();

    protected RMIConnectorImpl() {
    }

    public RMIConnectorImpl(RMIAdaptor pAdaptor) {
        this.mRemoteAdaptor = pAdaptor;
        this.mServer = "Dummy";
    }

    public RMIConnectorImpl(int pNotificationType, String[] pOptions, String pServerName) throws Exception {
        this.mEventType = pNotificationType;
        this.mOptions = pOptions == null ? new String[0] : pOptions;
        this.start(pServerName);
    }

    public Object instantiate(String className) throws ReflectionException, MBeanException {
        try {
            return this.mRemoteAdaptor.instantiate(className);
        }
        catch (RemoteException e) {
            throw new MBeanException(e);
        }
    }

    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        try {
            return this.mRemoteAdaptor.instantiate(className, loaderName);
        }
        catch (RemoteException e) {
            throw new MBeanException(e);
        }
    }

    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        try {
            return this.mRemoteAdaptor.instantiate(className, params, signature);
        }
        catch (RemoteException e) {
            throw new MBeanException(e);
        }
    }

    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        try {
            return this.mRemoteAdaptor.instantiate(className, loaderName, params, signature);
        }
        catch (RemoteException e) {
            throw new MBeanException(e);
        }
    }

    public ObjectInstance createMBean(String pClassName, ObjectName pName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            return this.mRemoteAdaptor.createMBean(pClassName, pName);
        }
        catch (RemoteException re) {
            throw new MBeanException(re);
        }
        catch (IOException e) {
            throw new MBeanException(e);
        }
    }

    public ObjectInstance createMBean(String pClassName, ObjectName pName, ObjectName pLoaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        try {
            return this.mRemoteAdaptor.createMBean(pClassName, pName, pLoaderName);
        }
        catch (RemoteException re) {
            throw new MBeanException(re);
        }
        catch (IOException e) {
            throw new MBeanException(e);
        }
    }

    public ObjectInstance createMBean(String pClassName, ObjectName pName, Object[] pParams, String[] pSignature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            return this.mRemoteAdaptor.createMBean(pClassName, pName, pParams, pSignature);
        }
        catch (RemoteException re) {
            throw new MBeanException(re);
        }
        catch (IOException e) {
            throw new MBeanException(e);
        }
    }

    public ObjectInstance createMBean(String pClassName, ObjectName pName, ObjectName pLoaderName, Object[] pParams, String[] pSignature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        try {
            return this.mRemoteAdaptor.createMBean(pClassName, pName, pLoaderName, pParams, pSignature);
        }
        catch (RemoteException re) {
            throw new MBeanException(re);
        }
        catch (IOException e) {
            throw new MBeanException(e);
        }
    }

    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        try {
            return this.mRemoteAdaptor.registerMBean(object, name);
        }
        catch (RemoteException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
        catch (IOException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
    }

    public void unregisterMBean(ObjectName pName) throws InstanceNotFoundException, MBeanRegistrationException {
        try {
            this.mRemoteAdaptor.unregisterMBean(pName);
        }
        catch (RemoteException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
        catch (IOException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
    }

    public ObjectInstance getObjectInstance(ObjectName pName) throws InstanceNotFoundException {
        try {
            return this.mRemoteAdaptor.getObjectInstance(pName);
        }
        catch (RemoteException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
        catch (IOException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
    }

    public Set queryMBeans(ObjectName pName, QueryExp pQuery) {
        try {
            return this.mRemoteAdaptor.queryMBeans(pName, pQuery);
        }
        catch (RemoteException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
        catch (IOException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
    }

    public Set queryNames(ObjectName pName, QueryExp pQuery) {
        try {
            return this.mRemoteAdaptor.queryNames(pName, pQuery);
        }
        catch (RemoteException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
        catch (IOException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
    }

    public boolean isRegistered(ObjectName pName) {
        try {
            return this.mRemoteAdaptor.isRegistered(pName);
        }
        catch (RemoteException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
        catch (IOException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
    }

    public boolean isInstanceOf(ObjectName pName, String pClassName) throws InstanceNotFoundException {
        try {
            return this.mRemoteAdaptor.isInstanceOf(pName, pClassName);
        }
        catch (RemoteException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
        catch (IOException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
    }

    public Integer getMBeanCount() {
        try {
            return this.mRemoteAdaptor.getMBeanCount();
        }
        catch (RemoteException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
        catch (IOException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
    }

    public Object getAttribute(ObjectName pName, String pAttribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        try {
            return this.mRemoteAdaptor.getAttribute(pName, pAttribute);
        }
        catch (RemoteException e) {
            throw new MBeanException(e);
        }
        catch (IOException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
    }

    public AttributeList getAttributes(ObjectName pName, String[] pAttributes) throws InstanceNotFoundException, ReflectionException {
        try {
            return this.mRemoteAdaptor.getAttributes(pName, pAttributes);
        }
        catch (RemoteException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
        catch (IOException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
    }

    public void setAttribute(ObjectName pName, Attribute pAttribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            this.mRemoteAdaptor.setAttribute(pName, pAttribute);
        }
        catch (RemoteException e) {
            throw new MBeanException(e);
        }
        catch (IOException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
    }

    public AttributeList setAttributes(ObjectName pName, AttributeList pAttributes) throws InstanceNotFoundException, ReflectionException {
        try {
            return this.mRemoteAdaptor.setAttributes(pName, pAttributes);
        }
        catch (RemoteException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
        catch (IOException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
    }

    public Object invoke(ObjectName pName, String pActionName, Object[] pParams, String[] pSignature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        try {
            return this.mRemoteAdaptor.invoke(pName, pActionName, pParams, pSignature);
        }
        catch (RemoteException e) {
            throw new MBeanException(e);
        }
        catch (IOException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
    }

    public String getDefaultDomain() {
        try {
            return this.mRemoteAdaptor.getDefaultDomain();
        }
        catch (RemoteException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
        catch (IOException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
    }

    public void addNotificationListener(ObjectName pName, ObjectName pListener, NotificationFilter pFilter, Object pHandback) throws InstanceNotFoundException {
        try {
            this.mRemoteAdaptor.addNotificationListener(pName, pListener, pFilter, pHandback);
        }
        catch (RemoteException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
        catch (IOException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
    }

    public void addNotificationListener(ObjectName pName, NotificationListener pListener, NotificationFilter pFilter, Object pHandback) throws InstanceNotFoundException {
        try {
            ClientNotificationListener lListener = null;
            switch (this.mEventType) {
                case 1: {
                    lListener = new RMIClientNotificationListener(pName, pListener, pHandback, pFilter, this);
                    break;
                }
                case 0: {
                    lListener = new JMSClientNotificationListener(pName, pListener, pHandback, pFilter, this.mOptions[0], (String)this.mServer, this);
                    break;
                }
                case 2: {
                    lListener = new PollingClientNotificationListener(pName, pListener, pHandback, pFilter, 5000, 2500, this);
                }
            }
            this.mListeners.addElement(lListener);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
    }

    public void removeNotificationListener(ObjectName pName, NotificationListener pListener) throws InstanceNotFoundException, ListenerNotFoundException {
        SearchClientNotificationListener lCheck = new SearchClientNotificationListener(pName, pListener);
        int i = this.mListeners.indexOf(lCheck);
        if (i >= 0) {
            ClientNotificationListener lListener = (ClientNotificationListener)this.mListeners.get(i);
            lListener.removeNotificationListener(this);
        }
    }

    public void removeNotificationListener(ObjectName pName, ObjectName pListener) throws InstanceNotFoundException, ListenerNotFoundException {
        try {
            this.mRemoteAdaptor.removeNotificationListener(pName, pListener);
        }
        catch (RemoteException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
        catch (IOException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName pName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        try {
            return this.mRemoteAdaptor.getMBeanInfo(pName);
        }
        catch (RemoteException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
        catch (IOException e) {
            throw new RuntimeMBeanException(new NestedRuntimeException(e));
        }
    }

    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        throw new UnsupportedOperationException();
    }

    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        throw new UnsupportedOperationException();
    }

    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
        throw new UnsupportedOperationException();
    }

    public String[] getDomains() {
        throw new UnsupportedOperationException();
    }

    public void removeNotificationListener(ObjectName target, ObjectName listener, NotificationFilter filter, Object handback) {
        throw new UnsupportedOperationException();
    }

    public void removeNotificationListener(ObjectName target, NotificationListener listener, NotificationFilter filter, Object handback) {
        throw new UnsupportedOperationException();
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        throw new UnsupportedOperationException();
    }

    public ClassLoader getClassLoader(ObjectName name) {
        throw new UnsupportedOperationException();
    }

    public ClassLoader getClassLoaderFor(ObjectName name) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Object pServer) throws Exception {
        this.log.debug("Starting");
        if (pServer == null) {
            throw new IllegalArgumentException("Server cannot be null. To close the connection use stop()");
        }
        InitialContext ctx = new InitialContext();
        try {
            this.log.debug("Using Naming Context: " + ctx + ", environment: " + ctx.getEnvironment() + ", name in namespace: " + ctx.getNameInNamespace());
            this.mRemoteAdaptor = (RMIAdaptor)ctx.lookup("jmx:" + pServer + ":rmi");
            this.log.error("Using remote adaptor: " + this.mRemoteAdaptor);
            this.mServer = pServer;
            ctx.close();
        }
        finally {
            ctx.close();
        }
    }

    public void stop() {
        this.log.debug("Stopping");
        if (this.mRemoteAdaptor != null) {
            Iterator i = this.mListeners.iterator();
            while (i.hasNext()) {
                ClientNotificationListener lListener = (ClientNotificationListener)i.next();
                try {
                    lListener.removeNotificationListener(this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                i.remove();
            }
        }
        this.mRemoteAdaptor = null;
        this.mServer = "";
    }

    public boolean isAlive() {
        return this.mRemoteAdaptor != null;
    }

    public String getServerDescription() {
        return String.valueOf(this.mServer);
    }
}

