/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.connector.notification;

import java.util.Iterator;
import java.util.List;
import javax.management.JMException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.jmx.connector.RemoteMBeanServer;
import org.jboss.jmx.connector.notification.ClientNotificationListener;

public class PollingClientNotificationListener
extends ClientNotificationListener
implements Runnable {
    private RemoteMBeanServer mConnector;
    private int mSleepingPeriod = 2000;

    public PollingClientNotificationListener(ObjectName pSender, NotificationListener pClientListener, Object pHandback, NotificationFilter pFilter, int pSleepingPeriod, int pMaximumListSize, RemoteMBeanServer pConnector) throws JMException {
        super(pSender, pClientListener, pHandback);
        if (pSleepingPeriod > 0) {
            this.mSleepingPeriod = pSleepingPeriod;
        }
        this.mConnector = pConnector;
        this.createListener(pConnector, "org.jboss.jmx.connector.notification.PollingNotificationListener", new Object[]{new Integer(pMaximumListSize), new Integer(pMaximumListSize)}, new String[]{Integer.TYPE.getName(), Integer.TYPE.getName()});
        this.addNotificationListener(pConnector, pFilter);
        new Thread(this).start();
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    try {
                        List lNotifications = (List)this.mConnector.getAttribute(this.getRemoteListenerName(), "Notifications");
                        Iterator i = lNotifications.iterator();
                        while (i.hasNext()) {
                            Notification lNotification = (Notification)i.next();
                            this.mClientListener.handleNotification(lNotification, this.mHandback);
                        }
                    }
                    catch (Exception e) {
                        this.log.error("operation failed; continuing", e);
                    }
                    Thread.sleep(this.mSleepingPeriod);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

