/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.connector;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.jboss.jmx.connector.RemoteMBeanServer;
import org.jboss.jmx.connector.ejb.EJBConnector;
import org.jboss.jmx.connector.rmi.RMIConnectorImpl;
import org.jboss.logging.Logger;

public class ConnectorFactoryImpl {
    private static final Logger log = Logger.getLogger(class$org$jboss$jmx$connector$ConnectorFactoryImpl == null ? (class$org$jboss$jmx$connector$ConnectorFactoryImpl = ConnectorFactoryImpl.class$("org.jboss.jmx.connector.ConnectorFactoryImpl")) : class$org$jboss$jmx$connector$ConnectorFactoryImpl);
    private MBeanServer mServer;
    private int mNotificationType = 1;
    private String mJMSName;
    private String mEJBAdaptorName = "ejb/jmx/ejb/Adaptor";
    static /* synthetic */ Class class$org$jboss$jmx$connector$ConnectorFactoryImpl;

    public ConnectorFactoryImpl(MBeanServer pServer, int pNotificationType) {
        this(pServer, pNotificationType, null, null);
    }

    public ConnectorFactoryImpl(MBeanServer pServer, int pNotificationType, String pJMSQueueName) {
        this(pServer, pNotificationType, pJMSQueueName, "ejb/jmx/ejb/adaptor");
    }

    public ConnectorFactoryImpl(MBeanServer pServer, int pNotificationType, String pJMSName, String pEJBAdaptorName) {
        this.mServer = pServer;
        if (pJMSName != null) {
            this.mNotificationType = 0;
            this.mJMSName = pJMSName;
        } else {
            this.mNotificationType = pNotificationType;
        }
        if (pEJBAdaptorName != null && pEJBAdaptorName.trim().length() > 0) {
            this.mEJBAdaptorName = pEJBAdaptorName;
        }
    }

    public Iterator getConnectors(Hashtable pProperties, IConnectorTester pTester) {
        Vector<ConnectorName> lConnectors = new Vector<ConnectorName>();
        try {
            InitialContext lNamingServer = new InitialContext(pProperties);
            String lJNDIServer = (String)lNamingServer.getEnvironment().get("java.naming.provider.url");
            NamingEnumeration<NameClassPair> enumeration = lNamingServer.list("");
            while (enumeration.hasMore()) {
                NameClassPair lItem = enumeration.next();
                ConnectorName lName = pTester.check(lNamingServer, lItem);
                if (lName == null) continue;
                lConnectors.add(lName);
            }
            lNamingServer.close();
        }
        catch (Exception e) {
            log.error("operation failed", e);
        }
        return lConnectors.iterator();
    }

    public RemoteMBeanServer createConnection(ConnectorName pConnector) {
        RMIConnectorImpl lConnector = null;
        if (pConnector.getProtocol().equals("rmi")) {
            try {
                lConnector = new RMIConnectorImpl(this.mNotificationType, new String[]{this.mJMSName}, pConnector.getServer());
                this.mServer.registerMBean(lConnector, new ObjectName("jboss:name=RMIConnectorTo" + pConnector.getServer()));
            }
            catch (Exception e) {
                log.error("operation failed", e);
            }
        } else if (pConnector.getProtocol().equals("ejb")) {
            try {
                lConnector = new EJBConnector(this.mNotificationType, new String[]{this.mJMSName}, pConnector.getJNDIName(), pConnector.getServer());
                this.mServer.registerMBean(lConnector, new ObjectName("jboss:name=EJBConnectorTo" + pConnector.getServer()));
            }
            catch (Exception e) {
                log.error("operation failed", e);
            }
        }
        return lConnector;
    }

    public void removeConnection(ConnectorName pConnector) {
        try {
            Set lConnectors;
            if (pConnector.getProtocol().equals("rmi")) {
                Set lConnectors2 = this.mServer.queryMBeans(new ObjectName("jboss:name=RMIConnectorTo" + pConnector.getServer()), null);
                if (!lConnectors2.isEmpty()) {
                    Iterator i = lConnectors2.iterator();
                    while (i.hasNext()) {
                        ObjectInstance lConnector = (ObjectInstance)i.next();
                        this.mServer.invoke(lConnector.getObjectName(), "stop", new Object[0], new String[0]);
                        this.mServer.unregisterMBean(lConnector.getObjectName());
                    }
                }
            } else if (pConnector.getProtocol().equals("ejb") && !(lConnectors = this.mServer.queryMBeans(new ObjectName("jboss:name=EJBConnectorTo" + pConnector.getServer()), null)).isEmpty()) {
                Iterator i = lConnectors.iterator();
                while (i.hasNext()) {
                    ObjectInstance lConnector = (ObjectInstance)i.next();
                    this.mServer.invoke(lConnector.getObjectName(), "stop", new Object[0], new String[0]);
                    this.mServer.unregisterMBean(lConnector.getObjectName());
                }
            }
        }
        catch (Exception e) {
            log.error("operation failed", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ConnectorName {
        private String mServer;
        private String mProtocol;
        private String mJNDIName;

        public ConnectorName(String pServer, String pProtocol, String pJNDIName) {
            this.mServer = pServer;
            this.mProtocol = pProtocol;
            this.mJNDIName = pJNDIName;
        }

        public String getServer() {
            return this.mServer;
        }

        public String getProtocol() {
            return this.mProtocol;
        }

        public String getJNDIName() {
            return this.mJNDIName;
        }

        public String toString() {
            return "ConnectorName [ server: " + this.mServer + ", protocol: " + this.mProtocol + ", JNDI name: " + this.mJNDIName + " ]";
        }
    }

    public static class JBossConnectorTester
    implements IConnectorTester {
        public ConnectorName check(Context pContext, NameClassPair pPair) {
            ConnectorName lConnector = null;
            if (pPair != null) {
                StringTokenizer lTokens;
                String lName = pPair.getName();
                if (lName.startsWith("jmx:") && (lTokens = new StringTokenizer(lName, ":")).hasMoreTokens() && lTokens.nextToken().equals("jmx") && lTokens.hasMoreTokens()) {
                    String lServer = lTokens.nextToken();
                    if (lTokens.hasMoreTokens()) {
                        lConnector = new ConnectorName(lServer, lTokens.nextToken(), lName);
                    }
                }
                if (lName.equals("ejb")) {
                    try {
                        Context lContext = (Context)pContext.lookup("ejb");
                        lContext = (Context)lContext.lookup("jmx");
                        lContext = (Context)lContext.lookup("ejb");
                        if (lContext.lookup("Adaptor") != null) {
                            lConnector = new ConnectorName("" + pContext.getEnvironment().get("java.naming.provider.url"), "ejb", "ejb/jmx/ejb/Adaptor");
                        }
                    }
                    catch (NamingException ne) {
                        // empty catch block
                    }
                }
            }
            return lConnector;
        }
    }

    public static interface IConnectorTester {
        public ConnectorName check(Context var1, NameClassPair var2);
    }
}

