/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.http.interfaces;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.net.ssl.SSLSocketFactory;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationException;
import org.jboss.invocation.MarshalledValue;
import org.jboss.invocation.http.interfaces.AnyhostVerifier;
import org.jboss.logging.Logger;
import org.jboss.net.ssl.SSLSocketFactoryBuilder;
import org.jboss.security.SecurityAssociationAuthenticator;

public class Util {
    public static final String IGNORE_HTTPS_HOST = "org.jboss.security.ignoreHttpsHost";
    public static final String SSL_FACTORY_BUILDER = "org.jboss.security.httpInvoker.sslSocketFactoryBuilder";
    private static String REQUEST_CONTENT_TYPE = "application/x-java-serialized-object; class=org.jboss.invocation.MarshalledInvocation";
    private static Logger log = Logger.getLogger(class$org$jboss$invocation$http$interfaces$Util == null ? (class$org$jboss$invocation$http$interfaces$Util = Util.class$("org.jboss.invocation.http.interfaces.Util")) : class$org$jboss$invocation$http$interfaces$Util);
    private static Class httpsConnClass;
    private static SSLSocketFactoryBuilder sslSocketFactoryBuilder;
    static /* synthetic */ Class class$org$jboss$invocation$http$interfaces$Util;
    static /* synthetic */ Class class$javax$net$ssl$SSLSocketFactory;

    public static void init() {
        try {
            SetAuthenticator action = new SetAuthenticator();
            AccessController.doPrivileged(action);
        }
        catch (Exception e) {
            log.warn("Failed to install SecurityAssociationAuthenticator", e);
        }
    }

    public static Object invoke(URL externalURL, Invocation mi) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("invoke, externalURL=" + externalURL);
        }
        HttpURLConnection conn = (HttpURLConnection)externalURL.openConnection();
        Util.configureHttpsHostVerifier(conn);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("ContentType", REQUEST_CONTENT_TYPE);
        conn.setRequestMethod("POST");
        OutputStream os = conn.getOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        try {
            oos.writeObject(mi);
            oos.flush();
        }
        catch (ObjectStreamException e) {
            throw new InvocationException(e);
        }
        InputStream is = conn.getInputStream();
        ObjectInputStream ois = new ObjectInputStream(is);
        MarshalledValue mv = (MarshalledValue)ois.readObject();
        ois.read();
        ois.close();
        oos.close();
        Object value = mv.get();
        if (value instanceof Exception) {
            throw (Exception)value;
        }
        return value;
    }

    public static void configureHttpsHostVerifier(HttpURLConnection conn) throws InvocationTargetException, IllegalAccessException {
        boolean isHttpsConn;
        boolean bl = isHttpsConn = httpsConnClass != null && httpsConnClass.isAssignableFrom(conn.getClass());
        if (isHttpsConn && Boolean.getBoolean(IGNORE_HTTPS_HOST)) {
            AnyhostVerifier.setHostnameVerifier(conn);
        }
    }

    public static void configureSSLSocketFactory(HttpURLConnection conn) throws InvocationTargetException {
        boolean isHttpsConn;
        Class<?> connClass = conn.getClass();
        boolean bl = isHttpsConn = httpsConnClass != null && httpsConnClass.isAssignableFrom(conn.getClass());
        if (isHttpsConn && sslSocketFactoryBuilder != null) {
            try {
                SSLSocketFactory socketFactory = sslSocketFactoryBuilder.getSocketFactory();
                Class[] sig = new Class[]{class$javax$net$ssl$SSLSocketFactory == null ? (class$javax$net$ssl$SSLSocketFactory = Util.class$("javax.net.ssl.SSLSocketFactory")) : class$javax$net$ssl$SSLSocketFactory};
                Method method = connClass.getMethod("setSSLSocketFactory", sig);
                Object[] args = new Object[]{socketFactory};
                method.invoke((Object)conn, args);
                log.trace("Socket factory set on connection");
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
    }

    public static URL resolveURL(String urlValue) throws MalformedURLException {
        if (urlValue == null) {
            return null;
        }
        URL externalURL = null;
        try {
            externalURL = new URL(urlValue);
        }
        catch (MalformedURLException e) {
            String urlProperty = System.getProperty(urlValue);
            if (urlProperty == null) {
                throw e;
            }
            externalURL = new URL(urlProperty);
        }
        return externalURL;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            SetAuthenticator action = new SetAuthenticator();
            AccessController.doPrivileged(action);
        }
        catch (Exception e) {
            log.warn("Failed to install SecurityAssociationAuthenticator", e);
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            httpsConnClass = loader.loadClass("javax.net.ssl.HttpsURLConnection");
            log.debug("httpsConnClass: " + httpsConnClass);
        }
        catch (Exception e) {
            try {
                httpsConnClass = loader.loadClass("com.sun.net.ssl.HttpsURLConnection");
                log.debug("httpsConnClass: " + httpsConnClass);
            }
            catch (Exception e2) {
                log.warn("No HttpsURLConnection seen");
            }
        }
        String factoryFactoryFQCN = System.getProperty(SSL_FACTORY_BUILDER);
        if (factoryFactoryFQCN != null) {
            try {
                Class<?> clazz = loader.loadClass(factoryFactoryFQCN);
                sslSocketFactoryBuilder = (SSLSocketFactoryBuilder)clazz.newInstance();
            }
            catch (Exception e) {
                log.warn("Could not instantiate SSLSocketFactoryFactory", e);
            }
        }
    }

    static class SetAuthenticator
    implements PrivilegedAction {
        SetAuthenticator() {
        }

        public Object run() {
            Authenticator.setDefault(new SecurityAssociationAuthenticator());
            return null;
        }
    }
}

