/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2015, 2017 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * http://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package javax.security.identitystore;

import java.util.Set;

import javax.security.CallerPrincipal;
import javax.security.auth.message.module.ServerAuthModule;
import javax.security.authentication.mechanism.http.annotation.RememberMe;
import javax.security.authentication.mechanism.http.HttpAuthenticationMechanism;
import javax.security.identitystore.credential.RememberMeCredential;

/**
 * <code>RememberMeIdentityStore</code> is a mechanism for validating a caller's
 * credentials and accessing a caller's identity attributes that's specifically
 * tailored for the "remember me" feature.
 * 
 * <p>
 * This is not intended to be directly used by an authentication mechanism such as 
 * the JSR 375 {@link HttpAuthenticationMechanism} or the JSR 196 (JASPIC) 
 * {@link ServerAuthModule}. Instead, the interceptor implementation backing the 
 * {@link RememberMe} annotation is intended to use this. 
 * 
 */
public interface RememberMeIdentityStore {

    /**
     * Validates the given credential.
     *
     * @param credential
     *            The credential
     * @return The validation result, including associated caller roles and
     *         groups.
     */
    CredentialValidationResult validate(RememberMeCredential credential);
    
    /**
     * Associates the given principal and groups with a token.
     * <p>
     * The token generated by this method is intended to be used with the
     * {@link RememberMeCredential} and passed into the {@link #validate(RememberMeCredential)}
     * method.
     * 
     * @param callerPrincipal the principal to be associated
     * @param groups the groups the principal is in
     * @return a token that can be used to get the principal and groups back at a later moment.
     */
    String generateLoginToken(CallerPrincipal callerPrincipal, Set<String> groups);
    
    /**
     * Dissociates the principal and groups that were associated with the token before
     * and removes the token itself.
     * <p>
     * If the token did not exist (i.e. no principal and groups were associated with that token)
     * no exception will be thrown.
     * 
     * @param token the token that is to be removed
     */
    void removeLoginToken(String token);
    
}
