/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.identitymaps;

import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.exceptions.TopLinkException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.descriptors.ObjectBuilder;
import oracle.toplink.essentials.internal.helper.ClassConstants;
import oracle.toplink.essentials.internal.helper.ConcurrencyManager;
import oracle.toplink.essentials.internal.helper.DeferredLockManager;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.helper.JavaPlatform;
import oracle.toplink.essentials.internal.helper.WriteLockManager;
import oracle.toplink.essentials.internal.identitymaps.CacheKey;
import oracle.toplink.essentials.internal.identitymaps.FullIdentityMap;
import oracle.toplink.essentials.internal.identitymaps.IdentityMap;
import oracle.toplink.essentials.internal.localization.LoggingLocalization;
import oracle.toplink.essentials.internal.localization.TraceLocalization;
import oracle.toplink.essentials.internal.security.PrivilegedAccessHelper;
import oracle.toplink.essentials.internal.security.PrivilegedGetConstructorFor;
import oracle.toplink.essentials.internal.security.PrivilegedInvokeConstructor;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.queryframework.InMemoryQueryIndirectionPolicy;
import oracle.toplink.essentials.queryframework.ReadQuery;
import oracle.toplink.essentials.sessions.Record;

public class IdentityMapManager
implements Serializable,
Cloneable {
    protected Hashtable identityMaps;
    protected Map queryResults;
    protected AbstractSession session;
    protected transient ConcurrencyManager cacheMutex;
    protected IdentityMap lastAccessedIdentityMap = null;
    protected Class lastAccessedIdentityMapClass = null;
    protected transient WriteLockManager writeLockManager;
    protected Boolean isCacheAccessPreCheckRequired;

    public IdentityMapManager(AbstractSession session) {
        this.session = session;
        this.cacheMutex = new ConcurrencyManager();
        this.identityMaps = new Hashtable();
        this.queryResults = JavaPlatform.getQueryCacheMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireDeferredLock(Vector primaryKey, Class domainClass, ClassDescriptor descriptor) {
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = this.getIdentityMap(descriptor).acquireDeferredLock(primaryKey);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            cacheKey = this.getIdentityMap(descriptor).acquireDeferredLock(primaryKey);
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireLock(Vector primaryKey, Class domainClass, boolean forMerge, ClassDescriptor descriptor) {
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = this.getIdentityMap(descriptor).acquireLock(primaryKey, forMerge);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            cacheKey = this.getIdentityMap(descriptor).acquireLock(primaryKey, forMerge);
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireLockNoWait(Vector primaryKey, Class domainClass, boolean forMerge, ClassDescriptor descriptor) {
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = this.getIdentityMap(descriptor).acquireLockNoWait(primaryKey, forMerge);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            cacheKey = this.getIdentityMap(descriptor).acquireLockNoWait(primaryKey, forMerge);
        }
        return cacheKey;
    }

    protected boolean isCacheAccessPreCheckRequired() {
        if (this.isCacheAccessPreCheckRequired == null) {
            this.isCacheAccessPreCheckRequired = this.getSession().getProfiler() != null || this.getSession().getDatasourceLogin().shouldSynchronizedReadOnWrite() ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.isCacheAccessPreCheckRequired;
    }

    public void clearCacheAccessPreCheck() {
        this.isCacheAccessPreCheckRequired = null;
    }

    public void acquireReadLock() {
        this.getSession().startOperationProfile("cache");
        if (this.getSession().getDatasourceLogin().shouldSynchronizedReadOnWrite()) {
            this.getCacheMutex().acquireReadLock();
        }
        this.getSession().endOperationProfile("cache");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireReadLockOnCacheKey(Vector primaryKey, Class domainClass, ClassDescriptor descriptor) {
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = this.getIdentityMap(descriptor).acquireReadLockOnCacheKey(primaryKey);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            cacheKey = this.getIdentityMap(descriptor).acquireReadLockOnCacheKey(primaryKey);
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireReadLockOnCacheKeyNoWait(Vector primaryKey, Class domainClass, ClassDescriptor descriptor) {
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = this.getIdentityMap(descriptor).acquireReadLockOnCacheKeyNoWait(primaryKey);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            cacheKey = this.getIdentityMap(descriptor).acquireReadLockOnCacheKeyNoWait(primaryKey);
        }
        return cacheKey;
    }

    public boolean acquireWriteLock() {
        if (this.getSession().getDatasourceLogin().shouldSynchronizedReadOnWrite() || this.getSession().getDatasourceLogin().shouldSynchronizeWrites()) {
            this.getCacheMutex().acquire();
            return true;
        }
        return false;
    }

    public IdentityMap buildNewIdentityMap(ClassDescriptor descriptor) throws ValidationException, DescriptorException {
        if (this.getSession().isUnitOfWork()) {
            return new FullIdentityMap(100);
        }
        try {
            Constructor constructor = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(descriptor.getIdentityMapClass(), new Class[]{ClassConstants.PINT}, false));
                    return (IdentityMap)AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, new Object[]{new Integer(descriptor.getIdentityMapSize())}));
                }
                catch (PrivilegedActionException exception) {
                    throw DescriptorException.invalidIdentityMap(descriptor, exception.getException());
                }
            }
            constructor = PrivilegedAccessHelper.getConstructorFor(descriptor.getIdentityMapClass(), new Class[]{ClassConstants.PINT}, false);
            return (IdentityMap)PrivilegedAccessHelper.invokeConstructor(constructor, new Object[]{new Integer(descriptor.getIdentityMapSize())});
        }
        catch (Exception exception) {
            throw DescriptorException.invalidIdentityMap(descriptor, exception);
        }
    }

    public void clearLastAccessedIdentityMap() {
        this.lastAccessedIdentityMap = null;
        this.lastAccessedIdentityMapClass = null;
    }

    public Object clone() {
        IdentityMapManager manager = null;
        try {
            manager = (IdentityMapManager)super.clone();
            manager.setIdentityMaps(new Hashtable());
            Enumeration identityMapEnum = this.getIdentityMaps().keys();
            while (identityMapEnum.hasMoreElements()) {
                Class theClass = (Class)identityMapEnum.nextElement();
                manager.getIdentityMaps().put(theClass, ((IdentityMap)this.getIdentityMaps().get(theClass)).clone());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return manager;
    }

    public void clearQueryCache() {
        this.queryResults = JavaPlatform.getQueryCacheMap();
    }

    public void clearQueryCache(ReadQuery query) {
        if (query != null) {
            this.queryResults.remove(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Vector key, Class theClass, ClassDescriptor descriptor) {
        boolean contains;
        for (int index = 0; index < key.size(); ++index) {
            if (key.elementAt(index) != null) continue;
            return false;
        }
        IdentityMap map = this.getIdentityMap(descriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                contains = map.containsKey(key);
            }
            finally {
                this.releaseReadLock();
                this.getSession().endOperationProfile("cache");
            }
        } else {
            contains = map.containsKey(key);
        }
        return contains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector getAllFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, InMemoryQueryIndirectionPolicy valueHolderPolicy, boolean shouldReturnInvalidatedObjects) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(theClass);
        this.getSession().startOperationProfile("cache");
        Vector<Object> objects = null;
        try {
            Expression selectionCriteriaClone = selectionCriteria;
            if (selectionCriteria != null && selectionCriteriaClone.getBuilder().getSession() == null) {
                selectionCriteriaClone = (Expression)selectionCriteria.clone();
                selectionCriteriaClone.getBuilder().setSession(this.getSession());
                selectionCriteriaClone.getBuilder().setQueryClass(theClass);
            }
            objects = new Vector<Object>();
            IdentityMap map = this.getIdentityMap(descriptor);
            long currentTimeInMillis = System.currentTimeMillis();
            Enumeration cacheEnum = map.keys();
            while (cacheEnum.hasMoreElements()) {
                Object object;
                CacheKey key = (CacheKey)cacheEnum.nextElement();
                if (key.getObject() == null || !shouldReturnInvalidatedObjects && this.getSession().getDescriptor(theClass).getCacheInvalidationPolicy().isInvalidated(key, currentTimeInMillis) || (object = key.getObject()) == null || object.getClass() != theClass && !theClass.isInstance(object)) continue;
                if (selectionCriteriaClone == null) {
                    objects.addElement(object);
                    this.getSession().incrementProfile("CacheHits");
                    continue;
                }
                try {
                    if (!selectionCriteriaClone.doesConform(object, this.getSession(), (AbstractRecord)translationRow, valueHolderPolicy)) continue;
                    objects.addElement(object);
                    this.getSession().incrementProfile("CacheHits");
                }
                catch (QueryException queryException) {
                    if (queryException.getErrorCode() != 6092) throw queryException;
                    if (valueHolderPolicy.shouldIgnoreIndirectionExceptionReturnConformed()) {
                        objects.addElement(object);
                        this.getSession().incrementProfile("CacheHits");
                        continue;
                    }
                    if (!valueHolderPolicy.shouldThrowIndirectionException()) continue;
                    throw queryException;
                    return objects;
                }
            }
        }
        finally {
            this.getSession().endOperationProfile("cache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey getCacheKeyForObject(Vector primaryKey, Class myClass, ClassDescriptor descriptor) {
        IdentityMap map = this.getIdentityMap(descriptor);
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = map.getCacheKey(primaryKey);
            }
            finally {
                this.releaseReadLock();
                this.getSession().endOperationProfile("cache");
            }
        } else {
            cacheKey = map.getCacheKey(primaryKey);
        }
        return cacheKey;
    }

    public ConcurrencyManager getCacheMutex() {
        return this.cacheMutex;
    }

    public Vector getClassesRegistered() {
        Enumeration classes = this.getIdentityMaps().keys();
        Vector<String> results = new Vector<String>(this.getIdentityMaps().size());
        while (classes.hasMoreElements()) {
            results.add(((Class)classes.nextElement()).getName());
        }
        return results;
    }

    public Object getFromIdentityMap(Object object) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(object);
        Vector primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this.getSession());
        return this.getFromIdentityMap(primaryKey, object.getClass(), descriptor);
    }

    public Object getFromIdentityMap(Vector key, Class theClass, ClassDescriptor descriptor) {
        return this.getFromIdentityMap(key, theClass, true, descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFromIdentityMap(Vector key, Class theClass, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        CacheKey cacheKey;
        if (key == null) {
            return null;
        }
        for (int index = 0; index < key.size(); ++index) {
            if (key.elementAt(index) != null) continue;
            return null;
        }
        IdentityMap map = this.getIdentityMap(descriptor);
        Object domainObject = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = map.getCacheKey(key);
            }
            finally {
                this.releaseReadLock();
            }
        } else {
            cacheKey = map.getCacheKey(key);
        }
        if (cacheKey != null && (shouldReturnInvalidatedObjects || !this.getSession().getDescriptor(theClass).getCacheInvalidationPolicy().isInvalidated(cacheKey, System.currentTimeMillis()))) {
            domainObject = cacheKey.getObject();
            domainObject = this.checkForInheritance(domainObject, theClass);
        }
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().endOperationProfile("cache");
            if (domainObject == null) {
                this.getSession().incrementProfile("CacheMisses");
            } else {
                this.getSession().incrementProfile("CacheHits");
            }
        }
        return domainObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, InMemoryQueryIndirectionPolicy valueHolderPolicy, boolean conforming, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        UnitOfWorkImpl unitOfWork = conforming ? (UnitOfWorkImpl)this.getSession() : null;
        this.getSession().startOperationProfile("cache");
        try {
            Expression selectionCriteriaClone = selectionCriteria;
            if (selectionCriteria != null && selectionCriteriaClone.getBuilder().getSession() == null) {
                selectionCriteriaClone = (Expression)selectionCriteria.clone();
                selectionCriteriaClone.getBuilder().setSession(this.getSession());
                selectionCriteriaClone.getBuilder().setQueryClass(theClass);
            }
            IdentityMap map = this.getIdentityMap(descriptor);
            long currentTimeInMillis = System.currentTimeMillis();
            Enumeration cacheEnum = map.keys();
            while (cacheEnum.hasMoreElements()) {
                Object object;
                CacheKey key = (CacheKey)cacheEnum.nextElement();
                if (!shouldReturnInvalidatedObjects && descriptor.getCacheInvalidationPolicy().isInvalidated(key, currentTimeInMillis) || (object = key.getObject()) == null || object.getClass() != theClass && !theClass.isInstance(object)) continue;
                if (!(selectionCriteriaClone != null || conforming && unitOfWork.isObjectDeleted(object))) {
                    this.getSession().incrementProfile("CacheHits");
                    Object object2 = object;
                    this.getSession().endOperationProfile("cache");
                    return object2;
                }
                if (!selectionCriteriaClone.doesConform(object, this.getSession(), (AbstractRecord)translationRow, valueHolderPolicy) || conforming && unitOfWork.isObjectDeleted(object)) continue;
                this.getSession().incrementProfile("CacheHits");
                Object object3 = object;
                this.getSession().endOperationProfile("cache");
                return object3;
            }
            return null;
        }
        finally {
            this.getSession().endOperationProfile("cache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFromIdentityMapWithDeferredLock(Vector key, Class theClass, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        CacheKey cacheKey;
        if (key == null) {
            this.getSession().incrementProfile("CacheMisses");
            return null;
        }
        for (int index = 0; index < key.size(); ++index) {
            if (key.elementAt(index) != null) continue;
            this.getSession().incrementProfile("CacheMisses");
            return null;
        }
        IdentityMap map = this.getIdentityMap(descriptor);
        Object domainObject = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = map.getCacheKey(key);
            }
            finally {
                this.releaseReadLock();
            }
        } else {
            cacheKey = map.getCacheKey(key);
        }
        if (cacheKey != null && (shouldReturnInvalidatedObjects || !descriptor.getCacheInvalidationPolicy().isInvalidated(cacheKey, System.currentTimeMillis()))) {
            cacheKey.acquireDeferredLock();
            domainObject = cacheKey.getObject();
            cacheKey.releaseDeferredLock();
        }
        domainObject = this.checkForInheritance(domainObject, theClass);
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().endOperationProfile("cache");
            if (domainObject == null) {
                this.getSession().incrementProfile("CacheMisses");
            } else {
                this.getSession().incrementProfile("CacheHits");
            }
        }
        return domainObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentityMap getIdentityMap(ClassDescriptor descriptor) {
        IdentityMap identityMap;
        if (descriptor.hasInheritance()) {
            descriptor = descriptor.getInheritancePolicy().getRootParentDescriptor();
        }
        Class descriptorClass = descriptor.getJavaClass();
        IdentityMapManager identityMapManager = this;
        synchronized (identityMapManager) {
            IdentityMap tempMap = this.lastAccessedIdentityMap;
            if (tempMap != null && this.lastAccessedIdentityMapClass == descriptorClass) {
                return tempMap;
            }
            identityMap = (IdentityMap)this.getIdentityMaps().get(descriptorClass);
            if (identityMap == null) {
                identityMap = this.buildNewIdentityMap(descriptor);
                this.getIdentityMaps().put(descriptorClass, identityMap);
            }
            this.lastAccessedIdentityMap = identityMap;
            this.lastAccessedIdentityMapClass = descriptorClass;
        }
        return identityMap;
    }

    protected Hashtable getIdentityMaps() {
        return this.identityMaps;
    }

    public Enumeration getIdentityMapClasses() {
        return this.identityMaps.keys();
    }

    protected Vector getKey(Object domainObject) {
        return this.getSession().keyFromObject(domainObject);
    }

    protected AbstractSession getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getWrapper(Vector primaryKey, Class theClass) {
        Object wrapper;
        ClassDescriptor descriptor = this.getSession().getDescriptor(theClass);
        IdentityMap map = this.getIdentityMap(descriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                wrapper = map.getWrapper(primaryKey);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            wrapper = map.getWrapper(primaryKey);
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteLockManager getWriteLockManager() {
        IdentityMapManager identityMapManager = this;
        synchronized (identityMapManager) {
            if (this.writeLockManager == null) {
                this.writeLockManager = new WriteLockManager();
            }
        }
        return this.writeLockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getWriteLockValue(Vector primaryKey, Class domainClass, ClassDescriptor descriptor) {
        Object value;
        IdentityMap map = this.getIdentityMap(descriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                value = map.getWriteLockValue(primaryKey);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            value = map.getWriteLockValue(primaryKey);
        }
        return value;
    }

    public void initializeIdentityMap(Class theClass) throws TopLinkException {
        ClassDescriptor descriptor = this.getSession().getDescriptor(theClass);
        if (descriptor == null) {
            throw ValidationException.missingDescriptor(String.valueOf(theClass));
        }
        if (descriptor.isChildDescriptor()) {
            throw ValidationException.childDescriptorsDoNotHaveIdentityMap();
        }
        Class javaClass = descriptor.getJavaClass();
        if (javaClass == this.lastAccessedIdentityMapClass) {
            this.clearLastAccessedIdentityMap();
        }
        IdentityMap identityMap = this.buildNewIdentityMap(descriptor);
        this.getIdentityMaps().put(javaClass, identityMap);
    }

    public void initializeIdentityMaps() {
        this.clearLastAccessedIdentityMap();
        this.setIdentityMaps(new Hashtable());
        this.clearQueryCache();
    }

    public void printIdentityMap(Class businessClass) {
        String cr = Helper.cr();
        ClassDescriptor descriptor = this.getSession().getDescriptor(businessClass);
        int cacheCounter = 0;
        StringWriter writer = new StringWriter();
        if (descriptor.isAggregateDescriptor()) {
            return;
        }
        IdentityMap map = this.getIdentityMap(descriptor);
        writer.write(LoggingLocalization.buildMessage("identitymap_for", new Object[]{cr, Helper.getShortClassName(map.getClass()), Helper.getShortClassName(businessClass)}));
        if (descriptor.hasInheritance() && descriptor.getInheritancePolicy().isRootParentDescriptor()) {
            writer.write(LoggingLocalization.buildMessage("includes"));
            Vector childDescriptors = descriptor.getInheritancePolicy().getChildDescriptors();
            if (childDescriptors != null && childDescriptors.size() != 0) {
                Enumeration enum2 = childDescriptors.elements();
                writer.write(Helper.getShortClassName(((ClassDescriptor)enum2.nextElement()).getJavaClass()));
                while (enum2.hasMoreElements()) {
                    writer.write(", " + Helper.getShortClassName(((ClassDescriptor)enum2.nextElement()).getJavaClass()));
                }
            }
            writer.write(")");
        }
        Enumeration enumtr = map.keys();
        while (enumtr.hasMoreElements()) {
            CacheKey cacheKey = (CacheKey)enumtr.nextElement();
            Object object = cacheKey.getObject();
            if (!businessClass.isInstance(object)) continue;
            ++cacheCounter;
            if (object == null) {
                writer.write(LoggingLocalization.buildMessage("key_object_null", new Object[]{cr, cacheKey.getKey(), "\t"}));
                continue;
            }
            writer.write(LoggingLocalization.buildMessage("key_identity_hash_code_object", new Object[]{cr, cacheKey.getKey(), "\t", String.valueOf(System.identityHashCode(object)), object}));
        }
        writer.write(LoggingLocalization.buildMessage("elements", new Object[]{cr, String.valueOf(cacheCounter)}));
        this.getSession().log(7, "cache", writer.toString(), null, null, false);
    }

    public void printIdentityMaps() {
        for (Class businessClass : this.getSession().getDescriptors().keySet()) {
            ClassDescriptor descriptor = this.getSession().getDescriptor(businessClass);
            if (descriptor.hasInheritance()) {
                if (!descriptor.getInheritancePolicy().isRootParentDescriptor()) continue;
                this.printIdentityMap(businessClass);
                continue;
            }
            this.printIdentityMap(businessClass);
        }
    }

    public void printLocks() {
        StringWriter writer = new StringWriter();
        HashMap threadCollection = new HashMap();
        writer.write(TraceLocalization.buildMessage("lock_writer_header", null) + Helper.cr());
        for (IdentityMap idenityMap : this.session.getIdentityMapAccessorInstance().getIdentityMapManager().getIdentityMaps().values()) {
            idenityMap.collectLocks(threadCollection);
        }
        Object[] parameters = new Object[1];
        for (Thread activeThread : threadCollection.keySet()) {
            parameters[0] = activeThread.getName();
            writer.write(TraceLocalization.buildMessage("active_thread", parameters) + Helper.cr());
            for (CacheKey cacheKey : (HashSet)threadCollection.get(activeThread)) {
                parameters[0] = cacheKey.getObject();
                writer.write(TraceLocalization.buildMessage("locked_object", parameters) + Helper.cr());
                parameters[0] = new Integer(cacheKey.getMutex().getDepth());
                writer.write(TraceLocalization.buildMessage("depth", parameters) + Helper.cr());
            }
            DeferredLockManager deferredLockManager = ConcurrencyManager.getDeferredLockManager(activeThread);
            if (deferredLockManager == null) continue;
            for (ConcurrencyManager lock : deferredLockManager.getDeferredLocks()) {
                parameters[0] = lock.getOwnerCacheKey().getObject();
                writer.write(TraceLocalization.buildMessage("deferred_locks", parameters) + Helper.cr());
            }
        }
        writer.write(Helper.cr() + TraceLocalization.buildMessage("lock_writer_footer", null) + Helper.cr());
        this.getSession().log(1, "cache", writer.toString(), null, null, false);
    }

    public void printLocks(Class theClass) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(theClass);
        StringWriter writer = new StringWriter();
        HashMap threadCollection = new HashMap();
        writer.write(TraceLocalization.buildMessage("lock_writer_header", null) + Helper.cr());
        IdentityMap identityMap = this.getIdentityMap(descriptor);
        identityMap.collectLocks(threadCollection);
        Object[] parameters = new Object[1];
        for (Thread activeThread : threadCollection.keySet()) {
            parameters[0] = activeThread.getName();
            writer.write(TraceLocalization.buildMessage("active_thread", parameters) + Helper.cr());
            for (CacheKey cacheKey : (HashSet)threadCollection.get(activeThread)) {
                parameters[0] = cacheKey.getObject();
                writer.write(TraceLocalization.buildMessage("locked_object", parameters) + Helper.cr());
                parameters[0] = new Integer(cacheKey.getMutex().getDepth());
                writer.write(TraceLocalization.buildMessage("depth", parameters) + Helper.cr());
            }
            DeferredLockManager deferredLockManager = ConcurrencyManager.getDeferredLockManager(activeThread);
            if (deferredLockManager == null) continue;
            for (ConcurrencyManager lock : deferredLockManager.getDeferredLocks()) {
                parameters[0] = lock.getOwnerCacheKey().getObject();
                writer.write(TraceLocalization.buildMessage("deferred_locks", parameters) + Helper.cr());
            }
        }
        writer.write(Helper.cr() + TraceLocalization.buildMessage("lock_writer_footer", null) + Helper.cr());
        this.getSession().log(1, "cache", writer.toString(), null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey putInIdentityMap(Object domainObject, Vector keys, Object writeLockValue, long readTime, ClassDescriptor descriptor) {
        CacheKey cacheKey;
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(domainObject, this.getSession());
        IdentityMap map = this.getIdentityMap(descriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = map.put(keys, implementation, writeLockValue, readTime);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            cacheKey = map.put(keys, implementation, writeLockValue, readTime);
        }
        return cacheKey;
    }

    protected void releaseReadLock() {
        if (this.getSession().getDatasourceLogin().shouldSynchronizedReadOnWrite()) {
            this.getCacheMutex().releaseReadLock();
        }
    }

    public void releaseWriteLock() {
        if (this.getSession().getDatasourceLogin().shouldSynchronizedReadOnWrite() || this.getSession().getDatasourceLogin().shouldSynchronizeWrites()) {
            this.getCacheMutex().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeFromIdentityMap(Vector key, Class domainClass, ClassDescriptor descriptor) {
        Object value;
        IdentityMap map = this.getIdentityMap(descriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                value = map.remove(key);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            value = map.remove(key);
        }
        return value;
    }

    protected void setCacheMutex(ConcurrencyManager cacheMutex) {
        this.cacheMutex = cacheMutex;
    }

    public void setIdentityMaps(Hashtable identityMaps) {
        this.clearLastAccessedIdentityMap();
        this.identityMaps = identityMaps;
    }

    protected void setSession(AbstractSession session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWrapper(Vector primaryKey, Class theClass, Object wrapper) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(theClass);
        IdentityMap map = this.getIdentityMap(descriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                map.setWrapper(primaryKey, wrapper);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            map.setWrapper(primaryKey, wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWriteLockValue(Vector primaryKey, Class theClass, Object writeLockValue) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(theClass);
        IdentityMap map = this.getIdentityMap(descriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                map.setWriteLockValue(primaryKey, writeLockValue);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            map.setWriteLockValue(primaryKey, writeLockValue);
        }
    }

    private Object checkForInheritance(Object domainObject, Class superClass) {
        if (domainObject != null && domainObject.getClass() != superClass && !superClass.isInstance(domainObject)) {
            ClassDescriptor descriptor = this.getSession().getDescriptor(superClass);
            if (descriptor.hasInheritance() && descriptor.getInheritancePolicy().getUseDescriptorsToValidateInheritedObjects()) {
                if (descriptor.getInheritancePolicy().getSubclassDescriptor(domainObject.getClass()) == null) {
                    return null;
                }
                return domainObject;
            }
            return null;
        }
        return domainObject;
    }
}

