/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.base;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.essentials.internal.ejb.cmp3.EntityManagerSetupImpl;
import oracle.toplink.essentials.internal.ejb.cmp3.base.EntityManagerImpl;
import oracle.toplink.essentials.internal.localization.ExceptionLocalization;
import oracle.toplink.essentials.threetier.ServerSession;

public abstract class EntityManagerFactoryImpl {
    protected ServerSession serverSession;
    protected EntityManagerSetupImpl setupImpl;
    protected Vector entityManagers;
    protected boolean isOpen = true;
    protected Map properties;

    protected abstract EntityManagerImpl createEntityManagerImplInternal(Map var1, boolean var2);

    public EntityManagerFactoryImpl(ServerSession serverSession) {
        this.serverSession = serverSession;
        this.entityManagers = new Vector();
    }

    public EntityManagerFactoryImpl(EntityManagerSetupImpl setupImpl, Map properties) {
        this.setupImpl = setupImpl;
        this.properties = properties;
        this.entityManagers = new Vector();
    }

    public synchronized ServerSession getServerSession() {
        if (this.serverSession == null) {
            ClassLoader realLoader = this.setupImpl.getPersistenceUnitInfo().getClassLoader();
            this.serverSession = this.setupImpl.deploy(realLoader, this.properties);
        }
        return this.serverSession;
    }

    public synchronized void close() {
        this.verifyOpen();
        this.isOpen = false;
        Iterator iterator = this.entityManagers.iterator();
        while (iterator.hasNext()) {
            EntityManagerImpl impl = (EntityManagerImpl)((WeakReference)iterator.next()).get();
            if (impl == null || !impl.isOpen()) continue;
            impl.close();
        }
        if (this.serverSession != null) {
            this.setupImpl.undeploy();
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    protected EntityManagerImpl createEntityManagerImpl(boolean extended) {
        return this.createEntityManagerImpl(null, extended);
    }

    protected synchronized EntityManagerImpl createEntityManagerImpl(Map properties, boolean extended) {
        this.verifyOpen();
        if (!this.getServerSession().isConnected()) {
            this.getServerSession().login();
        }
        EntityManagerImpl manager = this.createEntityManagerImplInternal(properties, extended);
        this.entityManagers.add(new WeakReference<EntityManagerImpl>(manager));
        return manager;
    }

    protected void verifyOpen() {
        if (!this.isOpen) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("operation_on_closed_entity_manager_factory"));
        }
    }

    protected void finalize() throws Throwable {
        if (this.isOpen()) {
            this.close();
        }
    }
}

