/*
 * Decompiled with CFR 0.152.
 */
package javax.money.spi;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.money.MonetaryException;
import javax.money.format.AmountFormatQuery;
import javax.money.format.AmountFormatQueryBuilder;
import javax.money.format.MonetaryAmountFormat;

public interface MonetaryFormatsSingletonSpi {
    public Set<Locale> getAvailableLocales(String ... var1);

    public Collection<MonetaryAmountFormat> getAmountFormats(AmountFormatQuery var1);

    public Set<String> getProviderNames();

    public List<String> getDefaultProviderChain();

    default public MonetaryAmountFormat getAmountFormat(AmountFormatQuery formatQuery) {
        Collection<MonetaryAmountFormat> formats = this.getAmountFormats(formatQuery);
        if (formats.isEmpty()) {
            throw new MonetaryException("No MonetaryAmountFormat for AmountFormatQuery " + formatQuery);
        }
        return formats.iterator().next();
    }

    default public boolean isAvailable(AmountFormatQuery formatQuery) {
        return !this.getAmountFormats(formatQuery).isEmpty();
    }

    default public boolean isAvailable(Locale locale, String ... providers) {
        return this.isAvailable(AmountFormatQuery.of(locale, providers));
    }

    default public MonetaryAmountFormat getAmountFormat(Locale locale, String ... providers) {
        return this.getAmountFormat(((AmountFormatQueryBuilder)AmountFormatQueryBuilder.of(locale).setProviders(providers)).build());
    }

    default public MonetaryAmountFormat getAmountFormat(String formatName, String ... providers) {
        return this.getAmountFormat(((AmountFormatQueryBuilder)AmountFormatQueryBuilder.of(formatName).setProviders(providers)).build());
    }
}

