/*
 * Decompiled with CFR 0.152.
 */
package javax.money.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.spi.ServiceProvider;

class DefaultServiceProvider
implements ServiceProvider {
    private final ConcurrentHashMap<Class, List<Object>> servicesLoaded = new ConcurrentHashMap();

    DefaultServiceProvider() {
    }

    @Override
    public <T> List<T> getServices(Class<T> serviceType, List<T> defaultList) {
        List<Object> found = this.servicesLoaded.get(serviceType);
        if (found != null) {
            return found;
        }
        return this.loadServices(serviceType, defaultList);
    }

    private <T> List<T> loadServices(Class<T> serviceType, List<T> defaultList) {
        try {
            ArrayList<T> previousServices;
            ArrayList<T> services = new ArrayList<T>();
            for (T t : ServiceLoader.load(serviceType)) {
                services.add(t);
            }
            if (services.isEmpty()) {
                services.addAll(defaultList);
            }
            return Collections.unmodifiableList((previousServices = (ArrayList<T>)this.servicesLoaded.putIfAbsent(serviceType, services)) != null ? previousServices : services);
        }
        catch (Exception e) {
            Logger.getLogger(DefaultServiceProvider.class.getName()).log(Level.WARNING, "Error loading services of type " + serviceType, e);
            return defaultList;
        }
    }
}

