/*
 * Decompiled with CFR 0.152.
 */
package javax.money.spi;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import javax.money.MonetaryException;
import javax.money.spi.DefaultServiceProvider;
import javax.money.spi.ServiceProvider;

public final class Bootstrap {
    private static volatile ServiceProvider serviceProviderDelegate;
    private static final Object LOCK;

    private Bootstrap() {
    }

    private static ServiceProvider loadDefaultServiceProvider() {
        try {
            Iterator<ServiceProvider> iterator = ServiceLoader.load(ServiceProvider.class).iterator();
            if (iterator.hasNext()) {
                ServiceProvider sp = iterator.next();
                return sp;
            }
        }
        catch (Exception e) {
            Logger.getLogger(Bootstrap.class.getName()).info("No ServiceProvider loaded, using default.");
        }
        return new DefaultServiceProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceProvider init(ServiceProvider serviceProvider) {
        Objects.requireNonNull(serviceProvider);
        Object object = LOCK;
        synchronized (object) {
            if (Objects.isNull(serviceProviderDelegate)) {
                serviceProviderDelegate = serviceProvider;
                Logger.getLogger(Bootstrap.class.getName()).info("Money Bootstrap: new ServiceProvider set: " + serviceProvider.getClass().getName());
                return null;
            }
            ServiceProvider prevProvider = serviceProviderDelegate;
            serviceProviderDelegate = serviceProvider;
            Logger.getLogger(Bootstrap.class.getName()).warning("Money Bootstrap: ServiceProvider replaced: " + serviceProvider.getClass().getName());
            return prevProvider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ServiceProvider getServiceProvider() {
        if (Objects.isNull(serviceProviderDelegate)) {
            Object object = LOCK;
            synchronized (object) {
                if (Objects.isNull(serviceProviderDelegate)) {
                    serviceProviderDelegate = Bootstrap.loadDefaultServiceProvider();
                }
            }
        }
        return serviceProviderDelegate;
    }

    public static <T> Collection<T> getServices(Class<T> serviceType) {
        return Bootstrap.getServiceProvider().getServices(serviceType);
    }

    public static <T> List<T> getServices(Class<T> serviceType, List<T> defaultServices) {
        return Bootstrap.getServiceProvider().getServices(serviceType, defaultServices);
    }

    public static <T> T getService(Class<T> serviceType) {
        List<T> services = Bootstrap.getServiceProvider().getServices(serviceType);
        if (services.isEmpty()) {
            throw new MonetaryException("No such service found: " + serviceType);
        }
        return services.get(0);
    }

    public static <T> T getService(Class<T> serviceType, T defaultService) {
        List<T> services = Bootstrap.getServiceProvider().getServices(serviceType);
        if (services.isEmpty()) {
            return defaultService;
        }
        return services.get(0);
    }

    static {
        LOCK = new Object();
    }
}

