/*
 * Decompiled with CFR 0.152.
 */
package javax.money.format;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.MonetaryException;
import javax.money.format.AmountFormatQuery;
import javax.money.format.AmountFormatQueryBuilder;
import javax.money.format.MonetaryAmountFormat;
import javax.money.spi.Bootstrap;
import javax.money.spi.MonetaryAmountFormatProviderSpi;
import javax.money.spi.MonetaryFormatsSingletonSpi;

public final class MonetaryFormats {
    private static final MonetaryFormatsSingletonSpi monetaryFormatsSingletonSpi = MonetaryFormats.loadMonetaryFormatsSingletonSpi();

    private MonetaryFormats() {
    }

    private static MonetaryFormatsSingletonSpi loadMonetaryFormatsSingletonSpi() {
        try {
            return Bootstrap.getService(MonetaryFormatsSingletonSpi.class, new DefaultMonetaryFormatsSingletonSpi());
        }
        catch (Exception e) {
            Logger.getLogger(MonetaryFormats.class.getName()).log(Level.WARNING, "Failed to load MonetaryFormatsSingletonSpi, using default.", e);
            return new DefaultMonetaryFormatsSingletonSpi();
        }
    }

    public static boolean isAvailable(Locale locale, String ... providers) {
        return Optional.ofNullable(monetaryFormatsSingletonSpi).orElseThrow(() -> new MonetaryException("No MonetaryFormatsSingletonSpi loaded, query functionality is not available.")).isAvailable(locale, providers);
    }

    public static MonetaryAmountFormat getAmountFormat(Locale locale, String ... providers) {
        return MonetaryFormats.getAmountFormat(((AmountFormatQueryBuilder)AmountFormatQueryBuilder.of(locale).setProviders(providers)).setLocale(locale).build());
    }

    public static boolean isAvailable(AmountFormatQuery formatQuery) {
        return Optional.ofNullable(monetaryFormatsSingletonSpi).orElseThrow(() -> new MonetaryException("No MonetaryFormatsSingletonSpi loaded, query functionality is not available.")).isAvailable(formatQuery);
    }

    public static MonetaryAmountFormat getAmountFormat(AmountFormatQuery formatQuery) {
        return Optional.ofNullable(monetaryFormatsSingletonSpi).orElseThrow(() -> new MonetaryException("No MonetaryFormatsSingletonSpi loaded, query functionality is not available.")).getAmountFormat(formatQuery);
    }

    public static Collection<MonetaryAmountFormat> getAmountFormats(AmountFormatQuery formatQuery) {
        return Optional.ofNullable(monetaryFormatsSingletonSpi).orElseThrow(() -> new MonetaryException("No MonetaryFormatsSingletonSpi loaded, query functionality is not available.")).getAmountFormats(formatQuery);
    }

    public static MonetaryAmountFormat getAmountFormat(String formatName, String ... providers) {
        return MonetaryFormats.getAmountFormat(((AmountFormatQueryBuilder)AmountFormatQueryBuilder.of(formatName).setProviders(providers)).build());
    }

    public static Set<Locale> getAvailableLocales(String ... providers) {
        return monetaryFormatsSingletonSpi.getAvailableLocales(providers);
    }

    public static Collection<String> getProviderNames() {
        Set<String> providers = Optional.ofNullable(monetaryFormatsSingletonSpi).orElseThrow(() -> new MonetaryException("No MonetaryConveresionsSingletonSpi loaded, query functionality is not available.")).getProviderNames();
        if (Objects.isNull(providers)) {
            Logger.getLogger(MonetaryFormats.class.getName()).warning("No supported rate/conversion providers returned by SPI: " + monetaryFormatsSingletonSpi.getClass().getName());
            return Collections.emptySet();
        }
        return providers;
    }

    public static List<String> getDefaultProviderChain() {
        return Optional.ofNullable(monetaryFormatsSingletonSpi).orElseThrow(() -> new MonetaryException("No MonetaryFormatsSingletonSpi loaded, query functionality is not available.")).getDefaultProviderChain();
    }

    public static final class DefaultMonetaryFormatsSingletonSpi
    implements MonetaryFormatsSingletonSpi {
        @Override
        public Collection<MonetaryAmountFormat> getAmountFormats(AmountFormatQuery formatQuery) {
            ArrayList<MonetaryAmountFormat> result = new ArrayList<MonetaryAmountFormat>();
            for (MonetaryAmountFormatProviderSpi spi : Bootstrap.getServices(MonetaryAmountFormatProviderSpi.class)) {
                Collection<MonetaryAmountFormat> formats = spi.getAmountFormats(formatQuery);
                if (!Objects.nonNull(formats)) continue;
                result.addAll(formats);
            }
            return result;
        }

        @Override
        public Set<String> getProviderNames() {
            return this.getSpisAsMap().keySet();
        }

        @Override
        public List<String> getDefaultProviderChain() {
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(this.getProviderNames());
            Collections.sort(list);
            return list;
        }

        @Override
        public Set<Locale> getAvailableLocales(String ... providerNames) {
            HashSet<Locale> locales = new HashSet<Locale>();
            Collection<MonetaryAmountFormatProviderSpi> spis = this.getSpis(providerNames);
            for (MonetaryAmountFormatProviderSpi spi : spis) {
                locales.addAll(spi.getAvailableLocales());
            }
            return locales;
        }

        private Map<String, MonetaryAmountFormatProviderSpi> getSpisAsMap() {
            ConcurrentHashMap<String, MonetaryAmountFormatProviderSpi> spis = new ConcurrentHashMap<String, MonetaryAmountFormatProviderSpi>();
            for (MonetaryAmountFormatProviderSpi spi : Bootstrap.getServices(MonetaryAmountFormatProviderSpi.class)) {
                if (spi.getProviderName() == null) {
                    Logger.getLogger(MonetaryFormats.class.getName()).warning("MonetaryAmountFormatProviderSpi returns null for getProviderName: " + spi.getClass().getName());
                }
                spis.put(spi.getProviderName(), spi);
            }
            return spis;
        }

        private Collection<MonetaryAmountFormatProviderSpi> getSpis(String ... providerNames) {
            ArrayList<MonetaryAmountFormatProviderSpi> providers = new ArrayList<MonetaryAmountFormatProviderSpi>();
            Map<String, MonetaryAmountFormatProviderSpi> spis = this.getSpisAsMap();
            if (providerNames.length == 0) {
                providers.addAll(spis.values());
            } else {
                for (String provName : providerNames) {
                    MonetaryAmountFormatProviderSpi spi = spis.get(provName);
                    if (Objects.isNull(spi)) {
                        throw new IllegalArgumentException("MonetaryAmountFormatProviderSpi not found: " + provName);
                    }
                    providers.add(spi);
                }
            }
            return providers;
        }
    }
}

