/*
 * Decompiled with CFR 0.152.
 */
package javax.money.convert;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import javax.money.AbstractContextBuilder;
import javax.money.convert.ProviderContext;
import javax.money.convert.RateType;

public final class ProviderContextBuilder
extends AbstractContextBuilder<ProviderContextBuilder, ProviderContext> {
    private ProviderContextBuilder(String provider, RateType rateType, RateType ... rateTypes) {
        Objects.requireNonNull(rateType, "At least one RateType is required.");
        Objects.requireNonNull(rateTypes);
        this.setProvider(provider);
        HashSet<RateType> rts = new HashSet<RateType>();
        rts.add(rateType);
        Collections.addAll(rts, rateTypes);
        this.set("rateTypes", rts);
    }

    private ProviderContextBuilder(String provider, Collection<RateType> rateTypes) {
        Objects.requireNonNull(rateTypes);
        if (rateTypes.isEmpty()) {
            throw new IllegalArgumentException("At least one RateType is required.");
        }
        this.setProvider(provider);
        HashSet<RateType> rts = new HashSet<RateType>();
        rts.addAll(rateTypes);
        this.set("rateTypes", rts);
    }

    private ProviderContextBuilder(ProviderContext context) {
        this.importContext(context);
        HashSet<RateType> rts = new HashSet<RateType>();
        rts.addAll(context.getRateTypes());
        this.set("rateTypes", rts);
    }

    public ProviderContextBuilder setRateTypes(RateType ... rateTypes) {
        return this.setRateTypes(Arrays.asList(rateTypes));
    }

    public ProviderContextBuilder setRateTypes(Collection<RateType> rateTypes) {
        Objects.requireNonNull(rateTypes);
        if (rateTypes.size() == 0) {
            throw new IllegalArgumentException("At least one RateType is required.");
        }
        HashSet<RateType> rtSet = new HashSet<RateType>();
        rtSet.addAll(rateTypes);
        this.set("rateTypes", rtSet);
        return this;
    }

    @Override
    public ProviderContext build() {
        return new ProviderContext(this);
    }

    public static ProviderContextBuilder create(ProviderContext context) {
        return new ProviderContextBuilder(context);
    }

    public static ProviderContextBuilder of(String provider, RateType rateType, RateType ... rateTypes) {
        return new ProviderContextBuilder(provider, rateType, rateTypes);
    }

    public static ProviderContextBuilder of(String provider, Collection<RateType> rateTypes) {
        return new ProviderContextBuilder(provider, rateTypes);
    }
}

