/*
 * Decompiled with CFR 0.152.
 */
package javax.money.convert;

import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryCurrencies;
import javax.money.convert.ConversionQuery;
import javax.money.convert.ConversionQueryBuilder;
import javax.money.convert.CurrencyConversion;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ProviderContext;

public interface ExchangeRateProvider {
    public ProviderContext getProviderContext();

    public ExchangeRate getExchangeRate(ConversionQuery var1);

    public CurrencyConversion getCurrencyConversion(ConversionQuery var1);

    default public boolean isAvailable(ConversionQuery conversionQuery) {
        Objects.requireNonNull(conversionQuery);
        try {
            return conversionQuery.getProviders().isEmpty() || conversionQuery.getProviders().contains(this.getProviderContext().getProvider());
        }
        catch (Exception e) {
            return false;
        }
    }

    default public ExchangeRate getExchangeRate(CurrencyUnit base, CurrencyUnit term) {
        Objects.requireNonNull(base, "Base Currency is null");
        Objects.requireNonNull(term, "Term Currency is null");
        return this.getExchangeRate(ConversionQueryBuilder.of().setBaseCurrency(base).setTermCurrency(term).build());
    }

    default public CurrencyConversion getCurrencyConversion(CurrencyUnit term) {
        return this.getCurrencyConversion(ConversionQueryBuilder.of().setTermCurrency(term).build());
    }

    default public boolean isAvailable(CurrencyUnit base, CurrencyUnit term) {
        return this.isAvailable(ConversionQueryBuilder.of().setBaseCurrency(base).setTermCurrency(term).build());
    }

    default public boolean isAvailable(String baseCode, String termCode) {
        return this.isAvailable(MonetaryCurrencies.getCurrency(baseCode, new String[0]), MonetaryCurrencies.getCurrency(termCode, new String[0]));
    }

    default public ExchangeRate getExchangeRate(String baseCode, String termCode) {
        return this.getExchangeRate(MonetaryCurrencies.getCurrency(baseCode, new String[0]), MonetaryCurrencies.getCurrency(termCode, new String[0]));
    }

    default public ExchangeRate getReversed(ExchangeRate rate) {
        ConversionQuery reverseQuery = rate.getConversionContext().toQueryBuilder().setBaseCurrency(rate.getCurrency()).setTermCurrency(rate.getBaseCurrency()).build();
        if (this.isAvailable(reverseQuery)) {
            return this.getExchangeRate(reverseQuery);
        }
        return null;
    }

    default public CurrencyConversion getCurrencyConversion(String termCode) {
        return this.getCurrencyConversion(MonetaryCurrencies.getCurrency(termCode, new String[0]));
    }
}

