/*
 * Decompiled with CFR 0.152.
 */
package javax.money.convert;

import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryException;
import javax.money.convert.ConversionContext;

public class CurrencyConversionException
extends MonetaryException {
    private static final long serialVersionUID = -7743240650686883450L;
    private CurrencyUnit base;
    private CurrencyUnit term;
    private ConversionContext conversionContext;

    public CurrencyConversionException(CurrencyUnit base, CurrencyUnit term, ConversionContext conversionContext, String message) {
        super("Cannot convert " + String.valueOf(base) + " into " + String.valueOf(term) + ": " + message);
        this.base = base;
        this.term = term;
        this.conversionContext = conversionContext;
    }

    public CurrencyConversionException(CurrencyUnit base, CurrencyUnit term, ConversionContext conversionContext) {
        super("Cannot convert " + String.valueOf(base) + " into " + String.valueOf(term));
        this.base = base;
        this.term = term;
        this.conversionContext = conversionContext;
    }

    public CurrencyConversionException(CurrencyUnit base, CurrencyUnit term, ConversionContext conversionContext, String message, Throwable cause) {
        super("Cannot convert " + String.valueOf(base) + " into " + String.valueOf(term) + (Objects.nonNull(message) ? ": " + message : ""), cause);
        this.base = base;
        this.term = term;
        this.conversionContext = conversionContext;
    }

    public CurrencyUnit getBaseCurrency() {
        return this.base;
    }

    public CurrencyUnit getTermCurrency() {
        return this.term;
    }

    public ConversionContext getConversionContext() {
        return this.conversionContext;
    }

    @Override
    public String toString() {
        return "CurrencyConversionException [base=" + this.base + ", term=" + this.term + ", conversionContext=" + this.conversionContext + "]: " + this.getMessage();
    }
}

