/*
 * Decompiled with CFR 0.152.
 */
package javax.money.convert;

import javax.money.AbstractContext;
import javax.money.convert.ConversionContextBuilder;
import javax.money.convert.ConversionQueryBuilder;
import javax.money.convert.ProviderContext;
import javax.money.convert.RateType;

public final class ConversionContext
extends AbstractContext {
    private static final long serialVersionUID = 2386546659786888877L;
    public static final ConversionContext ANY_CONVERSION = new ConversionContextBuilder().setRateType(RateType.ANY).build();
    public static final ConversionContext DEFERRED_CONVERSION = new ConversionContextBuilder().setRateType(RateType.DEFERRED).build();
    public static final ConversionContext HISTORIC_CONVERSION = new ConversionContextBuilder().setRateType(RateType.HISTORIC).build();
    public static final ConversionContext REALTIME_CONVERSION = new ConversionContextBuilder().setRateType(RateType.REALTIME).build();
    public static final ConversionContext OTHER_CONVERSION = new ConversionContextBuilder().setRateType(RateType.OTHER).build();

    ConversionContext(ConversionContextBuilder builder) {
        super(builder);
    }

    public RateType getRateType() {
        return this.get(RateType.class);
    }

    @Override
    public String getProvider() {
        return this.getText("provider");
    }

    public ConversionContextBuilder toBuilder() {
        return ConversionContextBuilder.of(this);
    }

    public ConversionQueryBuilder toQueryBuilder() {
        return (ConversionQueryBuilder)ConversionQueryBuilder.of().importContext(this);
    }

    public static ConversionContext of(String provider, RateType rateType) {
        ConversionContextBuilder b = new ConversionContextBuilder();
        b.setRateType(rateType);
        b.setProvider(provider);
        return b.build();
    }

    public static ConversionContext from(ProviderContext providerContext, RateType rateType) {
        return ConversionContextBuilder.create(providerContext, rateType).build();
    }

    public static ConversionContext of(RateType rateType) {
        switch (rateType) {
            default: {
                return ANY_CONVERSION;
            }
            case DEFERRED: {
                return DEFERRED_CONVERSION;
            }
            case HISTORIC: {
                return HISTORIC_CONVERSION;
            }
            case REALTIME: {
                return REALTIME_CONVERSION;
            }
            case OTHER: 
        }
        return OTHER_CONVERSION;
    }

    public static ConversionContext of() {
        return ANY_CONVERSION;
    }
}

