/*
 * Decompiled with CFR 0.152.
 */
package javax.money;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryCurrencies;
import javax.money.MonetaryException;
import javax.money.MonetaryRounding;
import javax.money.RoundingContext;
import javax.money.RoundingContextBuilder;
import javax.money.RoundingQuery;
import javax.money.RoundingQueryBuilder;
import javax.money.spi.Bootstrap;
import javax.money.spi.MonetaryRoundingsSingletonSpi;
import javax.money.spi.RoundingProviderSpi;

public final class MonetaryRoundings {
    private static final MonetaryRounding DEFAULT_ROUNDING = new DefaultCurrencyRounding();
    private static final MonetaryRoundingsSingletonSpi monetaryRoundingsSpi = MonetaryRoundings.loadMonetaryRoundingsSingletonSpi();

    private MonetaryRoundings() {
    }

    private static MonetaryRoundingsSingletonSpi loadMonetaryRoundingsSingletonSpi() {
        try {
            return Bootstrap.getService(MonetaryRoundingsSingletonSpi.class, new DefaultMonetaryRoundingsSingletonSpi());
        }
        catch (Exception e) {
            Logger.getLogger(MonetaryCurrencies.class.getName()).log(Level.SEVERE, "Failed to load MonetaryCurrenciesSingletonSpi, using default.", e);
            return new DefaultMonetaryRoundingsSingletonSpi();
        }
    }

    public static MonetaryRounding getDefaultRounding() {
        return Optional.ofNullable(monetaryRoundingsSpi).orElseThrow(() -> new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.")).getDefaultRounding();
    }

    public static MonetaryRounding getRounding(CurrencyUnit currencyUnit, String ... providers) {
        return Optional.ofNullable(monetaryRoundingsSpi).orElseThrow(() -> new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.")).getRounding(currencyUnit, providers);
    }

    public static MonetaryRounding getRounding(String roundingName, String ... providers) {
        return Optional.ofNullable(monetaryRoundingsSpi).orElseThrow(() -> new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.")).getRounding(roundingName, providers);
    }

    public static MonetaryRounding getRounding(RoundingQuery roundingQuery) {
        return Optional.ofNullable(monetaryRoundingsSpi).orElseThrow(() -> new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.")).getRounding(roundingQuery);
    }

    public static boolean isRoundingAvailable(String roundingName, String ... providers) {
        return Optional.ofNullable(monetaryRoundingsSpi).orElseThrow(() -> new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.")).isRoundingAvailable(roundingName, providers);
    }

    public static boolean isRoundingAvailable(CurrencyUnit currencyUnit, String ... providers) {
        return Optional.ofNullable(monetaryRoundingsSpi).orElseThrow(() -> new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.")).isRoundingAvailable(currencyUnit, providers);
    }

    public static boolean isRoundingAvailable(RoundingQuery roundingQuery) {
        return Optional.ofNullable(monetaryRoundingsSpi).orElseThrow(() -> new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.")).isRoundingAvailable(roundingQuery);
    }

    public static Collection<MonetaryRounding> getRoundings(RoundingQuery roundingQuery) {
        return Optional.ofNullable(monetaryRoundingsSpi).orElseThrow(() -> new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.")).getRoundings(roundingQuery);
    }

    public static Set<String> getRoundingNames(String ... providers) {
        return Optional.ofNullable(monetaryRoundingsSpi).orElseThrow(() -> new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.")).getRoundingNames(providers);
    }

    public static Set<String> getProviderNames() {
        return Optional.ofNullable(monetaryRoundingsSpi).orElseThrow(() -> new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.")).getProviderNames();
    }

    public static List<String> getDefaultProviderChain() {
        return Optional.ofNullable(monetaryRoundingsSpi).orElseThrow(() -> new MonetaryException("No MonetaryRoundingsSpi loaded, query functionality is not available.")).getDefaultProviderChain();
    }

    private static final class DefaultMonetaryRoundingsSingletonSpi
    implements MonetaryRoundingsSingletonSpi {
        private DefaultMonetaryRoundingsSingletonSpi() {
        }

        public RoundingQueryBuilder createRoundingQueryBuilder() {
            throw new IllegalStateException("No MonetaryRoundingsSingletonSpi registered.");
        }

        @Override
        public MonetaryRounding getDefaultRounding() {
            return DEFAULT_ROUNDING;
        }

        @Override
        public Collection<MonetaryRounding> getRoundings(RoundingQuery query) {
            ArrayList<MonetaryRounding> result = new ArrayList<MonetaryRounding>();
            List<String> providerNames = query.getProviders();
            if (providerNames == null || providerNames.isEmpty()) {
                providerNames = this.getDefaultProviderChain();
            }
            for (String providerName : providerNames) {
                Bootstrap.getServices(RoundingProviderSpi.class).stream().filter(prov -> providerName.equals(prov.getProviderName())).forEach(prov -> {
                    try {
                        MonetaryRounding r = prov.getRounding(query);
                        if (r != null) {
                            result.add(r);
                        }
                    }
                    catch (Exception e) {
                        Logger.getLogger(DefaultMonetaryRoundingsSingletonSpi.class.getName()).log(Level.SEVERE, "Error loading RoundingProviderSpi from provider: " + prov, e);
                    }
                });
            }
            return result;
        }

        @Override
        public Set<String> getProviderNames() {
            HashSet<String> result = new HashSet<String>();
            for (RoundingProviderSpi prov : Bootstrap.getServices(RoundingProviderSpi.class)) {
                try {
                    result.add(prov.getProviderName());
                }
                catch (Exception e) {
                    Logger.getLogger(DefaultMonetaryRoundingsSingletonSpi.class.getName()).log(Level.SEVERE, "Error loading RoundingProviderSpi from provider: " + prov, e);
                }
            }
            return result;
        }

        @Override
        public List<String> getDefaultProviderChain() {
            ArrayList<String> result = new ArrayList<String>();
            result.addAll(this.getProviderNames());
            Collections.sort(result);
            return result;
        }

        @Override
        public Set<String> getRoundingNames(String ... providers) {
            HashSet<String> result = new HashSet<String>();
            String[] providerNames = providers;
            if (providerNames.length == 0) {
                providerNames = this.getDefaultProviderChain().toArray(new String[this.getDefaultProviderChain().size()]);
            }
            for (String providerName : providerNames) {
                for (RoundingProviderSpi prov : Bootstrap.getServices(RoundingProviderSpi.class)) {
                    try {
                        if (!prov.getProviderName().equals(providerName) && !prov.getProviderName().matches(providerName)) continue;
                        result.addAll(prov.getRoundingNames());
                    }
                    catch (Exception e) {
                        Logger.getLogger(DefaultMonetaryRoundingsSingletonSpi.class.getName()).log(Level.SEVERE, "Error loading RoundingProviderSpi from provider: " + prov, e);
                    }
                }
            }
            return result;
        }
    }

    private static final class DefaultCurrencyRounding
    implements MonetaryRounding,
    Serializable {
        private static final RoundingContext ROUNDING_CONTEXT = RoundingContextBuilder.of("default", "default").build();

        private DefaultCurrencyRounding() {
        }

        @Override
        public MonetaryAmount apply(MonetaryAmount amount) {
            MonetaryRounding r = MonetaryRoundings.getRounding(amount.getCurrency(), new String[0]);
            return (MonetaryAmount)r.apply(amount);
        }

        @Override
        public RoundingContext getRoundingContext() {
            return ROUNDING_CONTEXT;
        }
    }
}

