/*
 * Decompiled with CFR 0.152.
 */
package javax.money;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.CurrencyQuery;
import javax.money.CurrencyUnit;
import javax.money.MonetaryException;
import javax.money.spi.Bootstrap;
import javax.money.spi.CurrencyProviderSpi;
import javax.money.spi.MonetaryCurrenciesSingletonSpi;

public final class MonetaryCurrencies {
    private static final MonetaryCurrenciesSingletonSpi monetaryCurrenciesSpi = MonetaryCurrencies.loadMonetaryCurrenciesSingletonSpi();

    private MonetaryCurrencies() {
    }

    private static MonetaryCurrenciesSingletonSpi loadMonetaryCurrenciesSingletonSpi() {
        try {
            return Bootstrap.getService(MonetaryCurrenciesSingletonSpi.class, new DefaultMonetaryCurrenciesSingletonSpi());
        }
        catch (Exception e) {
            Logger.getLogger(MonetaryCurrencies.class.getName()).log(Level.SEVERE, "Failed to load MonetaryCurrenciesSingletonSpi, using default.", e);
            return new DefaultMonetaryCurrenciesSingletonSpi();
        }
    }

    public static CurrencyUnit getCurrency(String currencyCode, String ... providers) {
        return Optional.ofNullable(monetaryCurrenciesSpi).orElseThrow(() -> new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.")).getCurrency(currencyCode, providers);
    }

    public static CurrencyUnit getCurrency(Locale locale, String ... providers) {
        return Optional.ofNullable(monetaryCurrenciesSpi).orElseThrow(() -> new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.")).getCurrency(locale, providers);
    }

    public static Set<CurrencyUnit> getCurrencies(Locale locale, String ... providers) {
        return Optional.ofNullable(monetaryCurrenciesSpi).orElseThrow(() -> new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.")).getCurrencies(locale, providers);
    }

    public static boolean isCurrencyAvailable(String code, String ... providers) {
        return Objects.nonNull(monetaryCurrenciesSpi) && monetaryCurrenciesSpi.isCurrencyAvailable(code, providers);
    }

    public static boolean isCurrencyAvailable(Locale locale, String ... providers) {
        return Objects.nonNull(monetaryCurrenciesSpi) && monetaryCurrenciesSpi.isCurrencyAvailable(locale, providers);
    }

    public static Collection<CurrencyUnit> getCurrencies(String ... providers) {
        return Optional.ofNullable(monetaryCurrenciesSpi).orElseThrow(() -> new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.")).getCurrencies(providers);
    }

    public static CurrencyUnit getCurrency(CurrencyQuery query) {
        return Optional.ofNullable(monetaryCurrenciesSpi).orElseThrow(() -> new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.")).getCurrency(query);
    }

    public static Collection<CurrencyUnit> getCurrencies(CurrencyQuery query) {
        return Optional.ofNullable(monetaryCurrenciesSpi).orElseThrow(() -> new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.")).getCurrencies(query);
    }

    public static Set<String> getProviderNames() {
        return Optional.ofNullable(monetaryCurrenciesSpi).orElseThrow(() -> new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.")).getProviderNames();
    }

    public static List<String> getDefaultProviderChain() {
        return Optional.ofNullable(monetaryCurrenciesSpi).orElseThrow(() -> new MonetaryException("No MonetaryCurrenciesSingletonSpi loaded, check your system setup.")).getDefaultProviderChain();
    }

    private static final class DefaultMonetaryCurrenciesSingletonSpi
    implements MonetaryCurrenciesSingletonSpi {
        private DefaultMonetaryCurrenciesSingletonSpi() {
        }

        @Override
        public Set<CurrencyUnit> getCurrencies(CurrencyQuery query) {
            HashSet<CurrencyUnit> result = new HashSet<CurrencyUnit>();
            for (CurrencyProviderSpi spi : Bootstrap.getServices(CurrencyProviderSpi.class)) {
                try {
                    result.addAll(spi.getCurrencies(query));
                }
                catch (Exception e) {
                    Logger.getLogger(DefaultMonetaryCurrenciesSingletonSpi.class.getName()).log(Level.SEVERE, "Error loading currency provider names for " + spi.getClass().getName(), e);
                }
            }
            return result;
        }

        @Override
        public List<String> getDefaultProviderChain() {
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(this.getProviderNames());
            Collections.sort(list);
            return list;
        }

        @Override
        public Set<String> getProviderNames() {
            HashSet<String> result = new HashSet<String>();
            for (CurrencyProviderSpi spi : Bootstrap.getServices(CurrencyProviderSpi.class)) {
                try {
                    result.add(spi.getProviderName());
                }
                catch (Exception e) {
                    Logger.getLogger(DefaultMonetaryCurrenciesSingletonSpi.class.getName()).log(Level.SEVERE, "Error loading currency provider names for " + spi.getClass().getName(), e);
                }
            }
            return result;
        }
    }
}

