/*
 * Decompiled with CFR 0.152.
 */
package javax.money;

import java.util.Collection;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryAmountFactoryQuery;
import javax.money.MonetaryCurrencies;
import javax.money.MonetaryException;
import javax.money.spi.Bootstrap;
import javax.money.spi.MonetaryAmountsSingletonQuerySpi;
import javax.money.spi.MonetaryAmountsSingletonSpi;

public final class MonetaryAmounts {
    private static final MonetaryAmountsSingletonSpi monetaryAmountsSingletonSpi = MonetaryAmounts.loadMonetaryAmountsSingletonSpi();
    private static final MonetaryAmountsSingletonQuerySpi monetaryAmountsSingletonQuerySpi = MonetaryAmounts.loadMonetaryAmountsSingletonQuerySpi();

    private MonetaryAmounts() {
    }

    private static MonetaryAmountsSingletonSpi loadMonetaryAmountsSingletonSpi() {
        try {
            return Bootstrap.getService(MonetaryAmountsSingletonSpi.class);
        }
        catch (Exception e) {
            Logger.getLogger(MonetaryCurrencies.class.getName()).log(Level.SEVERE, "Failed to load MonetaryAmountsSingletonSpi.", e);
            return null;
        }
    }

    private static MonetaryAmountsSingletonQuerySpi loadMonetaryAmountsSingletonQuerySpi() {
        try {
            return Bootstrap.getService(MonetaryAmountsSingletonQuerySpi.class);
        }
        catch (Exception e) {
            Logger.getLogger(MonetaryCurrencies.class.getName()).log(Level.SEVERE, "Failed to load MonetaryAmountsSingletonQuerySpi, query functionality will not be available.", e);
            return null;
        }
    }

    public static <T extends MonetaryAmount> MonetaryAmountFactory<T> getAmountFactory(Class<T> amountType) {
        Optional.ofNullable(monetaryAmountsSingletonSpi).orElseThrow(() -> new MonetaryException("No MonetaryAmountsSingletonSpi loaded."));
        MonetaryAmountFactory<T> factory = monetaryAmountsSingletonSpi.getAmountFactory(amountType);
        return Optional.ofNullable(factory).orElseThrow(() -> new MonetaryException("No AmountFactory available for type: " + amountType.getName()));
    }

    public static MonetaryAmountFactory<?> getDefaultAmountFactory() {
        return Optional.ofNullable(monetaryAmountsSingletonSpi).orElseThrow(() -> new MonetaryException("No MonetaryAmountsSingletonSpi loaded.")).getDefaultAmountFactory();
    }

    public static Collection<MonetaryAmountFactory<?>> getAmountFactories() {
        return Optional.ofNullable(monetaryAmountsSingletonSpi).orElseThrow(() -> new MonetaryException("No MonetaryAmountsSingletonSpi loaded.")).getAmountFactories();
    }

    public static Collection<Class<? extends MonetaryAmount>> getAmountTypes() {
        return Optional.ofNullable(monetaryAmountsSingletonSpi).orElseThrow(() -> new MonetaryException("No MonetaryAmountsSingletonSpi loaded.")).getAmountTypes();
    }

    public static Class<? extends MonetaryAmount> getDefaultAmountType() {
        return Optional.ofNullable(monetaryAmountsSingletonSpi).orElseThrow(() -> new MonetaryException("No MonetaryAmountsSingletonSpi loaded.")).getDefaultAmountType();
    }

    public static MonetaryAmountFactory getAmountFactory(MonetaryAmountFactoryQuery query) {
        return Optional.ofNullable(monetaryAmountsSingletonQuerySpi).orElseThrow(() -> new MonetaryException("No MonetaryAmountsSingletonQuerySpi loaded, query functionality is not available.")).getAmountFactory(query);
    }

    public static Collection<MonetaryAmountFactory<?>> getAmountFactories(MonetaryAmountFactoryQuery query) {
        return Optional.ofNullable(monetaryAmountsSingletonQuerySpi).orElseThrow(() -> new MonetaryException("No MonetaryAmountsSingletonQuerySpi loaded, query functionality is not available.")).getAmountFactories(query);
    }

    public static boolean isAvailable(MonetaryAmountFactoryQuery query) {
        return Optional.ofNullable(monetaryAmountsSingletonQuerySpi).orElseThrow(() -> new MonetaryException("No MonetaryAmountsSingletonQuerySpi loaded, query functionality is not available.")).isAvailable(query);
    }
}

