/*
 * Decompiled with CFR 0.152.
 */
package javax.money;

import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.money.AbstractContextBuilder;
import javax.money.AbstractQuery;

public abstract class AbstractQueryBuilder<B extends AbstractQueryBuilder, C extends AbstractQuery>
extends AbstractContextBuilder<B, C> {
    public B setProviders(String ... providers) {
        return this.setProviders(Arrays.asList(providers));
    }

    public B setProviders(List<String> providers) {
        Objects.requireNonNull(providers);
        return (B)((AbstractQueryBuilder)this.set("Query.providers", providers));
    }

    @Override
    public B setTimestamp(TemporalAccessor timestamp) {
        this.set("Query.timestamp", Objects.requireNonNull(timestamp));
        return (B)this;
    }

    public B set(List<String> providers) {
        return (B)((AbstractQueryBuilder)this.set("Query.providers", providers));
    }

    @Override
    public B setProvider(String provider) {
        return this.setProviders(provider);
    }

    @Override
    public B setTimestampMillis(long timestamp) {
        return (B)((AbstractQueryBuilder)this.set("Query.timestamp", timestamp));
    }

    public B setTimestamp(TemporalUnit timestamp) {
        return (B)((AbstractQueryBuilder)this.set("Query.timestamp", timestamp));
    }

    public B setTargetType(Class<?> type) {
        Objects.requireNonNull(type);
        this.set("Query.targetType", type);
        return (B)this;
    }

    @Override
    public abstract C build();
}

