/*
 * Decompiled with CFR 0.152.
 */
package javax.money;

import java.time.Instant;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Collections;
import java.util.List;
import javax.money.AbstractContext;
import javax.money.AbstractQueryBuilder;

public abstract class AbstractQuery
extends AbstractContext {
    public static final String KEY_QUERY_PROVIDERS = "Query.providers";
    public static final String KEY_QUERY_TIMESTAMP = "Query.timestamp";
    public static final String KEY_QUERY_TARGET_TYPE = "Query.targetType";

    protected AbstractQuery(AbstractQueryBuilder builder) {
        super(builder);
    }

    public List<String> getProviders() {
        List result = this.get(KEY_QUERY_PROVIDERS, List.class);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public Class<?> getTargetType() {
        return this.get(KEY_QUERY_TARGET_TYPE, Class.class);
    }

    @Override
    public Long getTimestampMillis() {
        Object value = this.get(KEY_QUERY_TIMESTAMP, Object.class);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof TemporalAccessor) {
            TemporalAccessor acc = (TemporalAccessor)value;
            return acc.getLong(ChronoField.INSTANT_SECONDS) * 1000L + acc.getLong(ChronoField.MILLI_OF_SECOND);
        }
        return null;
    }

    @Override
    public TemporalAccessor getTimestamp() {
        Object value = this.get(KEY_QUERY_TIMESTAMP, Object.class);
        if (value instanceof TemporalAccessor) {
            return (TemporalAccessor)value;
        }
        if (value instanceof Long) {
            Long ts = (Long)value;
            return Instant.ofEpochMilli(ts);
        }
        return null;
    }
}

